/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.predicate.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.logging.impl.QueryLog;
import org.hibernate.search.backend.lucene.search.common.impl.AbstractLuceneCompositeNodeSearchQueryElementFactory;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexCompositeNodeContext;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneSingleFieldPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.engine.search.common.NonStaticMetamodelScope;
import org.hibernate.search.engine.search.common.spi.SearchQueryElementFactory;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.definition.PredicateDefinition;
import org.hibernate.search.engine.search.predicate.definition.PredicateDefinitionContext;
import org.hibernate.search.engine.search.predicate.definition.TypedPredicateDefinition;
import org.hibernate.search.engine.search.predicate.definition.TypedPredicateDefinitionContext;
import org.hibernate.search.engine.search.predicate.dsl.ExtendedSearchPredicateFactory;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.engine.search.predicate.dsl.TypedSearchPredicateFactory;
import org.hibernate.search.engine.search.predicate.spi.NamedPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.NamedValuesBasedPredicateDefinitionContext;
import org.hibernate.search.engine.search.predicate.spi.NamedValuesBasedTypedPredicateDefinitionContext;

public class LuceneNamedPredicate
extends AbstractLuceneSingleFieldPredicate {
    private final LuceneSearchPredicate instance;

    private LuceneNamedPredicate(Builder builder, LuceneSearchPredicate providedPredicate) {
        super(builder);
        this.instance = providedPredicate;
    }

    @Override
    public void checkNestableWithin(String expectedParentNestedPath) {
        this.instance.checkNestableWithin(expectedParentNestedPath);
        super.checkNestableWithin(expectedParentNestedPath);
    }

    @Override
    protected Query doToQuery(PredicateRequestContext context) {
        return this.instance.toQuery(context);
    }

    private static class TypedBuilder<SR>
    extends Builder {
        private final TypedPredicateDefinition<SR> definition;
        private TypedSearchPredicateFactory<SR> factory;

        TypedBuilder(TypedPredicateDefinition<SR> definition, String predicateName, LuceneSearchIndexScope<?> scope, LuceneSearchIndexCompositeNodeContext node) {
            super(predicateName, scope, node);
            this.definition = definition;
        }

        public void factory(ExtendedSearchPredicateFactory<?, ?> factory) {
            this.factory = factory.withScopeRoot(this.definition.scopeRootType());
        }

        @Override
        protected LuceneSearchPredicate providedPredicate() {
            NamedValuesBasedTypedPredicateDefinitionContext ctx = new NamedValuesBasedTypedPredicateDefinitionContext(this.factory, this.params, name -> QueryLog.INSTANCE.paramNotDefined((String)name, this.predicateName, this.field.eventContext()));
            return LuceneSearchPredicate.from(this.scope, this.definition.create((TypedPredicateDefinitionContext)ctx));
        }
    }

    private static class BasicBuilder
    extends Builder {
        private final PredicateDefinition definition;
        private SearchPredicateFactory factory;

        BasicBuilder(PredicateDefinition definition, String predicateName, LuceneSearchIndexScope<?> scope, LuceneSearchIndexCompositeNodeContext node) {
            super(predicateName, scope, node);
            this.definition = definition;
        }

        public void factory(ExtendedSearchPredicateFactory<?, ?> factory) {
            this.factory = factory.withScopeRoot(NonStaticMetamodelScope.class);
        }

        @Override
        protected LuceneSearchPredicate providedPredicate() {
            NamedValuesBasedPredicateDefinitionContext ctx = new NamedValuesBasedPredicateDefinitionContext(this.factory, this.params, name -> QueryLog.INSTANCE.paramNotDefined((String)name, this.predicateName, this.field.eventContext()));
            return LuceneSearchPredicate.from(this.scope, this.definition.create((PredicateDefinitionContext)ctx));
        }
    }

    private static abstract class Builder
    extends AbstractLuceneSingleFieldPredicate.AbstractBuilder
    implements NamedPredicateBuilder {
        protected final String predicateName;
        protected final LuceneSearchIndexCompositeNodeContext field;
        protected final Map<String, Object> params = new LinkedHashMap<String, Object>();

        Builder(String predicateName, LuceneSearchIndexScope<?> scope, LuceneSearchIndexCompositeNodeContext node) {
            super(scope, node);
            this.predicateName = predicateName;
            this.field = node;
        }

        public final void param(String name, Object value) {
            this.params.put(name, value);
        }

        protected abstract LuceneSearchPredicate providedPredicate();

        public final SearchPredicate build() {
            return new LuceneNamedPredicate(this, this.providedPredicate());
        }
    }

    public static class TypedFactory<SR>
    extends AbstractLuceneCompositeNodeSearchQueryElementFactory<NamedPredicateBuilder> {
        private final TypedPredicateDefinition<SR> definition;
        private final String predicateName;

        public TypedFactory(TypedPredicateDefinition<SR> definition, String predicateName) {
            this.definition = definition;
            this.predicateName = predicateName;
        }

        @Override
        public void checkCompatibleWith(SearchQueryElementFactory<?, ?, ?> other) {
            super.checkCompatibleWith(other);
            TypedFactory castedOther = (TypedFactory)other;
            if (!this.definition.equals(castedOther.definition)) {
                throw QueryLog.INSTANCE.differentPredicateDefinitionForQueryElement(this.definition, castedOther.definition);
            }
        }

        public NamedPredicateBuilder create(LuceneSearchIndexScope<?> scope, LuceneSearchIndexCompositeNodeContext node) {
            return new TypedBuilder<SR>(this.definition, this.predicateName, scope, node);
        }
    }

    public static class Factory
    extends AbstractLuceneCompositeNodeSearchQueryElementFactory<NamedPredicateBuilder> {
        private final PredicateDefinition definition;
        private final String predicateName;

        public Factory(PredicateDefinition definition, String predicateName) {
            this.definition = definition;
            this.predicateName = predicateName;
        }

        @Override
        public void checkCompatibleWith(SearchQueryElementFactory<?, ?, ?> other) {
            super.checkCompatibleWith(other);
            Factory castedOther = (Factory)other;
            if (!this.definition.equals((Object)castedOther.definition)) {
                throw QueryLog.INSTANCE.differentPredicateDefinitionForQueryElement(this.definition, castedOther.definition);
            }
        }

        public NamedPredicateBuilder create(LuceneSearchIndexScope<?> scope, LuceneSearchIndexCompositeNodeContext node) {
            return new BasicBuilder(this.definition, this.predicateName, scope, node);
        }
    }
}

