/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.index.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.store.SleepingLockWrapper;
import org.hibernate.search.backend.lucene.logging.impl.LuceneMiscLog;
import org.hibernate.search.backend.lucene.lowlevel.common.impl.AnalyzerConstants;
import org.hibernate.search.backend.lucene.lowlevel.directory.spi.DirectoryHolder;
import org.hibernate.search.backend.lucene.lowlevel.index.impl.IndexAccessor;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.IndexReaderProvider;
import org.hibernate.search.backend.lucene.lowlevel.writer.impl.IndexWriterDelegator;
import org.hibernate.search.backend.lucene.lowlevel.writer.impl.IndexWriterDelegatorImpl;
import org.hibernate.search.backend.lucene.lowlevel.writer.impl.IndexWriterProvider;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.reporting.EventContext;

public class IndexAccessorImpl
implements AutoCloseable,
IndexAccessor {
    private final EventContext eventContext;
    private final DirectoryHolder directoryHolder;
    private final IndexWriterProvider indexWriterProvider;
    private final IndexReaderProvider indexReaderProvider;

    public IndexAccessorImpl(EventContext eventContext, DirectoryHolder directoryHolder, IndexWriterProvider indexWriterProvider, IndexReaderProvider indexReaderProvider) {
        this.eventContext = eventContext;
        this.directoryHolder = directoryHolder;
        this.indexWriterProvider = indexWriterProvider;
        this.indexReaderProvider = indexReaderProvider;
    }

    @Override
    public void close() throws IOException {
        try (Closer closer = new Closer();){
            closer.push(IndexReaderProvider::clear, (Object)this.indexReaderProvider);
            closer.push(IndexWriterProvider::clear, (Object)this.indexWriterProvider);
        }
    }

    @Override
    public void createIndexIfMissing() {
        try {
            Directory directory = this.directoryHolder.get();
            if (DirectoryReader.indexExists((Directory)directory)) {
                return;
            }
            this.initializeDirectory(directory);
        }
        catch (IOException | RuntimeException e) {
            throw LuceneMiscLog.INSTANCE.unableToInitializeIndexDirectory(e.getMessage(), this.eventContext, e);
        }
    }

    @Override
    public void validateIndexExists() {
        Directory directory = this.directoryHolder.get();
        try {
            if (DirectoryReader.indexExists((Directory)directory)) {
                return;
            }
        }
        catch (IOException | RuntimeException e) {
            throw LuceneMiscLog.INSTANCE.unableToValidateIndexDirectory(e.getMessage(), this.eventContext, e);
        }
        throw LuceneMiscLog.INSTANCE.missingIndex(directory, this.eventContext);
    }

    @Override
    public void dropIndexIfExisting() {
        try {
            String[] files;
            this.close();
            Directory directory = this.directoryHolder.get();
            if (!DirectoryReader.indexExists((Directory)directory)) {
                return;
            }
            for (String file : files = directory.listAll()) {
                directory.deleteFile(file);
            }
            this.close();
        }
        catch (IOException | RuntimeException e) {
            throw LuceneMiscLog.INSTANCE.unableToDropIndexDirectory(e.getMessage(), this.eventContext, e);
        }
    }

    @Override
    public void commit() {
        IndexWriterDelegatorImpl delegator = this.indexWriterProvider.getOrNull();
        if (delegator != null) {
            delegator.commit();
        }
    }

    @Override
    public void commitOrDelay() {
        IndexWriterDelegatorImpl delegator = this.indexWriterProvider.getOrNull();
        if (delegator != null) {
            delegator.commitOrDelay();
        }
    }

    @Override
    public void refresh() {
        try {
            this.indexReaderProvider.clear();
        }
        catch (IOException e) {
            throw LuceneMiscLog.INSTANCE.unableToRefresh(e.getMessage(), this.eventContext, e);
        }
    }

    @Override
    public void mergeSegments() {
        try {
            this.indexReaderProvider.clear();
            this.indexWriterProvider.getOrCreate().mergeSegments();
        }
        catch (IOException e) {
            throw LuceneMiscLog.INSTANCE.unableToMergeSegments(e.getMessage(), this.eventContext, e);
        }
    }

    @Override
    public IndexWriterDelegator getIndexWriterDelegator() throws IOException {
        return this.indexWriterProvider.getOrCreate();
    }

    @Override
    public DirectoryReader getIndexReader() throws IOException {
        return this.indexReaderProvider.getOrCreate();
    }

    @Override
    public void cleanUpAfterFailure(Throwable throwable, Object failingOperation) {
        try {
            this.indexWriterProvider.clearAfterFailure(throwable, failingOperation);
            this.indexReaderProvider.clear();
        }
        catch (IOException | RuntimeException e) {
            throwable.addSuppressed(e);
        }
    }

    @Override
    public long computeSizeInBytes() {
        long totalSize = 0L;
        Directory directory = this.directoryHolder.get();
        try {
            for (String fileName : directory.listAll()) {
                try {
                    totalSize += directory.fileLength(fileName);
                }
                catch (FileNotFoundException | NoSuchFileException iOException) {
                    // empty catch block
                }
            }
        }
        catch (IOException e) {
            throw LuceneMiscLog.INSTANCE.unableToComputeIndexSize(e.getMessage(), this.eventContext, e);
        }
        return totalSize;
    }

    public Directory getDirectoryForTests() {
        return this.directoryHolder.get();
    }

    public IndexWriter getWriterForTests() throws IOException {
        return this.indexWriterProvider.getOrCreate().getDelegateForTests();
    }

    public IndexReader getCurrentReaderForTests() throws IOException {
        return this.indexReaderProvider.getCurrentForTests();
    }

    private void initializeDirectory(Directory directory) throws IOException {
        try {
            IndexWriterConfig iwriterConfig = new IndexWriterConfig(AnalyzerConstants.KEYWORD_ANALYZER).setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
            SleepingLockWrapper delayedDirectory = new SleepingLockWrapper(directory, 2000L, 20L);
            IndexWriter iw = new IndexWriter((Directory)delayedDirectory, iwriterConfig);
            iw.close();
        }
        catch (LockObtainFailedException lofe) {
            LuceneMiscLog.INSTANCE.lockingFailureDuringInitialization(directory.toString(), this.eventContext, (Exception)((Object)lofe));
        }
    }
}

