/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.directory.impl;

import java.io.IOException;
import java.nio.file.Path;
import java.util.function.Supplier;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockFactory;
import org.hibernate.search.backend.lucene.logging.impl.LuceneMiscLog;
import org.hibernate.search.backend.lucene.lowlevel.directory.impl.FileSystemAccessStrategy;
import org.hibernate.search.backend.lucene.lowlevel.directory.impl.FileSystemUtils;
import org.hibernate.search.backend.lucene.lowlevel.directory.spi.DirectoryHolder;
import org.hibernate.search.util.common.reporting.EventContext;

final class LocalFileSystemDirectoryHolder
implements DirectoryHolder {
    private final Path directoryPath;
    private final FileSystemAccessStrategy accessStrategy;
    private final Supplier<LockFactory> lockFactorySupplier;
    private final EventContext eventContext;
    private Directory directory;

    LocalFileSystemDirectoryHolder(Path directoryPath, FileSystemAccessStrategy accessStrategy, Supplier<LockFactory> lockFactorySupplier, EventContext eventContext) {
        this.directoryPath = directoryPath;
        this.accessStrategy = accessStrategy;
        this.lockFactorySupplier = lockFactorySupplier;
        this.eventContext = eventContext;
    }

    @Override
    public void start() throws IOException {
        try {
            FileSystemUtils.initializeWriteableDirectory(this.directoryPath);
        }
        catch (Exception e) {
            throw LuceneMiscLog.INSTANCE.unableToInitializeIndexDirectory(e.getMessage(), this.eventContext, e);
        }
        this.directory = this.accessStrategy.createDirectory(this.directoryPath, this.lockFactorySupplier.get());
    }

    @Override
    public void close() throws IOException {
        if (this.directory != null) {
            this.directory.close();
        }
        this.directory = null;
    }

    @Override
    public Directory get() {
        return this.directory;
    }
}

