/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.logging.impl;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Locale;
import org.apache.lucene.store.Directory;
import org.hibernate.search.backend.lucene.logging.impl.LuceneMiscLog;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.HibernateSearchMultiReader;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.logging.impl.EventContextFormatter;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class LuceneMiscLog_$logger
extends DelegatingBasicLogger
implements LuceneMiscLog,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = LuceneMiscLog_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public LuceneMiscLog_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void indexDirectoryNotFoundCreatingNewOne(Path absolutePath) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.indexDirectoryNotFoundCreatingNewOne$str(), (Object)absolutePath);
    }

    protected String indexDirectoryNotFoundCreatingNewOne$str() {
        return "HSEARCH000041: Index directory does not exist, creating: '%1$s'";
    }

    @Override
    public final void indexWriterResetAfterFailure(EventContext context) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.indexWriterResetAfterFailure$str(), (Object)new EventContextFormatter(context));
    }

    protected String indexWriterResetAfterFailure$str() {
        return "HSEARCH000052: An index writer operation failed. Resetting the index writer and forcing release of locks. %1$s";
    }

    @Override
    public final void unableToCloseIndexReader(EventContext context, Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToCloseIndexReader$str(), (Object)new EventContextFormatter(context));
    }

    protected String unableToCloseIndexReader$str() {
        return "HSEARCH000055: Unable to close the index reader. %1$s";
    }

    protected String unableToLoadResource$str() {
        return "HSEARCH000114: Resource does not exist in classpath: '%1$s'";
    }

    @Override
    public final SearchException unableToLoadResource(String fileName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToLoadResource$str(), fileName));
        LuceneMiscLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    @Override
    public final void lockingFailureDuringInitialization(String directoryDescription, EventContext context, Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.lockingFailureDuringInitialization$str(), (Object)directoryDescription);
    }

    protected String lockingFailureDuringInitialization$str() {
        return "HSEARCH000225: Unable to acquire lock on the index while initializing directory '%s'. Either the directory wasn't properly closed last time it was used due to a critical failure, or another instance of Hibernate Search is using it concurrently (which is not supported). If you experience indexing failures on this index you will need to remove the lock, and might need to rebuild the index.";
    }

    protected String unableToOpenIndexReaders$str() {
        return "HSEARCH000284: Unable to open index readers: %1$s";
    }

    @Override
    public final SearchException unableToOpenIndexReaders(String causeMessage, EventContext context, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToOpenIndexReaders$str(), causeMessage), (Throwable)cause, context);
        LuceneMiscLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String pathIsNotWriteableDirectory$str() {
        return "HSEARCH600001: Path '%1$s' exists but does not point to a writable directory.";
    }

    @Override
    public final SearchException pathIsNotWriteableDirectory(Path rootDirectory) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.pathIsNotWriteableDirectory$str(), rootDirectory));
        LuceneMiscLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String luceneExtensionOnUnknownType$str() {
        return "HSEARCH600005: Invalid target for Lucene extension: '%1$s'. This extension can only be applied to components created by a Lucene backend.";
    }

    @Override
    public final SearchException luceneExtensionOnUnknownType(Object context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.luceneExtensionOnUnknownType$str(), context));
        LuceneMiscLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToInitializeIndexDirectory$str() {
        return "HSEARCH600015: Unable to initialize index directory: %1$s";
    }

    @Override
    public final SearchException unableToInitializeIndexDirectory(String causeMessage, EventContext context, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToInitializeIndexDirectory$str(), causeMessage), (Throwable)cause, context);
        LuceneMiscLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String backendUnwrappingWithUnknownType$str() {
        return "HSEARCH600033: Invalid requested type for this backend: '%1$s'. Lucene backends can only be unwrapped to '%2$s'.";
    }

    @Override
    public final SearchException backendUnwrappingWithUnknownType(Class<?> requestedClass, Class<?> actualClass, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.backendUnwrappingWithUnknownType$str(), new ClassFormatter(requestedClass), new ClassFormatter(actualClass)), context);
        LuceneMiscLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String indexManagerUnwrappingWithUnknownType$str() {
        return "HSEARCH600051: Invalid requested type for this index manager: '%1$s'. Lucene index managers can only be unwrapped to '%2$s'.";
    }

    @Override
    public final SearchException indexManagerUnwrappingWithUnknownType(Class<?> requestedClass, Class<?> actualClass, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.indexManagerUnwrappingWithUnknownType$str(), new ClassFormatter(requestedClass), new ClassFormatter(actualClass)), context);
        LuceneMiscLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToShutdownShard$str() {
        return "HSEARCH600061: Unable to shut down index: %1$s";
    }

    @Override
    public final SearchException unableToShutdownShard(String causeMessage, EventContext context, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToShutdownShard$str(), causeMessage), (Throwable)cause, context);
        LuceneMiscLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToMergeSegments$str() {
        return "HSEARCH600078: Unable to merge index segments: %1$s";
    }

    @Override
    public final SearchException unableToMergeSegments(String causeMessage, EventContext context, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToMergeSegments$str(), causeMessage), (Throwable)cause, context);
        LuceneMiscLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToCloseIndexWriterAfterFailures$str() {
        return "HSEARCH600079: Unable to close the index writer after write failures: %1$s";
    }

    @Override
    public final SearchException unableToCloseIndexWriterAfterFailures(String causeMessage, EventContext context, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToCloseIndexWriterAfterFailures$str(), causeMessage), (Throwable)cause, context);
        LuceneMiscLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String missingIndex$str() {
        return "HSEARCH600109: Index does not exist for directory '%1$s'";
    }

    @Override
    public final SearchException missingIndex(Directory directory, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingIndex$str(), directory), context);
        LuceneMiscLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToValidateIndexDirectory$str() {
        return "HSEARCH600110: Unable to validate index directory: %1$s";
    }

    @Override
    public final SearchException unableToValidateIndexDirectory(String causeMessage, EventContext context, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToValidateIndexDirectory$str(), causeMessage), (Throwable)cause, context);
        LuceneMiscLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToDropIndexDirectory$str() {
        return "HSEARCH600111: Unable to drop index directory: %1$s";
    }

    @Override
    public final SearchException unableToDropIndexDirectory(String causeMessage, EventContext context, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToDropIndexDirectory$str(), causeMessage), (Throwable)cause, context);
        LuceneMiscLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String uncommittedOperationsBecauseOfFailure$str() {
        return "HSEARCH600118: A failure occurred during a low-level write operation and the index writer had to be reset. Some write operations may have been lost as a result. Failure: %1$s";
    }

    @Override
    public final SearchException uncommittedOperationsBecauseOfFailure(String causeMessage, EventContext context, Throwable cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.uncommittedOperationsBecauseOfFailure$str(), causeMessage), cause, context);
        LuceneMiscLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToComputeIndexSize$str() {
        return "HSEARCH600141: Unable to compute size of index: %1$s";
    }

    @Override
    public final SearchException unableToComputeIndexSize(String causeMessage, EventContext context, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToComputeIndexSize$str(), causeMessage), (Throwable)cause, context);
        LuceneMiscLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToStartShard$str() {
        return "HSEARCH600154: Unable to start index: %1$s";
    }

    @Override
    public final SearchException unableToStartShard(String causeMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToStartShard$str(), causeMessage), (Throwable)cause);
        LuceneMiscLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String nonblockingOperationSubmitterNotSupported$str() {
        return "HSEARCH600156: Nonblocking operation submitter is not supported.";
    }

    @Override
    public final SearchException nonblockingOperationSubmitterNotSupported() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nonblockingOperationSubmitterNotSupported$str(), new Object[0]));
        LuceneMiscLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToExportSchema$str() {
        return "HSEARCH600157: Unable to export the schema for '%1$s' index: %2$s";
    }

    @Override
    public final SearchException unableToExportSchema(String indexName, String message, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToExportSchema$str(), indexName, message), (Throwable)cause);
        LuceneMiscLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToRefresh$str() {
        return "HSEARCH600187: Unable to refresh an index reader: %1$s";
    }

    @Override
    public final SearchException unableToRefresh(String causeMessage, EventContext context, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToRefresh$str(), causeMessage), (Throwable)cause, context);
        LuceneMiscLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void closingMultiReader(HibernateSearchMultiReader hibernateSearchMultiReader) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.closingMultiReader$str(), (Object)hibernateSearchMultiReader);
    }

    protected String closingMultiReader$str() {
        return "HSEARCH600189: Closing MultiReader: %s";
    }

    @Override
    public final void closedMultiReader(HibernateSearchMultiReader hibernateSearchMultiReader) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.closedMultiReader$str(), (Object)hibernateSearchMultiReader);
    }

    protected String closedMultiReader$str() {
        return "HSEARCH600190: MultiReader closed: %s";
    }

    @Override
    public final void closedIndexWriter() {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.closedIndexWriter$str(), new Object[0]);
    }

    protected String closedIndexWriter$str() {
        return "HSEARCH600191: IndexWriter closed";
    }

    @Override
    public final void openedIndexWriter() {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.openedIndexWriter$str(), new Object[0]);
    }

    protected String openedIndexWriter$str() {
        return "HSEARCH600192: IndexWriter opened";
    }

    @Override
    public final void indexWriterSetParameter(String settingName, Object value, String context) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.indexWriterSetParameter$str(), (Object)settingName, value, (Object)context);
    }

    protected String indexWriterSetParameter$str() {
        return "HSEARCH600193: Set index writer parameter %s to value : %s. %s";
    }
}

