/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.logging.impl;

import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import org.apache.lucene.store.Directory;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.HibernateSearchMultiReader;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.CategorizedLogger;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.logging.impl.EventContextFormatter;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;

@CategorizedLogger(category="org.hibernate.search.lucene", description="The main category for the Lucene backend-specific logs.\nIt may also include logs that do not fit any other, more specific, Lucene category.\n")
@MessageLogger(projectCode="HSEARCH")
public interface LuceneMiscLog
extends BasicLogger {
    public static final String CATEGORY_NAME = "org.hibernate.search.lucene";
    public static final LuceneMiscLog INSTANCE = (LuceneMiscLog)LoggerFactory.make(LuceneMiscLog.class, (String)"org.hibernate.search.lucene", (MethodHandles.Lookup)MethodHandles.lookup());

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=41, value="Index directory does not exist, creating: '%1$s'")
    public void indexDirectoryNotFoundCreatingNewOne(Path var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=52, value="An index writer operation failed. Resetting the index writer and forcing release of locks. %1$s")
    public void indexWriterResetAfterFailure(@FormatWith(value=EventContextFormatter.class) EventContext var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=55, value="Unable to close the index reader. %1$s")
    public void unableToCloseIndexReader(@FormatWith(value=EventContextFormatter.class) EventContext var1, @Cause Exception var2);

    @Message(id=114, value="Resource does not exist in classpath: '%1$s'")
    public SearchException unableToLoadResource(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=225, value="Unable to acquire lock on the index while initializing directory '%s'. Either the directory wasn't properly closed last time it was used due to a critical failure, or another instance of Hibernate Search is using it concurrently (which is not supported). If you experience indexing failures on this index you will need to remove the lock, and might need to rebuild the index.")
    public void lockingFailureDuringInitialization(String var1, @Param EventContext var2, @Cause Exception var3);

    @Message(id=284, value="Unable to open index readers: %1$s")
    public SearchException unableToOpenIndexReaders(String var1, @Param EventContext var2, @Cause Exception var3);

    @Message(id=600001, value="Path '%1$s' exists but does not point to a writable directory.")
    public SearchException pathIsNotWriteableDirectory(Path var1);

    @Message(id=600005, value="Invalid target for Lucene extension: '%1$s'. This extension can only be applied to components created by a Lucene backend.")
    public SearchException luceneExtensionOnUnknownType(Object var1);

    @Message(id=600015, value="Unable to initialize index directory: %1$s")
    public SearchException unableToInitializeIndexDirectory(String var1, @Param EventContext var2, @Cause Exception var3);

    @Message(id=600033, value="Invalid requested type for this backend: '%1$s'. Lucene backends can only be unwrapped to '%2$s'.")
    public SearchException backendUnwrappingWithUnknownType(@FormatWith(value=ClassFormatter.class) Class<?> var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, @Param EventContext var3);

    @Message(id=600051, value="Invalid requested type for this index manager: '%1$s'. Lucene index managers can only be unwrapped to '%2$s'.")
    public SearchException indexManagerUnwrappingWithUnknownType(@FormatWith(value=ClassFormatter.class) Class<?> var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, @Param EventContext var3);

    @Message(id=600061, value="Unable to shut down index: %1$s")
    public SearchException unableToShutdownShard(String var1, @Param EventContext var2, @Cause Exception var3);

    @Message(id=600078, value="Unable to merge index segments: %1$s")
    public SearchException unableToMergeSegments(String var1, @Param EventContext var2, @Cause Exception var3);

    @Message(id=600079, value="Unable to close the index writer after write failures: %1$s")
    public SearchException unableToCloseIndexWriterAfterFailures(String var1, @Param EventContext var2, @Cause Exception var3);

    @Message(id=600109, value="Index does not exist for directory '%1$s'")
    public SearchException missingIndex(Directory var1, @Param EventContext var2);

    @Message(id=600110, value="Unable to validate index directory: %1$s")
    public SearchException unableToValidateIndexDirectory(String var1, @Param EventContext var2, @Cause Exception var3);

    @Message(id=600111, value="Unable to drop index directory: %1$s")
    public SearchException unableToDropIndexDirectory(String var1, @Param EventContext var2, @Cause Exception var3);

    @Message(id=600118, value="A failure occurred during a low-level write operation and the index writer had to be reset. Some write operations may have been lost as a result. Failure: %1$s")
    public SearchException uncommittedOperationsBecauseOfFailure(String var1, @Param EventContext var2, @Cause Throwable var3);

    @Message(id=600141, value="Unable to compute size of index: %1$s")
    public SearchException unableToComputeIndexSize(String var1, @Param EventContext var2, @Cause Exception var3);

    @Message(id=600154, value="Unable to start index: %1$s")
    public SearchException unableToStartShard(String var1, @Cause Exception var2);

    @Message(id=600156, value="Nonblocking operation submitter is not supported.")
    public SearchException nonblockingOperationSubmitterNotSupported();

    @Message(id=600157, value="Unable to export the schema for '%1$s' index: %2$s")
    public SearchException unableToExportSchema(String var1, String var2, @Cause Exception var3);

    @Message(id=600187, value="Unable to refresh an index reader: %1$s")
    public SearchException unableToRefresh(String var1, @Param EventContext var2, @Cause Exception var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=600189, value="Closing MultiReader: %s")
    public void closingMultiReader(HibernateSearchMultiReader var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=600190, value="MultiReader closed: %s")
    public void closedMultiReader(HibernateSearchMultiReader var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=600191, value="IndexWriter closed")
    public void closedIndexWriter();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=600192, value="IndexWriter opened")
    public void openedIndexWriter();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=600193, value="Set index writer parameter %s to value : %s. %s")
    public void indexWriterSetParameter(String var1, Object var2, String var3);
}

