/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.analysis.impl;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.hibernate.search.backend.lucene.logging.impl.AnalysisLog;

final class HibernateSearchNormalizerCheckingFilter
extends TokenFilter {
    private static final char TOKEN_SEPARATOR = ' ';
    private final String normalizerName;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final StringBuilder concatenatedTokenBuilder = new StringBuilder();

    HibernateSearchNormalizerCheckingFilter(TokenStream input, String normalizerName) {
        super(input);
        this.normalizerName = normalizerName;
    }

    public boolean equals(Object obj) {
        return obj != null && ((Object)((Object)this)).getClass().equals(obj.getClass()) && this.normalizerName.equals(((HibernateSearchNormalizerCheckingFilter)((Object)obj)).normalizerName) && super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode() * 31 + this.normalizerName.hashCode();
    }

    public boolean incrementToken() throws IOException {
        int tokenCount = 0;
        this.concatenatedTokenBuilder.setLength(0);
        while (this.input.incrementToken()) {
            if (++tokenCount > 1) {
                this.concatenatedTokenBuilder.append(' ');
            }
            this.concatenatedTokenBuilder.append((CharSequence)this.termAtt);
        }
        if (tokenCount > 1) {
            this.termAtt.setEmpty().append(this.concatenatedTokenBuilder);
            AnalysisLog.INSTANCE.normalizerProducedMultipleTokens(this.normalizerName, tokenCount);
        }
        return tokenCount > 0;
    }
}

