/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.collector.impl;

import java.util.Collection;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorKey;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.NumericTermsCollector;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.TermResults;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.LongMultiValuesSource;

public class NumericTermsCollectorManager
implements CollectorManager<NumericTermsCollector, TermResults> {
    private final LongMultiValuesSource valuesSource;
    private final CollectorKey<?, ?>[] keys;
    private final CollectorManager<Collector, ?>[] managers;

    public NumericTermsCollectorManager(LongMultiValuesSource valuesSource, CollectorKey<?, ?>[] keys, CollectorManager<Collector, ?>[] managers) {
        this.valuesSource = valuesSource;
        this.keys = keys;
        this.managers = managers;
    }

    public NumericTermsCollector newCollector() {
        return new NumericTermsCollector(this.valuesSource, this.keys, this.managers);
    }

    public TermResults reduce(Collection<NumericTermsCollector> collection) {
        if (collection.isEmpty()) {
            return TermResults.EMPTY;
        }
        TermResults results = new TermResults(this.keys, this.managers);
        for (NumericTermsCollector collector : collection) {
            results.add(collector.segmentValues());
        }
        return results;
    }
}

