/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.aggregation.collector.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Supplier;
import org.apache.lucene.search.CollectorManager;
import org.hibernate.search.backend.lucene.lowlevel.aggregation.collector.impl.AggregationFunction;
import org.hibernate.search.backend.lucene.lowlevel.aggregation.collector.impl.AggregationFunctionCollector;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.JoiningLongMultiValuesSource;

public class AggregationFunctionCollectorManager<T extends AggregationFunction<?>>
implements CollectorManager<AggregationFunctionCollector<T>, Long> {
    private final JoiningLongMultiValuesSource source;
    private final Supplier<AggregationFunction<T>> functionSupplier;

    public AggregationFunctionCollectorManager(JoiningLongMultiValuesSource source, Supplier<AggregationFunction<T>> functionSupplier) {
        this.source = source;
        this.functionSupplier = functionSupplier;
    }

    public AggregationFunctionCollector<T> newCollector() {
        return new AggregationFunctionCollector<T>(this.source, this.functionSupplier.get());
    }

    public Long reduce(Collection<AggregationFunctionCollector<T>> collectors) throws IOException {
        if (collectors.isEmpty()) {
            return null;
        }
        Iterator<AggregationFunctionCollector<T>> iterator = collectors.iterator();
        AggregationFunctionCollector<T> identity = iterator.next();
        while (iterator.hasNext()) {
            identity.merge(iterator.next());
        }
        return identity.result();
    }
}

