/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.document.model.dsl.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionRegistry;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.AbstractLuceneIndexCompositeNodeBuilder;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.LuceneIndexNodeCollector;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexField;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexModel;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexObjectField;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexObjectFieldTemplate;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexRoot;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexValueField;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexValueFieldTemplate;
import org.hibernate.search.backend.lucene.types.aggregation.impl.LuceneCountDocumentAggregation;
import org.hibernate.search.backend.lucene.types.dsl.LuceneIndexFieldTypeFactory;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIndexFieldTypeFactoryImpl;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexCompositeNodeType;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexRootBuilder;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaBuildContext;
import org.hibernate.search.engine.backend.document.model.spi.IndexIdentifier;
import org.hibernate.search.engine.backend.mapping.spi.BackendMapperContext;
import org.hibernate.search.engine.backend.types.ObjectStructure;
import org.hibernate.search.engine.backend.types.converter.FromDocumentValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentValueConverter;
import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexFieldTypeDefaultsProvider;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.aggregation.spi.AggregationTypeKeys;
import org.hibernate.search.util.common.reporting.EventContext;

public class LuceneIndexRootBuilder
extends AbstractLuceneIndexCompositeNodeBuilder
implements IndexRootBuilder,
IndexSchemaBuildContext {
    private final EventContext indexEventContext;
    private final BackendMapperContext backendMapperContext;
    private final String mappedTypeName;
    private final LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry;
    private DslConverter<?, String> idDslConverter;
    private DslConverter<?, String> idParser;
    private ProjectionConverter<String, ?> idProjectionConverter;

    public LuceneIndexRootBuilder(EventContext indexEventContext, BackendMapperContext backendMapperContext, String mappedTypeName, LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry) {
        super(new LuceneIndexCompositeNodeType.Builder(ObjectStructure.FLATTENED));
        this.indexEventContext = indexEventContext;
        this.backendMapperContext = backendMapperContext;
        this.mappedTypeName = mappedTypeName;
        this.analysisDefinitionRegistry = analysisDefinitionRegistry;
        this.typeBuilder.queryElementFactory(AggregationTypeKeys.COUNT_DOCUMENTS, LuceneCountDocumentAggregation.factory());
    }

    public EventContext eventContext() {
        return this.getIndexEventContext().append(EventContexts.indexSchemaRoot());
    }

    public LuceneIndexFieldTypeFactory createTypeFactory(IndexFieldTypeDefaultsProvider defaultsProvider) {
        return new LuceneIndexFieldTypeFactoryImpl(this.indexEventContext, this.backendMapperContext, this.analysisDefinitionRegistry, defaultsProvider);
    }

    public void explicitRouting() {
    }

    public <I> void idDslConverter(Class<I> valueType, ToDocumentValueConverter<I, String> converter) {
        this.idDslConverter = new DslConverter(valueType, converter);
    }

    public void idParser(ToDocumentValueConverter<String, String> converter) {
        this.idParser = new DslConverter(String.class, converter);
    }

    public <I> void idProjectionConverter(Class<I> valueType, FromDocumentValueConverter<String, I> converter) {
        this.idProjectionConverter = new ProjectionConverter(valueType, converter);
    }

    @Override
    public LuceneIndexRootBuilder getRootNodeBuilder() {
        return this;
    }

    public LuceneIndexModel build(String indexName) {
        IndexIdentifier identifier = new IndexIdentifier(this.idDslConverter, this.idParser, this.idProjectionConverter);
        final HashMap<String, LuceneIndexField> staticFields = new HashMap<String, LuceneIndexField>();
        final ArrayList fieldTemplates = new ArrayList();
        final boolean[] hasNestedDocument = new boolean[1];
        LuceneIndexNodeCollector collector = new LuceneIndexNodeCollector(){

            @Override
            public void collect(String absoluteFieldPath, LuceneIndexValueField<?> node) {
                staticFields.put(absoluteFieldPath, node);
            }

            @Override
            public void collect(String absolutePath, LuceneIndexObjectField node) {
                staticFields.put(absolutePath, node);
                if (((LuceneIndexCompositeNodeType)node.type()).nested()) {
                    hasNestedDocument[0] = true;
                }
            }

            @Override
            public void collect(LuceneIndexObjectFieldTemplate template) {
                fieldTemplates.add(template);
                if (((LuceneIndexCompositeNodeType)template.type()).nested()) {
                    hasNestedDocument[0] = true;
                }
            }

            @Override
            public void collect(LuceneIndexValueFieldTemplate template) {
                fieldTemplates.add(template);
            }
        };
        TreeMap<String, LuceneIndexField> staticChildrenByName = new TreeMap<String, LuceneIndexField>();
        LuceneIndexRoot rootNode = new LuceneIndexRoot(this.typeBuilder.build(), staticChildrenByName);
        this.contributeChildren(rootNode, collector, staticChildrenByName);
        return new LuceneIndexModel(this.analysisDefinitionRegistry, indexName, this.mappedTypeName, identifier, rootNode, staticFields, fieldTemplates, hasNestedDocument[0]);
    }

    @Override
    String getAbsolutePath() {
        return null;
    }

    EventContext getIndexEventContext() {
        return this.indexEventContext;
    }
}

