/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.document.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.backend.lucene.logging.impl.IndexingLog;
import org.hibernate.search.backend.lucene.lowlevel.common.impl.MetadataFields;
import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneDocumentContent;

public class LuceneDocumentContentImpl
implements LuceneDocumentContent {
    private final Document document = new Document();
    private final Map<String, EncounteredFieldStatus> fieldStatus = new HashMap<String, EncounteredFieldStatus>();

    @Override
    public void addField(IndexableField field) {
        this.document.add(field);
    }

    @Override
    public void addFieldName(String absoluteFieldPath) {
        this.fieldStatus.put(absoluteFieldPath, EncounteredFieldStatus.ENCOUNTERED_AND_NAME_INDEXED);
    }

    void checkNoValueYetForSingleValued(String absoluteFieldPath) {
        EncounteredFieldStatus previousValue = this.fieldStatus.putIfAbsent(absoluteFieldPath, EncounteredFieldStatus.ENCOUNTERED);
        if (previousValue != null) {
            throw IndexingLog.INSTANCE.multipleValuesForSingleValuedField(absoluteFieldPath);
        }
    }

    Document finalizeDocument(MultiTenancyStrategy multiTenancyStrategy, String tenantId, String routingKey) {
        for (Map.Entry<String, EncounteredFieldStatus> entry : this.fieldStatus.entrySet()) {
            EncounteredFieldStatus status = entry.getValue();
            if (!EncounteredFieldStatus.ENCOUNTERED_AND_NAME_INDEXED.equals((Object)status)) continue;
            String fieldName = entry.getKey();
            this.document.add(MetadataFields.searchableMetadataField(MetadataFields.fieldNamesFieldName(), fieldName));
        }
        if (routingKey != null) {
            this.document.add(MetadataFields.searchableMetadataField(MetadataFields.routingKeyFieldName(), routingKey));
        }
        multiTenancyStrategy.contributeToIndexedDocument(this.document, tenantId);
        return this.document;
    }

    private static enum EncounteredFieldStatus {
        ENCOUNTERED,
        ENCOUNTERED_AND_NAME_INDEXED;

    }
}

