/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.work.impl;

import java.io.IOException;
import org.apache.lucene.search.IndexSearcher;
import org.hibernate.search.backend.lucene.logging.impl.QueryLog;
import org.hibernate.search.backend.lucene.work.impl.LuceneSearcher;
import org.hibernate.search.backend.lucene.work.impl.ReadWork;
import org.hibernate.search.backend.lucene.work.impl.ReadWorkExecutionContext;

public class SearchWork<R>
implements ReadWork<R> {
    private final LuceneSearcher<R, ?> searcher;
    private final int offset;
    private final Integer limit;
    private final int totalHitCountThreshold;

    SearchWork(LuceneSearcher<R, ?> searcher, Integer offset, Integer limit, int totalHitCountThreshold) {
        this.offset = offset == null ? 0 : offset;
        this.limit = limit;
        this.searcher = searcher;
        this.totalHitCountThreshold = totalHitCountThreshold;
    }

    @Override
    public R execute(ReadWorkExecutionContext context) {
        try {
            IndexSearcher indexSearcher = context.createSearcher();
            return this.searcher.search(indexSearcher, context.getIndexReaderMetadataResolver(), this.offset, this.limit, this.totalHitCountThreshold);
        }
        catch (IOException e) {
            throw QueryLog.INSTANCE.ioExceptionOnQueryExecution(this.searcher.getLuceneQueryForExceptions(), e.getMessage(), context.getEventContext(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("searcher=").append(this.searcher).append(", offset=").append(this.offset).append(", limit=").append(this.limit).append(", totalHitCountThreshold=").append(this.totalHitCountThreshold).append("]");
        return sb.toString();
    }
}

