/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.logging.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.CategorizedLogger;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;

@CategorizedLogger(category="org.hibernate.search.indexing.lucene")
@MessageLogger(projectCode="HSEARCH")
public interface IndexingLog {
    public static final String CATEGORY_NAME = "org.hibernate.search.indexing.lucene";
    public static final IndexingLog INSTANCE = (IndexingLog)LoggerFactory.make(IndexingLog.class, (String)"org.hibernate.search.indexing.lucene", (MethodHandles.Lookup)MethodHandles.lookup());

    @Message(id=600016, value="Unable to index entity of type '%2$s' with identifier '%3$s' and tenant identifier '%1$s': %4$s")
    public SearchException unableToIndexEntry(String var1, String var2, Object var3, String var4, @Param EventContext var5, @Cause Exception var6);

    @Message(id=600017, value="Unable to delete entity of type '%2$s' with identifier '%3$s' and tenant identifier '%1$s': %4$s")
    public SearchException unableToDeleteEntryFromIndex(String var1, String var2, Object var3, String var4, @Param EventContext var5, @Cause Exception var6);

    @Message(id=600019, value="Unable to commit: %1$s")
    public SearchException unableToCommitIndex(String var1, @Param EventContext var2, @Cause Exception var3);

    @Message(id=600039, value="Invalid field reference for this document element: this document element has path '%1$s', but the referenced field has a parent with path '%2$s'.")
    public SearchException invalidFieldForDocumentElement(String var1, String var2);

    @Message(id=600049, value="Invalid field path; expected path '%1$s', got '%2$s'.")
    public SearchException invalidFieldPath(String var1, String var2);

    @Message(id=600050, value="Unable to convert DSL argument: %1$s")
    public SearchException cannotConvertDslParameter(String var1, @Cause Exception var2, @Param EventContext var3);

    @Message(id=600074, value="Multiple values assigned to field '%1$s': this field is single-valued. Declare the field as multi-valued in order to allow this.")
    public SearchException multipleValuesForSingleValuedField(String var1);

    @Message(id=600081, value="Unable to encode value '%1$s': this field type only supports values ranging from '%2$s' to '%3$s'. If you want to encode values that are outside this range, change the decimal scale for this field. Do not forget to reindex all your data after changing the decimal scale.")
    public SearchException scaledNumberTooLarge(Number var1, Number var2, Number var3);

    @Message(id=600126, value="Invalid value type. This field's values are of type '%1$s', which is not assignable from '%2$s'.")
    public SearchException invalidFieldValueType(@FormatWith(value=ClassFormatter.class) Class<?> var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, @Param EventContext var3);

    @Message(id=600127, value="Unknown field '%1$s'.")
    public SearchException unknownFieldForIndexing(String var1, @Param EventContext var2);

    @Message(id=600184, value="The cosine vector similarity cannot process vectors with 0 magnitude. The vector violating this constraint is %1$s.")
    public SearchException vectorCosineZeroMagnitudeNotAcceptable(Object var1);

    @Message(id=600185, value="The dot product vector similarity cannot process non-unit magnitude vectors. The vector violating this constraint is %1$s.")
    public SearchException vectorDotProductNonUnitMagnitudeNotAcceptable(Object var1);
}

