package org.hibernate.search.backend.lucene.reporting.impl;

import java.util.Locale;
import java.io.Serializable;
import org.hibernate.search.engine.backend.reporting.spi.BackendSearchHints;
import java.lang.String;

/**
 * Warning this class consists of generated code.
 */
public class LuceneSearchHints_$bundle implements LuceneSearchHints, BackendSearchHints, Serializable {
    private static final long serialVersionUID = 1L;
    protected LuceneSearchHints_$bundle() {}
    public static final LuceneSearchHints_$bundle INSTANCE = new LuceneSearchHints_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String documentProjectionNestingNotSupportedHint$str() {
        return "A document projection represents a root document and adding it as a part of the nested object projection might produce misleading results.";
    }
    @Override
    public final String documentProjectionNestingNotSupportedHint() {
        return String.format(getLoggingLocale(), documentProjectionNestingNotSupportedHint$str());
    }
    protected String indexMergeOperation$str() {
        return "Index Merge operation on index '%1$s'";
    }
    @Override
    public final String indexMergeOperation(final String indexName) {
        return String.format(getLoggingLocale(), indexMergeOperation$str(), indexName);
    }
    protected String missingSupportHintForObjectProjectionOnMultiValuedFlattenedObjectNode$str() {
        return "This multi-valued field has a 'FLATTENED' structure, which means the structure of objects is not preserved upon indexing, making object projections impossible. Try setting the field structure to 'NESTED' and reindexing all your data.";
    }
    @Override
    public final String missingSupportHintForObjectProjectionOnMultiValuedFlattenedObjectNode() {
        return String.format(getLoggingLocale(), missingSupportHintForObjectProjectionOnMultiValuedFlattenedObjectNode$str());
    }
    protected String idProjectionNestingNotSupportedHint$str() {
        return "An ID projection represents the document ID and adding it as a part of the nested object projection might produce misleading results since it is always a root document ID and not a nested object ID.";
    }
    @Override
    public final String idProjectionNestingNotSupportedHint() {
        return String.format(getLoggingLocale(), idProjectionNestingNotSupportedHint$str());
    }
    protected String documentReferenceProjectionNestingNotSupportedHint$str() {
        return "A document reference projection represents a root document and adding it as a part of the nested object projection might produce misleading results.";
    }
    @Override
    public final String documentReferenceProjectionNestingNotSupportedHint() {
        return String.format(getLoggingLocale(), documentReferenceProjectionNestingNotSupportedHint$str());
    }
    protected String entityProjectionNestingNotSupportedHint$str() {
        return "An entity projection represents a root entity and adding it as a part of the nested object projection might produce misleading results.";
    }
    @Override
    public final String entityProjectionNestingNotSupportedHint() {
        return String.format(getLoggingLocale(), entityProjectionNestingNotSupportedHint$str());
    }
    protected String entityReferenceProjectionNestingNotSupportedHint$str() {
        return "An entity reference projection represents a root entity and adding it as a part of the nested object projection might produce misleading results.";
    }
    @Override
    public final String entityReferenceProjectionNestingNotSupportedHint() {
        return String.format(getLoggingLocale(), entityReferenceProjectionNestingNotSupportedHint$str());
    }
    protected String explanationProjectionNestingNotSupportedHint$str() {
        return "An explanation projection describes the score computation for the hit and adding it as a part of the nested object projection might produce misleading results.";
    }
    @Override
    public final String explanationProjectionNestingNotSupportedHint() {
        return String.format(getLoggingLocale(), explanationProjectionNestingNotSupportedHint$str());
    }
    protected String scoreProjectionNestingNotSupportedHint$str() {
        return "A score projection provides the score for the entire hit and adding it as a part of the nested object projection might produce misleading results.";
    }
    @Override
    public final String scoreProjectionNestingNotSupportedHint() {
        return String.format(getLoggingLocale(), scoreProjectionNestingNotSupportedHint$str());
    }
}
