package org.hibernate.search.backend.lucene.logging.impl;

import java.util.Locale;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import java.io.Serializable;
import java.util.Set;
import org.apache.lucene.search.Query;
import org.hibernate.search.engine.search.highlighter.SearchHighlighter;
import org.hibernate.search.backend.lucene.index.LuceneIndexManager;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import java.lang.String;
import org.jboss.logging.Logger;
import org.hibernate.search.engine.search.highlighter.spi.BoundaryScannerType;
import org.hibernate.search.engine.search.aggregation.SearchAggregation;
import java.util.List;
import org.hibernate.search.engine.backend.scope.spi.IndexScopeBuilder;
import org.hibernate.search.engine.search.highlighter.spi.SearchHighlighterType;
import org.hibernate.search.engine.search.common.SortMode;
import java.io.IOException;
import java.lang.Exception;
import org.hibernate.search.util.common.reporting.EventContext;
import java.lang.Integer;
import org.hibernate.search.engine.search.projection.SearchProjection;
import java.util.Collection;
import java.lang.Class;
import java.lang.Object;
import java.util.Arrays;
import org.hibernate.search.engine.search.sort.SearchSort;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class QueryLog_$logger implements QueryLog, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = QueryLog_$logger.class.getName();
    public QueryLog_$logger(final Logger log) {
        this.log = log;
    }
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void executingLuceneQuery(final Query luceneQuery) {
        log.logf(FQCN, TRACE, null, executingLuceneQuery$str(), luceneQuery);
    }
    protected String executingLuceneQuery$str() {
        return "HSEARCH000274: Executing Lucene query: %s";
    }
    protected String cannotMixLuceneSearchQueryWithOtherPredicates$str() {
        return "HSEARCH600010: Invalid search predicate: '%1$s'. You must build the predicate from a Lucene search scope.";
    }
    @Override
    public final SearchException cannotMixLuceneSearchQueryWithOtherPredicates(final SearchPredicate predicate) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixLuceneSearchQueryWithOtherPredicates$str(), predicate));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String cannotMixLuceneSearchSortWithOtherSorts$str() {
        return "HSEARCH600014: Invalid search sort: '%1$s'. You must build the sort from a Lucene search scope.";
    }
    @Override
    public final SearchException cannotMixLuceneSearchSortWithOtherSorts(final SearchSort sort) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixLuceneSearchSortWithOtherSorts$str(), sort));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotMixLuceneScopeWithOtherType$str() {
        return "HSEARCH600024: Invalid multi-index scope: a scope cannot span both a Lucene index and another type of index. Base scope: '%1$s', incompatible (Lucene) index: '%2$s'.";
    }
    @Override
    public final SearchException cannotMixLuceneScopeWithOtherType(final IndexScopeBuilder baseScope, final LuceneIndexManager luceneIndex, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixLuceneScopeWithOtherType$str(), baseScope, luceneIndex), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotMixLuceneScopeWithOtherBackend$str() {
        return "HSEARCH600025: Invalid multi-index scope: a scope cannot span multiple Lucene backends. Base scope: '%1$s', incompatible index (from another backend): '%2$s'.";
    }
    @Override
    public final SearchException cannotMixLuceneScopeWithOtherBackend(final IndexScopeBuilder baseScope, final LuceneIndexManager indexFromOtherBackend, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixLuceneScopeWithOtherBackend$str(), baseScope, indexFromOtherBackend), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String ioExceptionOnQueryExecution$str() {
        return "HSEARCH600027: Unable to execute search query '%1$s': %2$s";
    }
    @Override
    public final SearchException ioExceptionOnQueryExecution(final Query luceneQuery, final String causeMessage, final EventContext context, final IOException cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), ioExceptionOnQueryExecution$str(), luceneQuery, causeMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String minimumShouldMatchMinimumOutOfBounds$str() {
        return "HSEARCH600044: Computed minimum for minimumShouldMatch constraint is out of bounds: expected a number between '1' and '%1$s', got '%2$s'.";
    }
    @Override
    public final SearchException minimumShouldMatchMinimumOutOfBounds(final int totalShouldClauseNumber, final int minimum) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), minimumShouldMatchMinimumOutOfBounds$str(), totalShouldClauseNumber, minimum));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String minimumShouldMatchConflictingConstraints$str() {
        return "HSEARCH600045: Multiple conflicting minimumShouldMatch constraints for ceiling '%1$s'";
    }
    @Override
    public final SearchException minimumShouldMatchConflictingConstraints(final int ignoreConstraintCeiling) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), minimumShouldMatchConflictingConstraints$str(), ignoreConstraintCeiling));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotMixLuceneSearchQueryWithOtherProjections$str() {
        return "HSEARCH600055: Invalid search projection: '%1$s'. You must build the projection from a Lucene search scope.";
    }
    @Override
    public final SearchException cannotMixLuceneSearchQueryWithOtherProjections(final SearchProjection<?> projection) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixLuceneSearchQueryWithOtherProjections$str(), projection));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToDeleteAllEntriesFromIndex$str() {
        return "HSEARCH600067: Unable to delete all entries matching query '%1$s': %2$s";
    }
    @Override
    public final SearchException unableToDeleteAllEntriesFromIndex(final Query query, final String causeMessage, final EventContext context, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToDeleteAllEntriesFromIndex$str(), query, causeMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String fullTextFeaturesNotSupportedByFieldType$str() {
        return "HSEARCH600070: Full-text features (analysis, fuzziness, minimum should match) are not supported for fields of this type.";
    }
    @Override
    public final SearchException fullTextFeaturesNotSupportedByFieldType(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), fullTextFeaturesNotSupportedByFieldType$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String explainRequiresTypeName$str() {
        return "HSEARCH600075: Invalid use of explain(Object id) on a query targeting multiple types. Use explain(String typeName, Object id) and pass one of %1$s as the type name.";
    }
    @Override
    public final SearchException explainRequiresTypeName(final Set<String> targetedTypeNames) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), explainRequiresTypeName$str(), targetedTypeNames));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String explainRequiresTypeTargetedByQuery$str() {
        return "HSEARCH600076: Invalid mapped type name: '%2$s'. This type is not among the mapped types targeted by this query: %1$s.";
    }
    @Override
    public final SearchException explainRequiresTypeTargetedByQuery(final Set<String> targetedTypeNames, final String typeName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), explainRequiresTypeTargetedByQuery$str(), targetedTypeNames, typeName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String explainUnknownDocument$str() {
        return "HSEARCH600077: Invalid document identifier: '%2$s'. No such document for type '%1$s'.";
    }
    @Override
    public final SearchException explainUnknownDocument(final String typeName, final String id) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), explainUnknownDocument$str(), typeName, id));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String predicateDefinedOnDifferentIndexes$str() {
        return "HSEARCH600084: Invalid search predicate: '%1$s'. You must build the predicate from a scope targeting indexes %3$s or a superset of them, but the given predicate was built from a scope targeting indexes %2$s, where indexes %4$s are missing.";
    }
    @Override
    public final SearchException predicateDefinedOnDifferentIndexes(final SearchPredicate predicate, final Set<String> predicateIndexes, final Set<String> scopeIndexes, final Set<String> scopeDifference) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), predicateDefinedOnDifferentIndexes$str(), predicate, predicateIndexes, scopeIndexes, scopeDifference));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String sortDefinedOnDifferentIndexes$str() {
        return "HSEARCH600085: Invalid search sort: '%1$s'. You must build the sort from a scope targeting indexes %3$s or a superset of them, but the given sort was built from a scope targeting indexes %2$s, where indexes %4$s are missing.";
    }
    @Override
    public final SearchException sortDefinedOnDifferentIndexes(final SearchSort sort, final Set<String> sortIndexes, final Set<String> scopeIndexes, final Set<String> scopeDifference) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), sortDefinedOnDifferentIndexes$str(), sort, sortIndexes, scopeIndexes, scopeDifference));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String projectionDefinedOnDifferentIndexes$str() {
        return "HSEARCH600086: Invalid search projection: '%1$s'. You must build the projection from a scope targeting indexes %3$s or a superset of them, but the given projection was built from a scope targeting indexes %2$s, where indexes %4$s are missing.";
    }
    @Override
    public final SearchException projectionDefinedOnDifferentIndexes(final SearchProjection<?> projection, final Set<String> projectionIndexes, final Set<String> scopeIndexes, final Set<String> scopeDifference) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), projectionDefinedOnDifferentIndexes$str(), projection, projectionIndexes, scopeIndexes, scopeDifference));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotMixLuceneSearchQueryWithOtherAggregations$str() {
        return "HSEARCH600098: Invalid search aggregation: '%1$s'. You must build the aggregation from a Lucene search scope.";
    }
    @Override
    public final SearchException cannotMixLuceneSearchQueryWithOtherAggregations(final SearchAggregation<?> aggregation) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixLuceneSearchQueryWithOtherAggregations$str(), aggregation));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String aggregationDefinedOnDifferentIndexes$str() {
        return "HSEARCH600099: Invalid search aggregation: '%1$s'. You must build the aggregation from a scope targeting indexes %3$s or a superset of them, but the given aggregation was built from a scope targeting indexes %2$s, where indexes %4$s are missing";
    }
    @Override
    public final SearchException aggregationDefinedOnDifferentIndexes(final SearchAggregation<?> aggregation, final Set<String> aggregationIndexes, final Set<String> scopeIndexes, final Set<String> scopeDifference) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), aggregationDefinedOnDifferentIndexes$str(), aggregation, aggregationIndexes, scopeIndexes, scopeDifference));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String duplicateAggregationKey$str() {
        return "HSEARCH600102: Duplicate aggregation definitions for key: '%1$s'";
    }
    @Override
    public final SearchException duplicateAggregationKey(final AggregationKey<?> key) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), duplicateAggregationKey$str(), new org.hibernate.search.engine.logging.spi.AggregationKeyFormatter(key)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidSortModeAcrossNested$str() {
        return "HSEARCH600114: Invalid sort mode: %1$s. This sort mode is not supported for fields in nested documents.";
    }
    @Override
    public final SearchException invalidSortModeAcrossNested(final SortMode mode, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidSortModeAcrossNested$str(), mode), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidSortModeForStringField$str() {
        return "HSEARCH600115: Invalid sort mode: %1$s. This sort mode is not supported for String fields. Only MIN and MAX are supported.";
    }
    @Override
    public final SearchException invalidSortModeForStringField(final SortMode mode, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidSortModeForStringField$str(), mode), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidSortModeForTemporalField$str() {
        return "HSEARCH600116: Invalid sort mode: %1$s. This sort mode is not supported for temporal fields. Only MIN, MAX, AVG and MEDIAN are supported.";
    }
    @Override
    public final SearchException invalidSortModeForTemporalField(final SortMode mode, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidSortModeForTemporalField$str(), mode), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotFilterSortOnRootDocumentField$str() {
        return "HSEARCH600120: Invalid sort filter: field '%1$s' is not contained in a nested object. Sort filters are only available if the field to sort on is contained in a nested object.";
    }
    @Override
    public final SearchException cannotFilterSortOnRootDocumentField(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotFilterSortOnRootDocumentField$str(), absoluteFieldPath), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidNestedObjectPathForPredicate$str() {
        return "HSEARCH600121: Invalid search predicate: %1$s. This predicate targets fields %3$s, but only fields that are contained in the nested object with path '%2$s' are allowed here.";
    }
    @Override
    public final SearchException invalidNestedObjectPathForPredicate(final SearchPredicate predicate, final String nestedObjectPath, final List<String> fieldPaths) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidNestedObjectPathForPredicate$str(), predicate, nestedObjectPath, fieldPaths));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotFilterAggregationOnRootDocumentField$str() {
        return "HSEARCH600122: Invalid aggregation filter: field '%1$s' is not contained in a nested object. Aggregation filters are only available if the field to aggregate on is contained in a nested object.";
    }
    @Override
    public final SearchException cannotFilterAggregationOnRootDocumentField(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotFilterAggregationOnRootDocumentField$str(), absoluteFieldPath), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidSingleValuedProjectionOnMultiValuedField$str() {
        return "HSEARCH600131: Invalid cardinality for projection on field '%1$s': the projection is single-valued, but this field is multi-valued. Make sure to call '.collector(...)' when you create the projection.";
    }
    @Override
    public final SearchException invalidSingleValuedProjectionOnMultiValuedField(final String absolutePath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidSingleValuedProjectionOnMultiValuedField$str(), absolutePath), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String differentImplementationClassForQueryElement$str() {
        return "HSEARCH600135: Implementation class differs: '%1$s' vs. '%2$s'.";
    }
    @Override
    public final SearchException differentImplementationClassForQueryElement(final Class<?> class1, final Class<?> class2) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), differentImplementationClassForQueryElement$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(class1), new org.hibernate.search.util.common.logging.impl.ClassFormatter(class2)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String differentFieldCodecForQueryElement$str() {
        return "HSEARCH600136: Field codec differs: '%1$s' vs. '%2$s'.";
    }
    @Override
    public final SearchException differentFieldCodecForQueryElement(final Object codec1, final Object codec2) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), differentFieldCodecForQueryElement$str(), codec1, codec2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String differentPredicateDefinitionForQueryElement$str() {
        return "HSEARCH600144: Predicate definition differs: '%1$s' vs. '%2$s'.";
    }
    @Override
    public final SearchException differentPredicateDefinitionForQueryElement(final Object predicateDefinition1, final Object predicateDefinition2) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), differentPredicateDefinitionForQueryElement$str(), predicateDefinition1, predicateDefinition2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String paramNotDefined$str() {
        return "HSEARCH600150: Param with name '%1$s' has not been defined for the named predicate '%2$s'.";
    }
    @Override
    public final SearchException paramNotDefined(final String name, final String predicateName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), paramNotDefined$str(), name, predicateName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String offsetLimitExceedsMaxValue$str() {
        return "HSEARCH600151: Offset + limit should be lower than Integer.MAX_VALUE, offset: '%1$s', limit: '%2$s'.";
    }
    @Override
    public final IOException offsetLimitExceedsMaxValue(final int offset, final Integer limit) {
        final IOException result = new IOException(String.format(getLoggingLocale(), offsetLimitExceedsMaxValue$str(), offset, limit));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidContextForProjectionOnField$str() {
        return "HSEARCH600152: Invalid context for projection on field '%1$s': the surrounding projection is executed for each object in field '%2$s', which is not a parent of field '%1$s'. Check the structure of your projections.";
    }
    @Override
    public final SearchException invalidContextForProjectionOnField(final String absolutePath, final String objectFieldAbsolutePath) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidContextForProjectionOnField$str(), absolutePath, objectFieldAbsolutePath));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidSingleValuedProjectionOnValueFieldInMultiValuedObjectField$str() {
        return "HSEARCH600153: Invalid cardinality for projection on field '%1$s': the projection is single-valued, but this field is effectively multi-valued in this context, because parent object field '%2$s' is multi-valued. Either call '.collector(...)' when you create the projection on field '%1$s', or wrap that projection in an object projection like this: 'f.object(\"%2$s\").from(<the projection on field %1$s>).as(...).collector(...)'.";
    }
    @Override
    public final SearchException invalidSingleValuedProjectionOnValueFieldInMultiValuedObjectField(final String absolutePath, final String objectFieldAbsolutePath) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidSingleValuedProjectionOnValueFieldInMultiValuedObjectField$str(), absolutePath, objectFieldAbsolutePath));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unexpectedMappedTypeNameForByMappedTypeProjection$str() {
        return "HSEARCH600155: Unexpected mapped type name extracted from hits: '%1$s'. Expected one of: %2$s. The document was probably indexed with a different configuration: full reindexing is necessary.";
    }
    @Override
    public final SearchException unexpectedMappedTypeNameForByMappedTypeProjection(final String typeName, final Set<String> expectedTypeNames) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unexpectedMappedTypeNameForByMappedTypeProjection$str(), typeName, expectedTypeNames));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotMixLuceneSearchQueryWithOtherQueryHighlighters$str() {
        return "HSEARCH600158: Invalid highlighter: '%1$s'. You must build the highlighter from a Lucene search scope.";
    }
    @Override
    public final SearchException cannotMixLuceneSearchQueryWithOtherQueryHighlighters(final SearchHighlighter highlighter) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixLuceneSearchQueryWithOtherQueryHighlighters$str(), highlighter));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String queryHighlighterDefinedOnDifferentIndexes$str() {
        return "HSEARCH600159: Invalid highlighter: '%1$s'. You must build the highlighter from a scope targeting indexes %3$s or a superset of them, but the given highlighter was built from a scope targeting indexes %2$s, where indexes %4$s are missing.";
    }
    @Override
    public final SearchException queryHighlighterDefinedOnDifferentIndexes(final SearchHighlighter highlighter, final Set<String> highlighterIndexes, final Set<String> scopeIndexes, final Set<String> scopeDifference) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), queryHighlighterDefinedOnDifferentIndexes$str(), highlighter, highlighterIndexes, scopeIndexes, scopeDifference));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotMixDifferentHighlighterTypesAtOverrideLevel$str() {
        return "HSEARCH600160: Overriding a '%2$s' highlighter with a '%1$s' is not supported. Overriding highlighters should be of the same type as the global is if the global highlighter was configured.";
    }
    @Override
    public final SearchException cannotMixDifferentHighlighterTypesAtOverrideLevel(final SearchHighlighterType override, final SearchHighlighterType parent) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixDifferentHighlighterTypesAtOverrideLevel$str(), override, parent));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotFindHighlighterWithName$str() {
        return "HSEARCH600161: Cannot find a highlighter with name '%1$s'. Available highlighters are: %2$s. Was it configured with `highlighter(\"%1$s\", highlighterContributor)`?";
    }
    @Override
    public final SearchException cannotFindHighlighterWithName(final String name, final Collection<String> availableHighlighterNames) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotFindHighlighterWithName$str(), name, availableHighlighterNames));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsupportedBoundaryScannerType$str() {
        return "HSEARCH600162: '%1$s' highlighter does not support '%2$s' boundary scanner type.";
    }
    @Override
    public final SearchException unsupportedBoundaryScannerType(final String type, final BoundaryScannerType boundaryScannerType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unsupportedBoundaryScannerType$str(), type, boundaryScannerType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String highlighterNameCannotBeBlank$str() {
        return "HSEARCH600163: Named highlighters cannot use a blank string as name.";
    }
    @Override
    public final SearchException highlighterNameCannotBeBlank() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), highlighterNameCannotBeBlank$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String highlighterWithTheSameNameCannotBeAdded$str() {
        return "HSEARCH600164: Highlighter with name '%1$s' is already defined. Use a different name to add another highlighter.";
    }
    @Override
    public final SearchException highlighterWithTheSameNameCannotBeAdded(final String highlighterName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), highlighterWithTheSameNameCannotBeAdded$str(), highlighterName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String highlighterTypeNotSupported$str() {
        return "HSEARCH600165: '%1$s' highlighter type cannot be applied to '%2$s' field. '%2$s' must have either 'ANY' or '%1$s' among the configured highlightable values.";
    }
    @Override
    public final SearchException highlighterTypeNotSupported(final SearchHighlighterType type, final String field) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), highlighterTypeNotSupported$str(), type, field));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void unifiedHighlighterNoMatchSizeWarning(final Integer value) {
        log.logf(FQCN, WARN, null, unifiedHighlighterNoMatchSizeWarning$str(), value);
    }
    protected String unifiedHighlighterNoMatchSizeWarning$str() {
        return "HSEARCH600169: Lucene's unified highlighter cannot limit the size of a fragment returned when no match is found. Instead if no match size was set to any positive integer - all text will be returned. Configured value '%1$s' will be ignored, and the fragment will not be limited. If you don't want to see this warning set the value to Integer.MAX_VALUE.";
    }
    protected String unifiedHighlighterFragmentSizeNotSupported$str() {
        return "HSEARCH600170: Lucene's unified highlighter does not support the size fragment setting. Either use a plain or fast vector highlighters, or do not set this setting.";
    }
    @Override
    public final SearchException unifiedHighlighterFragmentSizeNotSupported() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unifiedHighlighterFragmentSizeNotSupported$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotHighlightInNestedContext$str() {
        return "HSEARCH600171: Highlight projection cannot be applied within nested context of '%1$s'.";
    }
    @Override
    public final SearchException cannotHighlightInNestedContext(final String currentNestingField, final EventContext eventContext) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotHighlightInNestedContext$str(), currentNestingField), eventContext);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotHighlightFieldFromNestedObjectStructure$str() {
        return "HSEARCH600172: The highlight projection cannot be applied to a field from an object using `ObjectStructure.NESTED` structure.";
    }
    @Override
    public final SearchException cannotHighlightFieldFromNestedObjectStructure(final EventContext eventContext) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotHighlightFieldFromNestedObjectStructure$str()), eventContext);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotUseProjectionInNestedContext$str() {
        return "HSEARCH600173: '%1$s' cannot be nested in an object projection. %2$s";
    }
    @Override
    public final SearchException cannotUseProjectionInNestedContext(final String projection, final String hint, final EventContext eventContext) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotUseProjectionInNestedContext$str(), projection, hint), eventContext);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidSortModeForDistanceSort$str() {
        return "HSEARCH600117: Invalid sort mode: %1$s. This sort mode is not supported for a distance sort. Only MIN, MAX, AVG and MEDIAN are supported.";
    }
    @Override
    public final SearchException invalidSortModeForDistanceSort(final SortMode mode, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidSortModeForDistanceSort$str(), mode), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String vectorKnnMatchVectorTypeDiffersFromField$str() {
        return "HSEARCH600176: Vector field '%1$s' is defined as a '%2$s' array. Matching against '%3$s' array is unsupported. Use the array of the same type as the vector field.";
    }
    @Override
    public final SearchException vectorKnnMatchVectorTypeDiffersFromField(final String absoluteFieldPath, final Class<?> expected, final Class<?> actual) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), vectorKnnMatchVectorTypeDiffersFromField$str(), absoluteFieldPath, new org.hibernate.search.util.common.logging.impl.ClassFormatter(expected), new org.hibernate.search.util.common.logging.impl.ClassFormatter(actual)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String vectorKnnMatchVectorDimensionDiffersFromField$str() {
        return "HSEARCH600178: Vector field '%1$s' is defined as a vector with '%2$s' dimensions (array length). Matching against an array with length of '%3$s' is unsupported. Use the array of the same size as the vector field.";
    }
    @Override
    public final SearchException vectorKnnMatchVectorDimensionDiffersFromField(final String absoluteFieldPath, final int expected, final int actual) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), vectorKnnMatchVectorDimensionDiffersFromField$str(), absoluteFieldPath, expected, actual));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String queryStringParseException$str() {
        return "HSEARCH600180: An error occurred while parsing the query string '%1$s': %2$s";
    }
    @Override
    public final SearchException queryStringParseException(final String query, final String message, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), queryStringParseException$str(), query, message), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String highlighterIncompatibleCardinality$str() {
        return "HSEARCH600186: A single-valued highlight projection requested, but the corresponding highlighter does not set number of fragments to 1.";
    }
    @Override
    public final SearchException highlighterIncompatibleCardinality() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), highlighterIncompatibleCardinality$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
