package org.hibernate.search.backend.lucene.logging.impl;

import java.util.Locale;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import java.io.Serializable;
import java.util.Set;
import org.apache.lucene.search.Query;
import org.hibernate.search.engine.search.highlighter.SearchHighlighter;
import org.jboss.logging.DelegatingBasicLogger;
import org.hibernate.search.backend.lucene.index.LuceneIndexManager;
import org.hibernate.search.util.common.SearchException;
import java.lang.String;
import org.hibernate.search.engine.backend.types.TermVector;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.jboss.logging.Logger;
import org.hibernate.search.engine.search.highlighter.spi.BoundaryScannerType;
import org.hibernate.search.backend.lucene.logging.impl.ConfigurationLog;
import java.lang.Number;
import org.apache.lucene.util.Version;
import org.hibernate.search.engine.search.aggregation.SearchAggregation;
import org.jboss.logging.BasicLogger;
import org.hibernate.search.backend.lucene.logging.impl.IndexingLog;
import java.util.List;
import org.hibernate.search.backend.lucene.logging.impl.MappingLog;
import org.hibernate.search.engine.backend.scope.spi.IndexScopeBuilder;
import org.apache.lucene.store.Directory;
import java.nio.file.Path;
import org.hibernate.search.engine.search.highlighter.spi.SearchHighlighterType;
import org.hibernate.search.engine.search.common.SortMode;
import org.hibernate.search.backend.lucene.logging.impl.LuceneInfoStreamLog;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.HibernateSearchMultiReader;
import java.io.IOException;
import org.hibernate.search.backend.lucene.logging.impl.QueryLog;
import java.lang.Exception;
import org.hibernate.search.util.common.reporting.EventContext;
import java.lang.Integer;
import org.hibernate.search.backend.lucene.logging.impl.AnalysisLog;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.backend.lucene.logging.impl.LuceneMiscLog;
import java.util.Collection;
import java.lang.Throwable;
import java.lang.Class;
import java.lang.Object;
import java.util.Arrays;
import org.hibernate.search.engine.search.sort.SearchSort;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class LuceneLog_$logger extends DelegatingBasicLogger implements LuceneLog, org.hibernate.search.backend.lucene.logging.impl.AnalysisLog, org.hibernate.search.backend.lucene.logging.impl.ConfigurationLog, BasicLogger, org.hibernate.search.backend.lucene.logging.impl.IndexingLog, org.hibernate.search.backend.lucene.logging.impl.LuceneInfoStreamLog, org.hibernate.search.backend.lucene.logging.impl.LuceneMiscLog, org.hibernate.search.backend.lucene.logging.impl.MappingLog, org.hibernate.search.backend.lucene.logging.impl.QueryLog, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = LuceneLog_$logger.class.getName();
    public LuceneLog_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void nextLoggerIdForConvenience() {
        super.log.logf(FQCN, TRACE, null, nextLoggerIdForConvenience$str());
    }
    protected String nextLoggerIdForConvenience$str() {
        return "HSEARCH600194: ";
    }
    protected String unableToApplyAnalysisConfiguration$str() {
        return "HSEARCH000329: Unable to apply analysis configuration: %1$s";
    }
    @Override
    public final SearchException unableToApplyAnalysisConfiguration(final String errorMessage, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToApplyAnalysisConfiguration$str(), errorMessage), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String analysisComponentParameterConflict$str() {
        return "HSEARCH000337: Ambiguous value for parameter '%1$s': this parameter is set to two different values '%2$s' and '%3$s'.";
    }
    @Override
    public final SearchException analysisComponentParameterConflict(final String name, final String value1, final String value2) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), analysisComponentParameterConflict$str(), name, value1, value2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotApplyAnalyzerAndNormalizer$str() {
        return "HSEARCH000342: Invalid index field type: both analyzer '%1$s' and normalizer '%2$s' are assigned to this type. Either an analyzer or a normalizer can be assigned, but not both.";
    }
    @Override
    public final SearchException cannotApplyAnalyzerAndNormalizer(final String analyzerName, final String normalizerName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotApplyAnalyzerAndNormalizer$str(), analyzerName, normalizerName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void normalizerProducedMultipleTokens(final String normalizerName, final int token) {
        super.log.logf(FQCN, WARN, null, normalizerProducedMultipleTokens$str(), normalizerName, token);
    }
    protected String normalizerProducedMultipleTokens$str() {
        return "HSEARCH000344: Invalid normalizer implementation: the normalizer for definition '%s' produced %d tokens. Normalizers should never produce more than one token. The tokens have been concatenated by Hibernate Search, but you should fix your normalizer definition.";
    }
    protected String cannotUseAnalyzerOnSortableField$str() {
        return "HSEARCH000345: Invalid index field type: both analyzer '%1$s' and sorts are enabled. Sorts are not supported on analyzed fields. If you need an analyzer simply to transform the text (lowercasing, ...) without splitting it into tokens, use a normalizer instead. If you need an actual analyzer (with tokenization), define two separate fields: one with an analyzer that is not sortable, and one with a normalizer that is sortable.";
    }
    @Override
    public final SearchException cannotUseAnalyzerOnSortableField(final String analyzerName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotUseAnalyzerOnSortableField$str(), analyzerName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownAnalyzer$str() {
        return "HSEARCH000353: Unknown analyzer: '%1$s'. Make sure you defined this analyzer.";
    }
    @Override
    public final SearchException unknownAnalyzer(final String analyzerName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownAnalyzer$str(), analyzerName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToCreateAnalyzer$str() {
        return "HSEARCH600052: Unable to create analyzer for name '%1$s': %2$s";
    }
    @Override
    public final SearchException unableToCreateAnalyzer(final String name, final String causeMessage, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToCreateAnalyzer$str(), name, causeMessage), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToCreateNormalizer$str() {
        return "HSEARCH600053: Unable to create normalizer for name '%1$s': %2$s";
    }
    @Override
    public final SearchException unableToCreateNormalizer(final String name, final String causeMessage, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToCreateNormalizer$str(), name, causeMessage), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownNormalizer$str() {
        return "HSEARCH600054: Unknown normalizer: '%1$s'. Make sure you defined this normalizer.";
    }
    @Override
    public final SearchException unknownNormalizer(final String normalizerName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownNormalizer$str(), normalizerName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotUseIndexNullAsAndAnalyzer$str() {
        return "HSEARCH600073: Invalid index field type: both null token '%2$s' ('indexNullAs') and analyzer '%1$s' are assigned to this type. 'indexNullAs' is not supported on analyzed fields.";
    }
    @Override
    public final SearchException cannotUseIndexNullAsAndAnalyzer(final String analyzerName, final String indexNullAs, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotUseIndexNullAsAndAnalyzer$str(), analyzerName, indexNullAs), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotUseAnalyzerOnAggregableField$str() {
        return "HSEARCH600094: Invalid index field type: both analyzer '%1$s' and aggregations are enabled. Aggregations are not supported on analyzed fields. If you need an analyzer simply to transform the text (lowercasing, ...) without splitting it into tokens, use a normalizer instead. If you need an actual analyzer (with tokenization), define two separate fields: one with an analyzer that is not aggregable, and one with a normalizer that is aggregable.";
    }
    @Override
    public final SearchException cannotUseAnalyzerOnAggregableField(final String analyzerName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotUseAnalyzerOnAggregableField$str(), analyzerName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String searchAnalyzerWithoutAnalyzer$str() {
        return "HSEARCH600104: Invalid index field type: search analyzer '%1$s' is assigned to this type, but the indexing analyzer is missing. Assign an indexing analyzer and a search analyzer, or remove the search analyzer.";
    }
    @Override
    public final SearchException searchAnalyzerWithoutAnalyzer(final String searchAnalyzer, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), searchAnalyzerWithoutAnalyzer$str(), searchAnalyzer), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToCreateAnalysisComponent$str() {
        return "HSEARCH600142: Unable to create instance of analysis component '%1$s': %2$s";
    }
    @Override
    public final SearchException unableToCreateAnalysisComponent(final Class<?> type, final String causeMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToCreateAnalysisComponent$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(type), causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noSuchAnalyzer$str() {
        return "HSEARCH600181: An analyzer '%1$s' cannot be found.";
    }
    @Override
    public final SearchException noSuchAnalyzer(final String analyzer) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), noSuchAnalyzer$str(), analyzer));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noSuchNormalizer$str() {
        return "HSEARCH600182: A normalizer '%1$s' cannot be found.";
    }
    @Override
    public final SearchException noSuchNormalizer(final String normalizer) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), noSuchNormalizer$str(), normalizer));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToPerformAnalysisOperation$str() {
        return "HSEARCH600183: Failed to apply '%1$s' to '%2$s': '%3$s'";
    }
    @Override
    public final SearchException unableToPerformAnalysisOperation(final String analyzerName, final String string, final String reason, final IOException cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToPerformAnalysisOperation$str(), analyzerName, string, reason), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void recommendConfiguringLuceneVersion(final String key, final Version latest, final EventContext context) {
        super.log.logf(FQCN, WARN, null, recommendConfiguringLuceneVersion$str(), key, latest, new org.hibernate.search.util.common.logging.impl.EventContextFormatter(context));
    }
    protected String recommendConfiguringLuceneVersion$str() {
        return "HSEARCH000075: Missing value for configuration property '%1$s': using LATEST (currently '%2$s'). %3$s";
    }
    protected String illegalLuceneVersionFormat$str() {
        return "HSEARCH000228: Unable to parse '%1$ss' into a Lucene version: %2$s";
    }
    @Override
    public final SearchException illegalLuceneVersionFormat(final String property, final String luceneErrorMessage, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), illegalLuceneVersionFormat$str(), property, luceneErrorMessage), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidMultiTenancyStrategyName$str() {
        return "HSEARCH600030: Invalid multi-tenancy strategy name: '%1$s'. Valid names are: %2$s.";
    }
    @Override
    public final SearchException invalidMultiTenancyStrategyName(final String invalidRepresentation, final List<String> validRepresentations) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidMultiTenancyStrategyName$str(), invalidRepresentation, validRepresentations));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String tenantIdProvidedButMultiTenancyDisabled$str() {
        return "HSEARCH600031: Invalid tenant identifiers: '%1$s'. No tenant identifier is expected, because multi-tenancy is disabled for this backend.";
    }
    @Override
    public final SearchException tenantIdProvidedButMultiTenancyDisabled(final Set<String> tenantId, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), tenantIdProvidedButMultiTenancyDisabled$str(), tenantId), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multiTenancyEnabledButNoTenantIdProvided$str() {
        return "HSEARCH600032: Missing tenant identifier. A tenant identifier is expected, because multi-tenancy is enabled for this backend.";
    }
    @Override
    public final SearchException multiTenancyEnabledButNoTenantIdProvided(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multiTenancyEnabledButNoTenantIdProvided$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidFileSystemAccessStrategyName$str() {
        return "HSEARCH600087: Invalid filesystem access strategy name: '%1$s'. Valid names are: %2$s.";
    }
    @Override
    public final SearchException invalidFileSystemAccessStrategyName(final String invalidRepresentation, final List<String> validRepresentations) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidFileSystemAccessStrategyName$str(), invalidRepresentation, validRepresentations));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidLockingStrategyName$str() {
        return "HSEARCH600088: Invalid locking strategy name: '%1$s'. Valid names are: %2$s.";
    }
    @Override
    public final SearchException invalidLockingStrategyName(final String invalidRepresentation, final List<String> validRepresentations) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidLockingStrategyName$str(), invalidRepresentation, validRepresentations));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingShardIdentifiersAfterShardingStrategyInitialization$str() {
        return "HSEARCH600089: Incorrect sharding strategy implementation: strategy '%1$s' did not declare any shard identifiers during initialization. Declare shard identifiers using context.shardIdentifiers(...) or, if sharding is disabled, call context.disableSharding().";
    }
    @Override
    public final SearchException missingShardIdentifiersAfterShardingStrategyInitialization(final Object strategy) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingShardIdentifiersAfterShardingStrategyInitialization$str(), strategy));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingPropertyValueForShardingStrategy$str() {
        return "HSEARCH600090: When using sharding strategy '%1$s', this configuration property must be set.";
    }
    @Override
    public final SearchException missingPropertyValueForShardingStrategy(final String strategyName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingPropertyValueForShardingStrategy$str(), strategyName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidRoutingKeyForExplicitShardingStrategy$str() {
        return "HSEARCH600091: Invalid routing key: '%1$s'. Valid keys are: %2$s.";
    }
    @Override
    public final SearchException invalidRoutingKeyForExplicitShardingStrategy(final String invalidKey, final Collection<String> validKeys) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidRoutingKeyForExplicitShardingStrategy$str(), invalidKey, validKeys));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidIOStrategyName$str() {
        return "HSEARCH600108: Invalid I/O strategy name: '%1$s'. Valid names are: %2$s.";
    }
    @Override
    public final SearchException invalidIOStrategyName(final String invalidRepresentation, final List<String> validRepresentations) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidIOStrategyName$str(), invalidRepresentation, validRepresentations));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalIndexWriterSetting$str() {
        return "HSEARCH600123: Invalid value for IndexWriter setting '%1$s': '%2$s'. %3$s";
    }
    @Override
    public final SearchException illegalIndexWriterSetting(final String settingName, final Object settingValue, final String message, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), illegalIndexWriterSetting$str(), settingName, settingValue, message), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalMergePolicySetting$str() {
        return "HSEARCH600124: Invalid value for merge policy setting '%1$s': '%2$s'. %3$s";
    }
    @Override
    public final SearchException illegalMergePolicySetting(final String settingName, final Object settingValue, final String message, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), illegalMergePolicySetting$str(), settingName, settingValue, message), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToApplyQueryCacheConfiguration$str() {
        return "HSEARCH600146: Unable to apply query caching configuration: %1$s";
    }
    @Override
    public final SearchException unableToApplyQueryCacheConfiguration(final String errorMessage, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToApplyQueryCacheConfiguration$str(), errorMessage), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multiTenancyRequiredButExplicitlyDisabledByBackend$str() {
        return "HSEARCH600148: Invalid backend configuration: mapping requires multi-tenancy but no multi-tenancy strategy is set.";
    }
    @Override
    public final SearchException multiTenancyRequiredButExplicitlyDisabledByBackend() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multiTenancyRequiredButExplicitlyDisabledByBackend$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multiTenancyNotRequiredButExplicitlyEnabledByTheBackend$str() {
        return "HSEARCH600149: Invalid backend configuration: mapping requires single-tenancy but multi-tenancy strategy is set.";
    }
    @Override
    public final SearchException multiTenancyNotRequiredButExplicitlyEnabledByTheBackend() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multiTenancyNotRequiredButExplicitlyEnabledByTheBackend$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void luceneCompatibilityVersion(final Version luceneVersion) {
        super.log.logf(FQCN, DEBUG, null, luceneCompatibilityVersion$str(), luceneVersion);
    }
    protected String luceneCompatibilityVersion$str() {
        return "HSEARCH600188: Setting Lucene compatibility to Version %s";
    }
    protected String unableToIndexEntry$str() {
        return "HSEARCH600016: Unable to index entity of type '%2$s' with identifier '%3$s' and tenant identifier '%1$s': %4$s";
    }
    @Override
    public final SearchException unableToIndexEntry(final String tenantId, final String entityTypeName, final Object entityIdentifier, final String causeMessage, final EventContext context, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToIndexEntry$str(), tenantId, entityTypeName, entityIdentifier, causeMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToDeleteEntryFromIndex$str() {
        return "HSEARCH600017: Unable to delete entity of type '%2$s' with identifier '%3$s' and tenant identifier '%1$s': %4$s";
    }
    @Override
    public final SearchException unableToDeleteEntryFromIndex(final String tenantId, final String entityTypeName, final Object entityIdentifier, final String causeMessage, final EventContext context, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToDeleteEntryFromIndex$str(), tenantId, entityTypeName, entityIdentifier, causeMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToCommitIndex$str() {
        return "HSEARCH600019: Unable to commit: %1$s";
    }
    @Override
    public final SearchException unableToCommitIndex(final String causeMessage, final EventContext context, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToCommitIndex$str(), causeMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidFieldForDocumentElement$str() {
        return "HSEARCH600039: Invalid field reference for this document element: this document element has path '%1$s', but the referenced field has a parent with path '%2$s'.";
    }
    @Override
    public final SearchException invalidFieldForDocumentElement(final String expectedPath, final String actualPath) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidFieldForDocumentElement$str(), expectedPath, actualPath));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidFieldPath$str() {
        return "HSEARCH600049: Invalid field path; expected path '%1$s', got '%2$s'.";
    }
    @Override
    public final SearchException invalidFieldPath(final String expectedPath, final String actualPath) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidFieldPath$str(), expectedPath, actualPath));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotConvertDslParameter$str() {
        return "HSEARCH600050: Unable to convert DSL argument: %1$s";
    }
    @Override
    public final SearchException cannotConvertDslParameter(final String errorMessage, final Exception cause, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotConvertDslParameter$str(), errorMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multipleValuesForSingleValuedField$str() {
        return "HSEARCH600074: Multiple values assigned to field '%1$s': this field is single-valued. Declare the field as multi-valued in order to allow this.";
    }
    @Override
    public final SearchException multipleValuesForSingleValuedField(final String absoluteFieldPath) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multipleValuesForSingleValuedField$str(), absoluteFieldPath));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String scaledNumberTooLarge$str() {
        return "HSEARCH600081: Unable to encode value '%1$s': this field type only supports values ranging from '%2$s' to '%3$s'. If you want to encode values that are outside this range, change the decimal scale for this field. Do not forget to reindex all your data after changing the decimal scale.";
    }
    @Override
    public final SearchException scaledNumberTooLarge(final Number value, final Number min, final Number max) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), scaledNumberTooLarge$str(), value, min, max));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidFieldValueType$str() {
        return "HSEARCH600126: Invalid value type. This field's values are of type '%1$s', which is not assignable from '%2$s'.";
    }
    @Override
    public final SearchException invalidFieldValueType(final Class<?> fieldValueType, final Class<?> invalidValueType, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidFieldValueType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(fieldValueType), new org.hibernate.search.util.common.logging.impl.ClassFormatter(invalidValueType)), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownFieldForIndexing$str() {
        return "HSEARCH600127: Unknown field '%1$s'.";
    }
    @Override
    public final SearchException unknownFieldForIndexing(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownFieldForIndexing$str(), absoluteFieldPath), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String vectorCosineZeroMagnitudeNotAcceptable$str() {
        return "HSEARCH600184: The cosine vector similarity cannot process vectors with 0 magnitude. The vector violating this constraint is %1$s.";
    }
    @Override
    public final SearchException vectorCosineZeroMagnitudeNotAcceptable(final Object vector) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), vectorCosineZeroMagnitudeNotAcceptable$str(), vector));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String vectorDotProductNonUnitMagnitudeNotAcceptable$str() {
        return "HSEARCH600185: The dot product vector similarity cannot process non-unit magnitude vectors. The vector violating this constraint is %1$s.";
    }
    @Override
    public final SearchException vectorDotProductNonUnitMagnitudeNotAcceptable(final Object vector) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), vectorDotProductNonUnitMagnitudeNotAcceptable$str(), vector));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void logInfoStreamMessage(final String componentName, final String message) {
        super.log.logf(FQCN, TRACE, null, logInfoStreamMessage$str(), componentName, message);
    }
    protected String logInfoStreamMessage$str() {
        return "HSEARCH000226: %s: %s";
    }
    @Override
    public final void indexDirectoryNotFoundCreatingNewOne(final Path absolutePath) {
        super.log.logf(FQCN, INFO, null, indexDirectoryNotFoundCreatingNewOne$str(), absolutePath);
    }
    protected String indexDirectoryNotFoundCreatingNewOne$str() {
        return "HSEARCH000041: Index directory does not exist, creating: '%1$s'";
    }
    @Override
    public final void indexWriterResetAfterFailure(final EventContext context) {
        super.log.logf(FQCN, WARN, null, indexWriterResetAfterFailure$str(), new org.hibernate.search.util.common.logging.impl.EventContextFormatter(context));
    }
    protected String indexWriterResetAfterFailure$str() {
        return "HSEARCH000052: An index writer operation failed. Resetting the index writer and forcing release of locks. %1$s";
    }
    @Override
    public final void unableToCloseIndexReader(final EventContext context, final Exception e) {
        super.log.logf(FQCN, WARN, e, unableToCloseIndexReader$str(), new org.hibernate.search.util.common.logging.impl.EventContextFormatter(context));
    }
    protected String unableToCloseIndexReader$str() {
        return "HSEARCH000055: Unable to close the index reader. %1$s";
    }
    protected String unableToLoadResource$str() {
        return "HSEARCH000114: Resource does not exist in classpath: '%1$s'";
    }
    @Override
    public final SearchException unableToLoadResource(final String fileName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToLoadResource$str(), fileName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void lockingFailureDuringInitialization(final String directoryDescription, final EventContext context, final Exception e) {
        super.log.logf(FQCN, WARN, e, lockingFailureDuringInitialization$str(), directoryDescription);
    }
    protected String lockingFailureDuringInitialization$str() {
        return "HSEARCH000225: Unable to acquire lock on the index while initializing directory '%s'. Either the directory wasn't properly closed last time it was used due to a critical failure, or another instance of Hibernate Search is using it concurrently (which is not supported). If you experience indexing failures on this index you will need to remove the lock, and might need to rebuild the index.";
    }
    protected String unableToOpenIndexReaders$str() {
        return "HSEARCH000284: Unable to open index readers: %1$s";
    }
    @Override
    public final SearchException unableToOpenIndexReaders(final String causeMessage, final EventContext context, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToOpenIndexReaders$str(), causeMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String pathIsNotWriteableDirectory$str() {
        return "HSEARCH600001: Path '%1$s' exists but does not point to a writable directory.";
    }
    @Override
    public final SearchException pathIsNotWriteableDirectory(final Path rootDirectory) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), pathIsNotWriteableDirectory$str(), rootDirectory));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String luceneExtensionOnUnknownType$str() {
        return "HSEARCH600005: Invalid target for Lucene extension: '%1$s'. This extension can only be applied to components created by a Lucene backend.";
    }
    @Override
    public final SearchException luceneExtensionOnUnknownType(final Object context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), luceneExtensionOnUnknownType$str(), context));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToInitializeIndexDirectory$str() {
        return "HSEARCH600015: Unable to initialize index directory: %1$s";
    }
    @Override
    public final SearchException unableToInitializeIndexDirectory(final String causeMessage, final EventContext context, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToInitializeIndexDirectory$str(), causeMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String backendUnwrappingWithUnknownType$str() {
        return "HSEARCH600033: Invalid requested type for this backend: '%1$s'. Lucene backends can only be unwrapped to '%2$s'.";
    }
    @Override
    public final SearchException backendUnwrappingWithUnknownType(final Class<?> requestedClass, final Class<?> actualClass, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), backendUnwrappingWithUnknownType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(requestedClass), new org.hibernate.search.util.common.logging.impl.ClassFormatter(actualClass)), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String indexManagerUnwrappingWithUnknownType$str() {
        return "HSEARCH600051: Invalid requested type for this index manager: '%1$s'. Lucene index managers can only be unwrapped to '%2$s'.";
    }
    @Override
    public final SearchException indexManagerUnwrappingWithUnknownType(final Class<?> requestedClass, final Class<?> actualClass, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), indexManagerUnwrappingWithUnknownType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(requestedClass), new org.hibernate.search.util.common.logging.impl.ClassFormatter(actualClass)), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToShutdownShard$str() {
        return "HSEARCH600061: Unable to shut down index: %1$s";
    }
    @Override
    public final SearchException unableToShutdownShard(final String causeMessage, final EventContext context, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToShutdownShard$str(), causeMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToMergeSegments$str() {
        return "HSEARCH600078: Unable to merge index segments: %1$s";
    }
    @Override
    public final SearchException unableToMergeSegments(final String causeMessage, final EventContext context, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToMergeSegments$str(), causeMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToCloseIndexWriterAfterFailures$str() {
        return "HSEARCH600079: Unable to close the index writer after write failures: %1$s";
    }
    @Override
    public final SearchException unableToCloseIndexWriterAfterFailures(final String causeMessage, final EventContext context, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToCloseIndexWriterAfterFailures$str(), causeMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingIndex$str() {
        return "HSEARCH600109: Index does not exist for directory '%1$s'";
    }
    @Override
    public final SearchException missingIndex(final Directory directory, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingIndex$str(), directory), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToValidateIndexDirectory$str() {
        return "HSEARCH600110: Unable to validate index directory: %1$s";
    }
    @Override
    public final SearchException unableToValidateIndexDirectory(final String causeMessage, final EventContext context, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToValidateIndexDirectory$str(), causeMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToDropIndexDirectory$str() {
        return "HSEARCH600111: Unable to drop index directory: %1$s";
    }
    @Override
    public final SearchException unableToDropIndexDirectory(final String causeMessage, final EventContext context, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToDropIndexDirectory$str(), causeMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String uncommittedOperationsBecauseOfFailure$str() {
        return "HSEARCH600118: A failure occurred during a low-level write operation and the index writer had to be reset. Some write operations may have been lost as a result. Failure: %1$s";
    }
    @Override
    public final SearchException uncommittedOperationsBecauseOfFailure(final String causeMessage, final EventContext context, final Throwable cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), uncommittedOperationsBecauseOfFailure$str(), causeMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToComputeIndexSize$str() {
        return "HSEARCH600141: Unable to compute size of index: %1$s";
    }
    @Override
    public final SearchException unableToComputeIndexSize(final String causeMessage, final EventContext context, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToComputeIndexSize$str(), causeMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToStartShard$str() {
        return "HSEARCH600154: Unable to start index: %1$s";
    }
    @Override
    public final SearchException unableToStartShard(final String causeMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToStartShard$str(), causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nonblockingOperationSubmitterNotSupported$str() {
        return "HSEARCH600156: Nonblocking operation submitter is not supported.";
    }
    @Override
    public final SearchException nonblockingOperationSubmitterNotSupported() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), nonblockingOperationSubmitterNotSupported$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToExportSchema$str() {
        return "HSEARCH600157: Unable to export the schema for '%1$s' index: %2$s";
    }
    @Override
    public final SearchException unableToExportSchema(final String indexName, final String message, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToExportSchema$str(), indexName, message), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToRefresh$str() {
        return "HSEARCH600187: Unable to refresh an index reader: %1$s";
    }
    @Override
    public final SearchException unableToRefresh(final String causeMessage, final EventContext context, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToRefresh$str(), causeMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void closingMultiReader(final HibernateSearchMultiReader hibernateSearchMultiReader) {
        super.log.logf(FQCN, TRACE, null, closingMultiReader$str(), hibernateSearchMultiReader);
    }
    protected String closingMultiReader$str() {
        return "HSEARCH600189: Closing MultiReader: %s";
    }
    @Override
    public final void closedMultiReader(final HibernateSearchMultiReader hibernateSearchMultiReader) {
        super.log.logf(FQCN, TRACE, null, closedMultiReader$str(), hibernateSearchMultiReader);
    }
    protected String closedMultiReader$str() {
        return "HSEARCH600190: MultiReader closed: %s";
    }
    @Override
    public final void closedIndexWriter() {
        super.log.logf(FQCN, TRACE, null, closedIndexWriter$str());
    }
    protected String closedIndexWriter$str() {
        return "HSEARCH600191: IndexWriter closed";
    }
    @Override
    public final void openedIndexWriter() {
        super.log.logf(FQCN, TRACE, null, openedIndexWriter$str());
    }
    protected String openedIndexWriter$str() {
        return "HSEARCH600192: IndexWriter opened";
    }
    @Override
    public final void indexWriterSetParameter(final String settingName, final Object value, final String context) {
        super.log.logf(FQCN, DEBUG, null, indexWriterSetParameter$str(), settingName, value, context);
    }
    protected String indexWriterSetParameter$str() {
        return "HSEARCH600193: Set index writer parameter %s to value : %s. %s";
    }
    protected String indexSchemaNodeNameConflict$str() {
        return "HSEARCH600034: Duplicate index field definition: '%1$s'. Index field names must be unique. Look for two property mappings with the same field name, or two indexed-embeddeds with prefixes that lead to conflicting index field names, or two custom bridges declaring index fields with the same name.";
    }
    @Override
    public final SearchException indexSchemaNodeNameConflict(final String relativeFieldName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), indexSchemaNodeNameConflict$str(), relativeFieldName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotGuessFieldType$str() {
        return "HSEARCH600062: No built-in index field type for class: '%1$s'.";
    }
    @Override
    public final SearchException cannotGuessFieldType(final Class<?> inputType, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotGuessFieldType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(inputType)), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String incompleteFieldDefinition$str() {
        return "HSEARCH600071: Incomplete field definition. You must call toReference() to complete the field definition.";
    }
    @Override
    public final SearchException incompleteFieldDefinition(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), incompleteFieldDefinition$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotCreateReferenceMultipleTimes$str() {
        return "HSEARCH600072: Multiple calls to toReference() for the same field definition. You must call toReference() exactly once.";
    }
    @Override
    public final SearchException cannotCreateReferenceMultipleTimes(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotCreateReferenceMultipleTimes$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nullDecimalScale$str() {
        return "HSEARCH600080: Invalid index field type: missing decimal scale. Define the decimal scale explicitly. %1$s";
    }
    @Override
    public final SearchException nullDecimalScale(final String hint, final EventContext eventContext) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), nullDecimalScale$str(), hint), eventContext);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidDecimalScale$str() {
        return "HSEARCH600082: Invalid index field type: decimal scale '%1$s' is positive. The decimal scale of BigInteger fields must be zero or negative.";
    }
    @Override
    public final SearchException invalidDecimalScale(final Integer decimalScale, final EventContext eventContext) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidDecimalScale$str(), decimalScale), eventContext);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String indexSchemaFieldTemplateNameConflict$str() {
        return "HSEARCH600125: Duplicate index field template definition: '%1$s'. Multiple bridges may be trying to access the same index field template,  or two indexed-embeddeds may have prefixes that lead to conflicting field names, or you may have declared multiple conflicting mappings. In any case, there is something wrong with your mapping and you should fix it.";
    }
    @Override
    public final SearchException indexSchemaFieldTemplateNameConflict(final String name, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), indexSchemaFieldTemplateNameConflict$str(), name), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String indexSchemaNamedPredicateNameConflict$str() {
        return "HSEARCH600143: The index schema named predicate '%1$s' was added twice.";
    }
    @Override
    public final SearchException indexSchemaNamedPredicateNameConflict(final String relativeFilterName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), indexSchemaNamedPredicateNameConflict$str(), relativeFilterName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsupportedMixOfHighlightableValues$str() {
        return "HSEARCH600166: Cannot use 'NO' in combination with other highlightable values. Applied values are: '%1$s'";
    }
    @Override
    public final SearchException unsupportedMixOfHighlightableValues(final Set<org.hibernate.search.engine.backend.types.Highlightable> highlightable) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unsupportedMixOfHighlightableValues$str(), highlightable));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String termVectorDontAllowFastVectorHighlighter$str() {
        return "HSEARCH600167: The '%1$s' term vector storage strategy is not compatible with the fast vector highlighter. Either change the strategy to one of `WITH_POSITIONS_PAYLOADS`/`WITH_POSITIONS_OFFSETS_PAYLOADS` or remove the requirement for the fast vector highlighter support.";
    }
    @Override
    public final SearchException termVectorDontAllowFastVectorHighlighter(final TermVector termVector) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), termVectorDontAllowFastVectorHighlighter$str(), termVector));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noHighlightableProvided$str() {
        return "HSEARCH600168: Setting the `highlightable` attribute to an empty array is not supported. Set the value to `NO` if the field does not require the highlight projection.";
    }
    @Override
    public final SearchException noHighlightableProvided() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), noHighlightableProvided$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String vectorPropertyUnsupportedValue$str() {
        return "HSEARCH600174: Vector '%1$s' cannot be equal to '%2$s'. It must be a positive integer value lesser than or equal to %3$s.";
    }
    @Override
    public final SearchException vectorPropertyUnsupportedValue(final String property, final Integer value, final int max) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), vectorPropertyUnsupportedValue$str(), property, value, max));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotGuessVectorFieldType$str() {
        return "HSEARCH600175: No built-in vector index field type for class: '%1$s'.";
    }
    @Override
    public final SearchException cannotGuessVectorFieldType(final Class<?> inputType, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotGuessVectorFieldType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(inputType)), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multiValuedFieldNotAllowed$str() {
        return "HSEARCH600177: Fields of this type cannot be multivalued.";
    }
    @Override
    public final SearchException multiValuedFieldNotAllowed(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multiValuedFieldNotAllowed$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nullVectorDimension$str() {
        return "HSEARCH600179: Invalid index field type: missing vector dimension. Define the vector dimension explicitly. %1$s";
    }
    @Override
    public final SearchException nullVectorDimension(final String hint, final EventContext eventContext) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), nullVectorDimension$str(), hint), eventContext);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void executingLuceneQuery(final Query luceneQuery) {
        super.log.logf(FQCN, TRACE, null, executingLuceneQuery$str(), luceneQuery);
    }
    protected String executingLuceneQuery$str() {
        return "HSEARCH000274: Executing Lucene query: %s";
    }
    protected String cannotMixLuceneSearchQueryWithOtherPredicates$str() {
        return "HSEARCH600010: Invalid search predicate: '%1$s'. You must build the predicate from a Lucene search scope.";
    }
    @Override
    public final SearchException cannotMixLuceneSearchQueryWithOtherPredicates(final SearchPredicate predicate) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixLuceneSearchQueryWithOtherPredicates$str(), predicate));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotMixLuceneSearchSortWithOtherSorts$str() {
        return "HSEARCH600014: Invalid search sort: '%1$s'. You must build the sort from a Lucene search scope.";
    }
    @Override
    public final SearchException cannotMixLuceneSearchSortWithOtherSorts(final SearchSort sort) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixLuceneSearchSortWithOtherSorts$str(), sort));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotMixLuceneScopeWithOtherType$str() {
        return "HSEARCH600024: Invalid multi-index scope: a scope cannot span both a Lucene index and another type of index. Base scope: '%1$s', incompatible (Lucene) index: '%2$s'.";
    }
    @Override
    public final SearchException cannotMixLuceneScopeWithOtherType(final IndexScopeBuilder baseScope, final LuceneIndexManager luceneIndex, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixLuceneScopeWithOtherType$str(), baseScope, luceneIndex), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotMixLuceneScopeWithOtherBackend$str() {
        return "HSEARCH600025: Invalid multi-index scope: a scope cannot span multiple Lucene backends. Base scope: '%1$s', incompatible index (from another backend): '%2$s'.";
    }
    @Override
    public final SearchException cannotMixLuceneScopeWithOtherBackend(final IndexScopeBuilder baseScope, final LuceneIndexManager indexFromOtherBackend, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixLuceneScopeWithOtherBackend$str(), baseScope, indexFromOtherBackend), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String ioExceptionOnQueryExecution$str() {
        return "HSEARCH600027: Unable to execute search query '%1$s': %2$s";
    }
    @Override
    public final SearchException ioExceptionOnQueryExecution(final Query luceneQuery, final String causeMessage, final EventContext context, final IOException cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), ioExceptionOnQueryExecution$str(), luceneQuery, causeMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String minimumShouldMatchMinimumOutOfBounds$str() {
        return "HSEARCH600044: Computed minimum for minimumShouldMatch constraint is out of bounds: expected a number between '1' and '%1$s', got '%2$s'.";
    }
    @Override
    public final SearchException minimumShouldMatchMinimumOutOfBounds(final int totalShouldClauseNumber, final int minimum) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), minimumShouldMatchMinimumOutOfBounds$str(), totalShouldClauseNumber, minimum));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String minimumShouldMatchConflictingConstraints$str() {
        return "HSEARCH600045: Multiple conflicting minimumShouldMatch constraints for ceiling '%1$s'";
    }
    @Override
    public final SearchException minimumShouldMatchConflictingConstraints(final int ignoreConstraintCeiling) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), minimumShouldMatchConflictingConstraints$str(), ignoreConstraintCeiling));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotMixLuceneSearchQueryWithOtherProjections$str() {
        return "HSEARCH600055: Invalid search projection: '%1$s'. You must build the projection from a Lucene search scope.";
    }
    @Override
    public final SearchException cannotMixLuceneSearchQueryWithOtherProjections(final SearchProjection<?> projection) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixLuceneSearchQueryWithOtherProjections$str(), projection));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToDeleteAllEntriesFromIndex$str() {
        return "HSEARCH600067: Unable to delete all entries matching query '%1$s': %2$s";
    }
    @Override
    public final SearchException unableToDeleteAllEntriesFromIndex(final Query query, final String causeMessage, final EventContext context, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToDeleteAllEntriesFromIndex$str(), query, causeMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String fullTextFeaturesNotSupportedByFieldType$str() {
        return "HSEARCH600070: Full-text features (analysis, fuzziness, minimum should match) are not supported for fields of this type.";
    }
    @Override
    public final SearchException fullTextFeaturesNotSupportedByFieldType(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), fullTextFeaturesNotSupportedByFieldType$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String explainRequiresTypeName$str() {
        return "HSEARCH600075: Invalid use of explain(Object id) on a query targeting multiple types. Use explain(String typeName, Object id) and pass one of %1$s as the type name.";
    }
    @Override
    public final SearchException explainRequiresTypeName(final Set<String> targetedTypeNames) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), explainRequiresTypeName$str(), targetedTypeNames));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String explainRequiresTypeTargetedByQuery$str() {
        return "HSEARCH600076: Invalid mapped type name: '%2$s'. This type is not among the mapped types targeted by this query: %1$s.";
    }
    @Override
    public final SearchException explainRequiresTypeTargetedByQuery(final Set<String> targetedTypeNames, final String typeName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), explainRequiresTypeTargetedByQuery$str(), targetedTypeNames, typeName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String explainUnknownDocument$str() {
        return "HSEARCH600077: Invalid document identifier: '%2$s'. No such document for type '%1$s'.";
    }
    @Override
    public final SearchException explainUnknownDocument(final String typeName, final String id) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), explainUnknownDocument$str(), typeName, id));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String predicateDefinedOnDifferentIndexes$str() {
        return "HSEARCH600084: Invalid search predicate: '%1$s'. You must build the predicate from a scope targeting indexes %3$s or a superset of them, but the given predicate was built from a scope targeting indexes %2$s, where indexes %4$s are missing.";
    }
    @Override
    public final SearchException predicateDefinedOnDifferentIndexes(final SearchPredicate predicate, final Set<String> predicateIndexes, final Set<String> scopeIndexes, final Set<String> scopeDifference) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), predicateDefinedOnDifferentIndexes$str(), predicate, predicateIndexes, scopeIndexes, scopeDifference));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String sortDefinedOnDifferentIndexes$str() {
        return "HSEARCH600085: Invalid search sort: '%1$s'. You must build the sort from a scope targeting indexes %3$s or a superset of them, but the given sort was built from a scope targeting indexes %2$s, where indexes %4$s are missing.";
    }
    @Override
    public final SearchException sortDefinedOnDifferentIndexes(final SearchSort sort, final Set<String> sortIndexes, final Set<String> scopeIndexes, final Set<String> scopeDifference) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), sortDefinedOnDifferentIndexes$str(), sort, sortIndexes, scopeIndexes, scopeDifference));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String projectionDefinedOnDifferentIndexes$str() {
        return "HSEARCH600086: Invalid search projection: '%1$s'. You must build the projection from a scope targeting indexes %3$s or a superset of them, but the given projection was built from a scope targeting indexes %2$s, where indexes %4$s are missing.";
    }
    @Override
    public final SearchException projectionDefinedOnDifferentIndexes(final SearchProjection<?> projection, final Set<String> projectionIndexes, final Set<String> scopeIndexes, final Set<String> scopeDifference) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), projectionDefinedOnDifferentIndexes$str(), projection, projectionIndexes, scopeIndexes, scopeDifference));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotMixLuceneSearchQueryWithOtherAggregations$str() {
        return "HSEARCH600098: Invalid search aggregation: '%1$s'. You must build the aggregation from a Lucene search scope.";
    }
    @Override
    public final SearchException cannotMixLuceneSearchQueryWithOtherAggregations(final SearchAggregation<?> aggregation) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixLuceneSearchQueryWithOtherAggregations$str(), aggregation));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String aggregationDefinedOnDifferentIndexes$str() {
        return "HSEARCH600099: Invalid search aggregation: '%1$s'. You must build the aggregation from a scope targeting indexes %3$s or a superset of them, but the given aggregation was built from a scope targeting indexes %2$s, where indexes %4$s are missing";
    }
    @Override
    public final SearchException aggregationDefinedOnDifferentIndexes(final SearchAggregation<?> aggregation, final Set<String> aggregationIndexes, final Set<String> scopeIndexes, final Set<String> scopeDifference) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), aggregationDefinedOnDifferentIndexes$str(), aggregation, aggregationIndexes, scopeIndexes, scopeDifference));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String duplicateAggregationKey$str() {
        return "HSEARCH600102: Duplicate aggregation definitions for key: '%1$s'";
    }
    @Override
    public final SearchException duplicateAggregationKey(final AggregationKey<?> key) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), duplicateAggregationKey$str(), new org.hibernate.search.engine.logging.spi.AggregationKeyFormatter(key)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidSortModeAcrossNested$str() {
        return "HSEARCH600114: Invalid sort mode: %1$s. This sort mode is not supported for fields in nested documents.";
    }
    @Override
    public final SearchException invalidSortModeAcrossNested(final SortMode mode, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidSortModeAcrossNested$str(), mode), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidSortModeForStringField$str() {
        return "HSEARCH600115: Invalid sort mode: %1$s. This sort mode is not supported for String fields. Only MIN and MAX are supported.";
    }
    @Override
    public final SearchException invalidSortModeForStringField(final SortMode mode, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidSortModeForStringField$str(), mode), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidSortModeForTemporalField$str() {
        return "HSEARCH600116: Invalid sort mode: %1$s. This sort mode is not supported for temporal fields. Only MIN, MAX, AVG and MEDIAN are supported.";
    }
    @Override
    public final SearchException invalidSortModeForTemporalField(final SortMode mode, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidSortModeForTemporalField$str(), mode), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotFilterSortOnRootDocumentField$str() {
        return "HSEARCH600120: Invalid sort filter: field '%1$s' is not contained in a nested object. Sort filters are only available if the field to sort on is contained in a nested object.";
    }
    @Override
    public final SearchException cannotFilterSortOnRootDocumentField(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotFilterSortOnRootDocumentField$str(), absoluteFieldPath), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidNestedObjectPathForPredicate$str() {
        return "HSEARCH600121: Invalid search predicate: %1$s. This predicate targets fields %3$s, but only fields that are contained in the nested object with path '%2$s' are allowed here.";
    }
    @Override
    public final SearchException invalidNestedObjectPathForPredicate(final SearchPredicate predicate, final String nestedObjectPath, final List<String> fieldPaths) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidNestedObjectPathForPredicate$str(), predicate, nestedObjectPath, fieldPaths));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotFilterAggregationOnRootDocumentField$str() {
        return "HSEARCH600122: Invalid aggregation filter: field '%1$s' is not contained in a nested object. Aggregation filters are only available if the field to aggregate on is contained in a nested object.";
    }
    @Override
    public final SearchException cannotFilterAggregationOnRootDocumentField(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotFilterAggregationOnRootDocumentField$str(), absoluteFieldPath), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidSingleValuedProjectionOnMultiValuedField$str() {
        return "HSEARCH600131: Invalid cardinality for projection on field '%1$s': the projection is single-valued, but this field is multi-valued. Make sure to call '.collector(...)' when you create the projection.";
    }
    @Override
    public final SearchException invalidSingleValuedProjectionOnMultiValuedField(final String absolutePath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidSingleValuedProjectionOnMultiValuedField$str(), absolutePath), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String differentImplementationClassForQueryElement$str() {
        return "HSEARCH600135: Implementation class differs: '%1$s' vs. '%2$s'.";
    }
    @Override
    public final SearchException differentImplementationClassForQueryElement(final Class<?> class1, final Class<?> class2) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), differentImplementationClassForQueryElement$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(class1), new org.hibernate.search.util.common.logging.impl.ClassFormatter(class2)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String differentFieldCodecForQueryElement$str() {
        return "HSEARCH600136: Field codec differs: '%1$s' vs. '%2$s'.";
    }
    @Override
    public final SearchException differentFieldCodecForQueryElement(final Object codec1, final Object codec2) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), differentFieldCodecForQueryElement$str(), codec1, codec2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String differentPredicateDefinitionForQueryElement$str() {
        return "HSEARCH600144: Predicate definition differs: '%1$s' vs. '%2$s'.";
    }
    @Override
    public final SearchException differentPredicateDefinitionForQueryElement(final Object predicateDefinition1, final Object predicateDefinition2) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), differentPredicateDefinitionForQueryElement$str(), predicateDefinition1, predicateDefinition2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String paramNotDefined$str() {
        return "HSEARCH600150: Param with name '%1$s' has not been defined for the named predicate '%2$s'.";
    }
    @Override
    public final SearchException paramNotDefined(final String name, final String predicateName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), paramNotDefined$str(), name, predicateName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String offsetLimitExceedsMaxValue$str() {
        return "HSEARCH600151: Offset + limit should be lower than Integer.MAX_VALUE, offset: '%1$s', limit: '%2$s'.";
    }
    @Override
    public final IOException offsetLimitExceedsMaxValue(final int offset, final Integer limit) {
        final IOException result = new IOException(String.format(getLoggingLocale(), offsetLimitExceedsMaxValue$str(), offset, limit));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidContextForProjectionOnField$str() {
        return "HSEARCH600152: Invalid context for projection on field '%1$s': the surrounding projection is executed for each object in field '%2$s', which is not a parent of field '%1$s'. Check the structure of your projections.";
    }
    @Override
    public final SearchException invalidContextForProjectionOnField(final String absolutePath, final String objectFieldAbsolutePath) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidContextForProjectionOnField$str(), absolutePath, objectFieldAbsolutePath));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidSingleValuedProjectionOnValueFieldInMultiValuedObjectField$str() {
        return "HSEARCH600153: Invalid cardinality for projection on field '%1$s': the projection is single-valued, but this field is effectively multi-valued in this context, because parent object field '%2$s' is multi-valued. Either call '.collector(...)' when you create the projection on field '%1$s', or wrap that projection in an object projection like this: 'f.object(\"%2$s\").from(<the projection on field %1$s>).as(...).collector(...)'.";
    }
    @Override
    public final SearchException invalidSingleValuedProjectionOnValueFieldInMultiValuedObjectField(final String absolutePath, final String objectFieldAbsolutePath) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidSingleValuedProjectionOnValueFieldInMultiValuedObjectField$str(), absolutePath, objectFieldAbsolutePath));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unexpectedMappedTypeNameForByMappedTypeProjection$str() {
        return "HSEARCH600155: Unexpected mapped type name extracted from hits: '%1$s'. Expected one of: %2$s. The document was probably indexed with a different configuration: full reindexing is necessary.";
    }
    @Override
    public final SearchException unexpectedMappedTypeNameForByMappedTypeProjection(final String typeName, final Set<String> expectedTypeNames) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unexpectedMappedTypeNameForByMappedTypeProjection$str(), typeName, expectedTypeNames));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotMixLuceneSearchQueryWithOtherQueryHighlighters$str() {
        return "HSEARCH600158: Invalid highlighter: '%1$s'. You must build the highlighter from a Lucene search scope.";
    }
    @Override
    public final SearchException cannotMixLuceneSearchQueryWithOtherQueryHighlighters(final SearchHighlighter highlighter) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixLuceneSearchQueryWithOtherQueryHighlighters$str(), highlighter));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String queryHighlighterDefinedOnDifferentIndexes$str() {
        return "HSEARCH600159: Invalid highlighter: '%1$s'. You must build the highlighter from a scope targeting indexes %3$s or a superset of them, but the given highlighter was built from a scope targeting indexes %2$s, where indexes %4$s are missing.";
    }
    @Override
    public final SearchException queryHighlighterDefinedOnDifferentIndexes(final SearchHighlighter highlighter, final Set<String> highlighterIndexes, final Set<String> scopeIndexes, final Set<String> scopeDifference) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), queryHighlighterDefinedOnDifferentIndexes$str(), highlighter, highlighterIndexes, scopeIndexes, scopeDifference));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotMixDifferentHighlighterTypesAtOverrideLevel$str() {
        return "HSEARCH600160: Overriding a '%2$s' highlighter with a '%1$s' is not supported. Overriding highlighters should be of the same type as the global is if the global highlighter was configured.";
    }
    @Override
    public final SearchException cannotMixDifferentHighlighterTypesAtOverrideLevel(final SearchHighlighterType override, final SearchHighlighterType parent) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixDifferentHighlighterTypesAtOverrideLevel$str(), override, parent));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotFindHighlighterWithName$str() {
        return "HSEARCH600161: Cannot find a highlighter with name '%1$s'. Available highlighters are: %2$s. Was it configured with `highlighter(\"%1$s\", highlighterContributor)`?";
    }
    @Override
    public final SearchException cannotFindHighlighterWithName(final String name, final Collection<String> availableHighlighterNames) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotFindHighlighterWithName$str(), name, availableHighlighterNames));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsupportedBoundaryScannerType$str() {
        return "HSEARCH600162: '%1$s' highlighter does not support '%2$s' boundary scanner type.";
    }
    @Override
    public final SearchException unsupportedBoundaryScannerType(final String type, final BoundaryScannerType boundaryScannerType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unsupportedBoundaryScannerType$str(), type, boundaryScannerType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String highlighterNameCannotBeBlank$str() {
        return "HSEARCH600163: Named highlighters cannot use a blank string as name.";
    }
    @Override
    public final SearchException highlighterNameCannotBeBlank() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), highlighterNameCannotBeBlank$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String highlighterWithTheSameNameCannotBeAdded$str() {
        return "HSEARCH600164: Highlighter with name '%1$s' is already defined. Use a different name to add another highlighter.";
    }
    @Override
    public final SearchException highlighterWithTheSameNameCannotBeAdded(final String highlighterName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), highlighterWithTheSameNameCannotBeAdded$str(), highlighterName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String highlighterTypeNotSupported$str() {
        return "HSEARCH600165: '%1$s' highlighter type cannot be applied to '%2$s' field. '%2$s' must have either 'ANY' or '%1$s' among the configured highlightable values.";
    }
    @Override
    public final SearchException highlighterTypeNotSupported(final SearchHighlighterType type, final String field) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), highlighterTypeNotSupported$str(), type, field));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void unifiedHighlighterNoMatchSizeWarning(final Integer value) {
        super.log.logf(FQCN, WARN, null, unifiedHighlighterNoMatchSizeWarning$str(), value);
    }
    protected String unifiedHighlighterNoMatchSizeWarning$str() {
        return "HSEARCH600169: Lucene's unified highlighter cannot limit the size of a fragment returned when no match is found. Instead if no match size was set to any positive integer - all text will be returned. Configured value '%1$s' will be ignored, and the fragment will not be limited. If you don't want to see this warning set the value to Integer.MAX_VALUE.";
    }
    protected String unifiedHighlighterFragmentSizeNotSupported$str() {
        return "HSEARCH600170: Lucene's unified highlighter does not support the size fragment setting. Either use a plain or fast vector highlighters, or do not set this setting.";
    }
    @Override
    public final SearchException unifiedHighlighterFragmentSizeNotSupported() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unifiedHighlighterFragmentSizeNotSupported$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotHighlightInNestedContext$str() {
        return "HSEARCH600171: Highlight projection cannot be applied within nested context of '%1$s'.";
    }
    @Override
    public final SearchException cannotHighlightInNestedContext(final String currentNestingField, final EventContext eventContext) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotHighlightInNestedContext$str(), currentNestingField), eventContext);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotHighlightFieldFromNestedObjectStructure$str() {
        return "HSEARCH600172: The highlight projection cannot be applied to a field from an object using `ObjectStructure.NESTED` structure.";
    }
    @Override
    public final SearchException cannotHighlightFieldFromNestedObjectStructure(final EventContext eventContext) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotHighlightFieldFromNestedObjectStructure$str()), eventContext);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotUseProjectionInNestedContext$str() {
        return "HSEARCH600173: '%1$s' cannot be nested in an object projection. %2$s";
    }
    @Override
    public final SearchException cannotUseProjectionInNestedContext(final String projection, final String hint, final EventContext eventContext) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotUseProjectionInNestedContext$str(), projection, hint), eventContext);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidSortModeForDistanceSort$str() {
        return "HSEARCH600117: Invalid sort mode: %1$s. This sort mode is not supported for a distance sort. Only MIN, MAX, AVG and MEDIAN are supported.";
    }
    @Override
    public final SearchException invalidSortModeForDistanceSort(final SortMode mode, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidSortModeForDistanceSort$str(), mode), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String vectorKnnMatchVectorTypeDiffersFromField$str() {
        return "HSEARCH600176: Vector field '%1$s' is defined as a '%2$s' array. Matching against '%3$s' array is unsupported. Use the array of the same type as the vector field.";
    }
    @Override
    public final SearchException vectorKnnMatchVectorTypeDiffersFromField(final String absoluteFieldPath, final Class<?> expected, final Class<?> actual) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), vectorKnnMatchVectorTypeDiffersFromField$str(), absoluteFieldPath, new org.hibernate.search.util.common.logging.impl.ClassFormatter(expected), new org.hibernate.search.util.common.logging.impl.ClassFormatter(actual)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String vectorKnnMatchVectorDimensionDiffersFromField$str() {
        return "HSEARCH600178: Vector field '%1$s' is defined as a vector with '%2$s' dimensions (array length). Matching against an array with length of '%3$s' is unsupported. Use the array of the same size as the vector field.";
    }
    @Override
    public final SearchException vectorKnnMatchVectorDimensionDiffersFromField(final String absoluteFieldPath, final int expected, final int actual) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), vectorKnnMatchVectorDimensionDiffersFromField$str(), absoluteFieldPath, expected, actual));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String queryStringParseException$str() {
        return "HSEARCH600180: An error occurred while parsing the query string '%1$s': %2$s";
    }
    @Override
    public final SearchException queryStringParseException(final String query, final String message, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), queryStringParseException$str(), query, message), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String highlighterIncompatibleCardinality$str() {
        return "HSEARCH600186: A single-valued highlight projection requested, but the corresponding highlighter does not set number of fragments to 1.";
    }
    @Override
    public final SearchException highlighterIncompatibleCardinality() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), highlighterIncompatibleCardinality$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
