/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.codec.impl;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.function.Consumer;
import org.apache.lucene.document.KnnFloatVectorField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.util.VectorUtil;
import org.hibernate.search.backend.lucene.lowlevel.codec.impl.HibernateSearchKnnVectorsFormat;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneVectorFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.Indexing;
import org.hibernate.search.backend.lucene.types.codec.impl.Storage;

public class LuceneFloatVectorCodec
extends AbstractLuceneVectorFieldCodec<float[]> {
    private static final float EPS = 1.0E-5f;

    public LuceneFloatVectorCodec(VectorSimilarityFunction vectorSimilarity, int dimension, Storage storage, Indexing indexing, float[] indexNullAsValue, HibernateSearchKnnVectorsFormat knnVectorsFormat) {
        super(vectorSimilarity, dimension, storage, indexing, indexNullAsValue, knnVectorsFormat, LuceneFloatVectorCodec.check(vectorSimilarity));
    }

    @Override
    public float[] decode(IndexableField field) {
        float[] result = new float[field.binaryValue().bytes.length / 4];
        int index = 0;
        ByteBuffer buffer = ByteBuffer.wrap(field.binaryValue().bytes);
        while (buffer.hasRemaining()) {
            result[index++] = buffer.getFloat();
        }
        return result;
    }

    @Override
    protected byte[] toByteArray(float[] value) {
        ByteBuffer buffer = ByteBuffer.allocate(4 * value.length);
        for (float element : value) {
            buffer.putFloat(element);
        }
        return buffer.array();
    }

    @Override
    protected IndexableField createIndexField(String absoluteFieldPath, float[] value) {
        return new KnnFloatVectorField(absoluteFieldPath, value, this.fieldType);
    }

    @Override
    protected VectorEncoding vectorEncoding() {
        return VectorEncoding.FLOAT32;
    }

    @Override
    public Class<?> vectorElementsType() {
        return Float.TYPE;
    }

    private static Consumer<float[]> check(VectorSimilarityFunction similarityFunction) {
        switch (similarityFunction) {
            case DOT_PRODUCT: {
                return LuceneFloatVectorCodec::dotProductCheck;
            }
            case COSINE: {
                return LuceneFloatVectorCodec::cosineCheck;
            }
        }
        return LuceneFloatVectorCodec::noop;
    }

    private static void cosineCheck(float[] vector) {
        float l1 = VectorUtil.dotProduct((float[])vector, (float[])vector);
        if (l1 < 1.0E-5f) {
            throw log.vectorCosineZeroMagnitudeNotAcceptable(Arrays.toString(vector));
        }
    }

    private static void dotProductCheck(float[] vector) {
        float l1 = VectorUtil.dotProduct((float[])vector, (float[])vector);
        if (Math.abs(1.0 - Math.sqrt(l1)) > (double)1.0E-5f) {
            throw log.vectorDotProductNonUnitMagnitudeNotAcceptable(Arrays.toString(vector));
        }
    }

    private static void noop(float[] vector) {
    }
}

