/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.sort.impl;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.sort.impl.AbstractLuceneSort;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneSearchSort;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneSearchSortCollector;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.engine.search.sort.spi.CompositeSortBuilder;

class LuceneCompositeSort
extends AbstractLuceneSort {
    private final List<LuceneSearchSort> elements;

    LuceneCompositeSort(Builder builder) {
        super(builder);
        this.elements = builder.elements;
        builder.elements = null;
    }

    @Override
    public void toSortFields(LuceneSearchSortCollector collector) {
        for (LuceneSearchSort element : this.elements) {
            element.toSortFields(collector);
        }
    }

    static class Builder
    extends AbstractLuceneSort.AbstractBuilder
    implements CompositeSortBuilder {
        private List<LuceneSearchSort> elements = new ArrayList<LuceneSearchSort>();

        Builder(LuceneSearchIndexScope<?> scope) {
            super(scope);
        }

        public void add(SearchSort sort) {
            this.elements.add(LuceneSearchSort.from(this.scope, sort));
        }

        public SearchSort build() {
            return new LuceneCompositeSort(this);
        }
    }
}

