/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.highlighter.impl;

import java.io.IOException;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.vectorhighlight.BoundaryScanner;
import org.apache.lucene.search.vectorhighlight.BreakIteratorBoundaryScanner;
import org.apache.lucene.search.vectorhighlight.FastVectorHighlighter;
import org.apache.lucene.search.vectorhighlight.FieldFragList;
import org.apache.lucene.search.vectorhighlight.FragListBuilder;
import org.apache.lucene.search.vectorhighlight.FragmentsBuilder;
import org.apache.lucene.search.vectorhighlight.ScoreOrderFragmentsBuilder;
import org.apache.lucene.search.vectorhighlight.SimpleBoundaryScanner;
import org.apache.lucene.search.vectorhighlight.SimpleFieldFragList;
import org.apache.lucene.search.vectorhighlight.SimpleFragListBuilder;
import org.apache.lucene.search.vectorhighlight.SimpleFragmentsBuilder;
import org.apache.lucene.search.vectorhighlight.SingleFragListBuilder;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.Values;
import org.hibernate.search.backend.lucene.search.highlighter.impl.LuceneAbstractSearchHighlighter;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneFieldHighlightProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionExtractContext;
import org.hibernate.search.engine.search.highlighter.dsl.HighlighterFragmenter;
import org.hibernate.search.engine.search.highlighter.spi.BoundaryScannerType;
import org.hibernate.search.engine.search.highlighter.spi.SearchHighlighterType;
import org.hibernate.search.engine.search.projection.spi.ProjectionAccumulator;

class LuceneFastVectorSearchHighlighter
extends LuceneAbstractSearchHighlighter {
    private static final LuceneFastVectorSearchHighlighter DEFAULTS = new LuceneFastVectorSearchHighlighter(BoundaryScannerType.CHARS);

    private LuceneFastVectorSearchHighlighter(BoundaryScannerType scannerType) {
        super(scannerType);
    }

    protected LuceneFastVectorSearchHighlighter(LuceneAbstractSearchHighlighter.Builder builder) {
        super(builder);
    }

    private LuceneFastVectorSearchHighlighter(Set<String> indexNames, Character[] boundaryChars, Integer boundaryMaxScan, Integer fragmentSize, Integer noMatchSize, Integer numberOfFragments, Boolean orderByScore, List<String> preTags, List<String> postTags, BoundaryScannerType boundaryScannerType, Locale boundaryScannerLocale, HighlighterFragmenter fragmenterType, Integer phraseLimit, Encoder encoder) {
        super(indexNames, boundaryChars, boundaryMaxScan, fragmentSize, noMatchSize, numberOfFragments, orderByScore, preTags, postTags, boundaryScannerType, boundaryScannerLocale, fragmenterType, phraseLimit, encoder);
    }

    @Override
    protected LuceneAbstractSearchHighlighter createHighlighterSameType(Set<String> indexNames, Character[] boundaryChars, Integer boundaryMaxScan, Integer fragmentSize, Integer noMatchSize, Integer numberOfFragments, Boolean orderByScore, List<String> preTags, List<String> postTags, BoundaryScannerType boundaryScannerType, Locale boundaryScannerLocale, HighlighterFragmenter fragmenterType, Integer phraseLimit, Encoder encoder) {
        return new LuceneFastVectorSearchHighlighter(indexNames, boundaryChars, boundaryMaxScan, fragmentSize, noMatchSize, numberOfFragments, orderByScore, preTags, postTags, boundaryScannerType, boundaryScannerLocale, fragmenterType, phraseLimit, encoder);
    }

    @Override
    public LuceneAbstractSearchHighlighter withFallbackDefaults() {
        return this.withFallback(DEFAULTS);
    }

    @Override
    public <A, T> Values<A> createValues(String parentDocumentPath, String nestedDocumentPath, String absoluteFieldPath, Analyzer analyzer, ProjectionExtractContext context, ProjectionAccumulator<String, ?, A, T> accumulator) {
        return new FastVectorHighlighterValues<A, T>(parentDocumentPath, nestedDocumentPath, absoluteFieldPath, context, accumulator);
    }

    @Override
    public SearchHighlighterType type() {
        return SearchHighlighterType.FAST_VECTOR;
    }

    private final class FastVectorHighlighterValues<A, T>
    extends LuceneFieldHighlightProjection.HighlighterValues<A, T> {
        private final FastVectorHighlighter highlighter;
        private final String field;
        private final Query query;
        private final FragListBuilder fragListBuilder;
        private final FragmentsBuilder fragmentsBuilder;
        private final FragmentsBuilder noMatchFragments;
        private final String[] preTags;
        private final String[] postTags;
        private final Integer maxNumFragments;

        FastVectorHighlighterValues(String parentDocumentPath, String nestedDocumentPath, String field, ProjectionExtractContext context, ProjectionAccumulator<String, ?, A, T> accumulator) {
            super(parentDocumentPath, nestedDocumentPath, context.collectorExecutionContext(), accumulator);
            this.field = field;
            this.highlighter = new FastVectorHighlighter();
            this.highlighter.setPhraseLimit(LuceneFastVectorSearchHighlighter.this.phraseLimit.intValue());
            this.query = context.collectorExecutionContext().originalQuery();
            this.fragListBuilder = LuceneFastVectorSearchHighlighter.this.numberOfFragments == 0 ? new SingleFragListBuilder() : new SimpleFragListBuilder();
            this.preTags = LuceneFastVectorSearchHighlighter.this.preTags.toArray(new String[LuceneFastVectorSearchHighlighter.this.preTags.size()]);
            this.postTags = LuceneFastVectorSearchHighlighter.this.postTags.toArray(new String[LuceneFastVectorSearchHighlighter.this.postTags.size()]);
            BoundaryScanner boundaryScanner = this.boundaryScanner();
            if (Boolean.TRUE.equals(LuceneFastVectorSearchHighlighter.this.orderByScore)) {
                CustomScoreOrderFragmentsBuilder builder = new CustomScoreOrderFragmentsBuilder(this.preTags, this.postTags, boundaryScanner);
                builder.setDiscreteMultiValueHighlighting(true);
                this.fragmentsBuilder = builder;
            } else {
                SimpleFragmentsBuilder builder = new SimpleFragmentsBuilder(this.preTags, this.postTags, boundaryScanner);
                builder.setDiscreteMultiValueHighlighting(true);
                this.fragmentsBuilder = builder;
            }
            this.noMatchFragments = new NoMatchFragmentsBuilder(this.preTags, this.postTags, boundaryScanner);
            this.maxNumFragments = LuceneFastVectorSearchHighlighter.this.numberOfFragments > 0 ? LuceneFastVectorSearchHighlighter.this.numberOfFragments : Integer.MAX_VALUE;
        }

        private BoundaryScanner boundaryScanner() {
            switch (LuceneFastVectorSearchHighlighter.this.boundaryScannerType) {
                case CHARS: {
                    return new SimpleBoundaryScanner(LuceneFastVectorSearchHighlighter.this.boundaryMaxScan.intValue(), LuceneFastVectorSearchHighlighter.this.boundaryChars);
                }
                case SENTENCE: {
                    return new BreakIteratorBoundaryScanner(BreakIterator.getSentenceInstance(LuceneFastVectorSearchHighlighter.this.boundaryScannerLocale));
                }
                case WORD: {
                    return new BreakIteratorBoundaryScanner(BreakIterator.getWordInstance(LuceneFastVectorSearchHighlighter.this.boundaryScannerLocale));
                }
            }
            throw LuceneAbstractSearchHighlighter.log.unsupportedBoundaryScannerType(LuceneFastVectorSearchHighlighter.this.getClass().getSimpleName(), LuceneFastVectorSearchHighlighter.this.boundaryScannerType);
        }

        @Override
        public List<String> highlight(int doc) throws IOException {
            String[] bestFragments = this.highlighter.getBestFragments(this.highlighter.getFieldQuery(this.query, (IndexReader)this.leafReaderContext.reader()), (IndexReader)this.leafReaderContext.reader(), doc, this.field, LuceneFastVectorSearchHighlighter.this.fragmentSize.intValue(), this.maxNumFragments.intValue(), this.fragListBuilder, this.fragmentsBuilder, this.preTags, this.postTags, LuceneFastVectorSearchHighlighter.this.encoder);
            if (bestFragments != null && bestFragments.length > 0) {
                return Arrays.asList(bestFragments);
            }
            if (LuceneFastVectorSearchHighlighter.this.noMatchSize > 0) {
                SimpleFieldFragList fieldFragList = new SimpleFieldFragList(-1);
                fieldFragList.add(0, LuceneFastVectorSearchHighlighter.this.noMatchSize.intValue(), Collections.emptyList());
                String[] fragment = this.noMatchFragments.createFragments((IndexReader)this.leafReaderContext.reader(), doc, this.field, (FieldFragList)fieldFragList, 1, this.preTags, this.postTags, LuceneFastVectorSearchHighlighter.this.encoder);
                return fragment == null || fragment.length == 0 ? Collections.emptyList() : Collections.singletonList(fragment[0]);
            }
            return Collections.emptyList();
        }
    }

    private static class CustomScoreOrderFragmentsBuilder
    extends ScoreOrderFragmentsBuilder {
        private static final ScoreOrderFragmentsBuilder.ScoreComparator SCORE_COMPARATOR = new ScoreOrderFragmentsBuilder.ScoreComparator();

        public CustomScoreOrderFragmentsBuilder(String[] preTags, String[] postTags, BoundaryScanner bs) {
            super(preTags, postTags, bs);
        }

        public List<FieldFragList.WeightedFragInfo> getWeightedFragInfoList(List<FieldFragList.WeightedFragInfo> src) {
            Collections.sort(src, SCORE_COMPARATOR);
            return src;
        }
    }

    private static class NoMatchFragmentsBuilder
    extends SimpleFragmentsBuilder {
        public NoMatchFragmentsBuilder(String[] preTags, String[] postTags, BoundaryScanner bs) {
            super(preTags, postTags, bs);
            this.setDiscreteMultiValueHighlighting(true);
        }

        protected List<FieldFragList.WeightedFragInfo> discreteMultiValueHighlighting(List<FieldFragList.WeightedFragInfo> fragInfos, Field[] fields) {
            ArrayList<FieldFragList.WeightedFragInfo> result = new ArrayList<FieldFragList.WeightedFragInfo>();
            for (Field field : fields) {
                result.add(new FieldFragList.WeightedFragInfo(0, field.stringValue().length(), Collections.emptyList(), 0.0f));
            }
            return result;
        }
    }
}

