/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.projection.impl;

import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorExecutionContext;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.DocumentReferenceValues;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.Values;
import org.hibernate.search.backend.lucene.reporting.impl.LuceneSearchHints;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneDocumentReference;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.projection.impl.AbstractLuceneProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionExtractContext;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionRequestContext;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionTransformContext;
import org.hibernate.search.engine.backend.common.DocumentReference;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.engine.search.projection.spi.ProjectionTypeKeys;

public class LuceneEntityLoadingProjection<E>
extends AbstractLuceneProjection<E>
implements LuceneSearchProjection.Extractor<Object, E> {
    LuceneEntityLoadingProjection(LuceneSearchIndexScope<?> scope) {
        super(scope);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public LuceneSearchProjection.Extractor<?, E> request(ProjectionRequestContext context) {
        context.checkNotNested(ProjectionTypeKeys.ENTITY, LuceneSearchHints.INSTANCE.entityProjectionNestingNotSupportedHint());
        return this;
    }

    @Override
    public Values<Object> values(ProjectionExtractContext context) {
        final ProjectionHitMapper<?> mapper = context.projectionHitMapper();
        return new DocumentReferenceValues<Object>(context.idReader(), (CollectorExecutionContext)context.collectorExecutionContext()){

            @Override
            protected Object toReference(String typeName, String identifier) {
                return mapper.planLoading((DocumentReference)new LuceneDocumentReference(typeName, identifier));
            }
        };
    }

    @Override
    public E transform(LoadingResult<?> loadingResult, Object extractedData, ProjectionTransformContext context) {
        Object loaded = loadingResult.get(extractedData);
        if (loaded == null) {
            context.reportFailedLoad();
        }
        return (E)loaded;
    }
}

