/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.work.execution.impl;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneParallelWorkOrchestrator;
import org.hibernate.search.backend.lucene.work.execution.impl.WorkExecutionIndexManagerContext;
import org.hibernate.search.backend.lucene.work.impl.IndexManagementWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneWorkFactory;
import org.hibernate.search.engine.backend.work.execution.OperationSubmitter;
import org.hibernate.search.engine.backend.work.execution.spi.IndexWorkspace;

public class LuceneIndexWorkspace
implements IndexWorkspace {
    private final LuceneWorkFactory factory;
    private final WorkExecutionIndexManagerContext indexManagerContext;
    private final Set<String> tenantIds;

    public LuceneIndexWorkspace(LuceneWorkFactory factory, WorkExecutionIndexManagerContext indexManagerContext, Set<String> tenantIds) {
        this.factory = factory;
        this.indexManagerContext = indexManagerContext;
        this.tenantIds = tenantIds;
    }

    public CompletableFuture<?> mergeSegments(OperationSubmitter operationSubmitter) {
        return this.doSubmit(this.indexManagerContext.allManagementOrchestrators(), this.factory.mergeSegments(), false, operationSubmitter);
    }

    public CompletableFuture<?> purge(Set<String> routingKeys, OperationSubmitter operationSubmitter) {
        return this.doSubmit(this.indexManagerContext.managementOrchestrators(routingKeys), this.factory.deleteAll(this.tenantIds, routingKeys), true, operationSubmitter);
    }

    public CompletableFuture<?> flush(OperationSubmitter operationSubmitter) {
        return this.doSubmit(this.indexManagerContext.allManagementOrchestrators(), this.factory.flush(), false, operationSubmitter);
    }

    public CompletableFuture<?> refresh(OperationSubmitter operationSubmitter) {
        return this.doSubmit(this.indexManagerContext.allManagementOrchestrators(), this.factory.refresh(), false, operationSubmitter);
    }

    private <T> CompletableFuture<?> doSubmit(List<LuceneParallelWorkOrchestrator> orchestrators, IndexManagementWork<T> work, boolean commit, OperationSubmitter operationSubmitter) {
        CompletableFuture[] writeFutures = new CompletableFuture[orchestrators.size()];
        CompletableFuture[] writeAndCommitFutures = new CompletableFuture[orchestrators.size()];
        for (int i = 0; i < writeFutures.length; ++i) {
            CompletableFuture writeFuture;
            LuceneParallelWorkOrchestrator orchestrator = orchestrators.get(i);
            writeFutures[i] = writeFuture = new CompletableFuture();
            writeAndCommitFutures[i] = commit ? writeFutures[i].thenRun(orchestrator::forceCommitInCurrentThread) : writeFuture;
            orchestrator.submit(writeFuture, work, operationSubmitter);
        }
        return CompletableFuture.allOf(writeAndCommitFutures);
    }
}

