/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.index.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import org.apache.lucene.index.DirectoryReader;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.index.impl.IndexAccessorImpl;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneParallelWorkOrchestrator;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneParallelWorkOrchestratorImpl;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneSerialWorkOrchestrator;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneSerialWorkOrchestratorImpl;
import org.hibernate.search.engine.backend.orchestration.spi.AbstractWorkOrchestrator;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public final class Shard {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final EventContext eventContext;
    private final IndexAccessorImpl indexAccessor;
    private final LuceneParallelWorkOrchestratorImpl managementOrchestrator;
    private final LuceneSerialWorkOrchestratorImpl indexingOrchestrator;

    Shard(EventContext eventContext, IndexAccessorImpl indexAccessor, LuceneParallelWorkOrchestratorImpl managementOrchestrator, LuceneSerialWorkOrchestratorImpl indexingOrchestrator) {
        this.eventContext = eventContext;
        this.indexAccessor = indexAccessor;
        this.managementOrchestrator = managementOrchestrator;
        this.indexingOrchestrator = indexingOrchestrator;
    }

    void start(ConfigurationPropertySource propertySource) {
        try {
            this.indexAccessor.start();
            this.managementOrchestrator.start(propertySource);
            this.indexingOrchestrator.start(propertySource);
        }
        catch (IOException | RuntimeException e) {
            ((SuppressingCloser)new SuppressingCloser((Throwable)e).push((AutoCloseable)this.indexAccessor).push(AbstractWorkOrchestrator::stop, (Object)this.indexingOrchestrator)).push(AbstractWorkOrchestrator::stop, (Object)this.managementOrchestrator);
            throw log.unableToInitializeIndexDirectory(e.getMessage(), this.eventContext, e);
        }
    }

    CompletableFuture<?> preStop() {
        return this.indexingOrchestrator.preStop();
    }

    void stop() {
        try (Closer closer = new Closer();){
            closer.push(AbstractWorkOrchestrator::stop, (Object)this.indexingOrchestrator);
            closer.push(AbstractWorkOrchestrator::stop, (Object)this.managementOrchestrator);
            closer.push(IndexAccessorImpl::close, (Object)this.indexAccessor);
        }
    }

    DirectoryReader openReader() throws IOException {
        return this.indexAccessor.getIndexReader();
    }

    LuceneSerialWorkOrchestrator indexingOrchestrator() {
        return this.indexingOrchestrator;
    }

    LuceneParallelWorkOrchestrator managementOrchestrator() {
        return this.managementOrchestrator;
    }

    public IndexAccessorImpl indexAccessorForTests() {
        return this.indexAccessor;
    }
}

