/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.query.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.StoredFieldsCollector;
import org.hibernate.search.backend.lucene.search.aggregation.impl.AggregationExtractContext;
import org.hibernate.search.backend.lucene.search.aggregation.impl.LuceneSearchAggregation;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneCollectors;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneResult;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneLoadableSearchResult;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchQueryRequestContext;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.runtime.spi.FromDocumentValueConvertContextImpl;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.engine.search.query.SearchResultTotal;
import org.hibernate.search.engine.search.timeout.spi.TimeoutManager;

public class LuceneExtractableSearchResult<H> {
    private final LuceneSearchQueryRequestContext requestContext;
    private final FromDocumentValueConvertContext fromDocumentValueConvertContext;
    private final IndexSearcher indexSearcher;
    private final LuceneCollectors luceneCollectors;
    private final LuceneSearchProjection<?, H> rootProjection;
    private final Map<AggregationKey<?>, LuceneSearchAggregation<?>> aggregations;
    private final TimeoutManager timeoutManager;

    public LuceneExtractableSearchResult(LuceneSearchQueryRequestContext requestContext, IndexSearcher indexSearcher, LuceneCollectors luceneCollectors, LuceneSearchProjection<?, H> rootProjection, Map<AggregationKey<?>, LuceneSearchAggregation<?>> aggregations, TimeoutManager timeoutManager) {
        this.requestContext = requestContext;
        this.fromDocumentValueConvertContext = new FromDocumentValueConvertContextImpl(requestContext.getSessionContext());
        this.indexSearcher = indexSearcher;
        this.luceneCollectors = luceneCollectors;
        this.rootProjection = rootProjection;
        this.aggregations = aggregations;
        this.timeoutManager = timeoutManager;
    }

    public LuceneLoadableSearchResult<H> extract() throws IOException {
        return this.extract(0, Integer.MAX_VALUE);
    }

    public LuceneLoadableSearchResult<H> extract(int startInclusive, int endExclusive) throws IOException {
        TopDocs topDocs = this.luceneCollectors.getTopDocs();
        if (topDocs == null) {
            startInclusive = 0;
            endExclusive = 0;
        } else {
            ScoreDoc[] scoreDocs = topDocs.scoreDocs;
            startInclusive = Math.min(startInclusive, scoreDocs.length);
            endExclusive = Math.min(endExclusive, scoreDocs.length);
        }
        this.luceneCollectors.collectTopDocsData(startInclusive, endExclusive);
        ProjectionHitMapper projectionHitMapper = this.requestContext.getLoadingContext().createProjectionHitMapper();
        List<Object> extractedData = this.extractHits(projectionHitMapper, startInclusive, endExclusive);
        Map<Object, Object> extractedAggregations = this.aggregations.isEmpty() ? Collections.emptyMap() : this.extractAggregations();
        return new LuceneLoadableSearchResult<H>(this.fromDocumentValueConvertContext, this.rootProjection, this.luceneCollectors.getResultTotal(), this.luceneCollectors.getTopDocs(), extractedData, extractedAggregations, projectionHitMapper, this.timeoutManager.tookTime(), this.timeoutManager.isTimedOut(), this.timeoutManager);
    }

    public int hitSize() {
        TopDocs topDocs = this.luceneCollectors.getTopDocs();
        return topDocs == null ? 0 : topDocs.scoreDocs.length;
    }

    SearchResultTotal total() {
        return this.luceneCollectors.getResultTotal();
    }

    private List<Object> extractHits(ProjectionHitMapper<?, ?> projectionHitMapper, int startInclusive, int endExclusive) {
        TopDocs topDocs = this.luceneCollectors.getTopDocs();
        if (topDocs == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> extractedData = new ArrayList<Object>(topDocs.scoreDocs.length);
        SearchProjectionExtractContext projectionExtractContext = new SearchProjectionExtractContext(this.indexSearcher, this.requestContext.getLuceneQuery(), this.luceneCollectors.getCollectorsForTopDocs());
        StoredFieldsCollector storedFieldsCollector = projectionExtractContext.getCollector(StoredFieldsCollector.KEY);
        for (int i = startInclusive; !(i >= endExclusive || i % 16 == 0 && this.timeoutManager.checkTimedOut()); ++i) {
            ScoreDoc hit = topDocs.scoreDocs[i];
            Document document = storedFieldsCollector == null ? null : storedFieldsCollector.getDocument(hit.doc);
            LuceneResult luceneResult = new LuceneResult(document, hit.doc, hit.score);
            extractedData.add(this.rootProjection.extract(projectionHitMapper, luceneResult, projectionExtractContext));
        }
        return extractedData;
    }

    private Map<AggregationKey<?>, ?> extractAggregations() throws IOException {
        AggregationExtractContext aggregationExtractContext = new AggregationExtractContext(this.indexSearcher.getIndexReader(), this.requestContext.getLuceneQuery(), this.fromDocumentValueConvertContext, this.luceneCollectors.getCollectorsForAllMatchingDocs());
        LinkedHashMap extractedMap = new LinkedHashMap();
        for (Map.Entry<AggregationKey<?>, LuceneSearchAggregation<?>> entry : this.aggregations.entrySet()) {
            if (this.timeoutManager.checkTimedOut()) break;
            AggregationKey<?> key = entry.getKey();
            LuceneSearchAggregation<?> aggregation = entry.getValue();
            Object extracted = aggregation.extract(aggregationExtractContext);
            extractedMap.put(key, extracted);
        }
        return extractedMap;
    }
}

