/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.writer.impl;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.apache.lucene.index.LogMergePolicy;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.writer.impl.IndexWriterSettingValue;
import org.hibernate.search.backend.lucene.lowlevel.writer.impl.LoggerInfoStream;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public final class IndexWriterSettings
implements Serializable {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final List<Extractor<?, ?>> EXTRACTORS = new ArrayList();

    private IndexWriterSettings() {
    }

    public static List<IndexWriterSettingValue<?>> extractAll(ConfigurationPropertySource propertySource, EventContext eventContext) {
        ArrayList result = new ArrayList();
        for (Extractor<?, ?> extractor : EXTRACTORS) {
            IndexWriterSettingValue<?> extracted = extractor.extractOrNull(propertySource, eventContext);
            if (extracted == null) continue;
            result.add(extracted);
        }
        return result;
    }

    private static void registerIntegerWriterSetting(String propertyKey, BiConsumer<IndexWriterConfig, Integer> writerSettingApplier) {
        EXTRACTORS.add(Extractor.fromInteger(propertyKey, Function.identity(), writerSettingApplier, (logByteSizeMergePolicy, integer) -> {}));
    }

    private static void registerIntegerMergePolicySetting(String propertyKey, BiConsumer<LogByteSizeMergePolicy, Integer> mergePolicySettingApplier) {
        EXTRACTORS.add(Extractor.fromInteger(propertyKey, Function.identity(), (writer, integer) -> {}, mergePolicySettingApplier));
    }

    private static void registerBooleanMergePolicySetting(String propertyKey, BiConsumer<LogByteSizeMergePolicy, Boolean> mergePolicySettingApplier) {
        EXTRACTORS.add(Extractor.fromBoolean(propertyKey, Function.identity(), (writer, integer) -> {}, mergePolicySettingApplier));
    }

    private static void registerSetting(Extractor<?, ?> extractor) {
        EXTRACTORS.add(extractor);
    }

    static {
        IndexWriterSettings.registerIntegerWriterSetting("io.writer.max_buffered_docs", IndexWriterConfig::setMaxBufferedDocs);
        IndexWriterSettings.registerIntegerWriterSetting("io.writer.ram_buffer_size", IndexWriterConfig::setRAMBufferSizeMB);
        IndexWriterSettings.registerSetting(Extractor.fromBoolean("io.writer.infostream", enabled -> Boolean.TRUE.equals(enabled) ? new LoggerInfoStream() : null, IndexWriterConfig::setInfoStream, (logByteSizeMergePolicy, integer) -> {}));
        IndexWriterSettings.registerIntegerMergePolicySetting("io.merge.max_docs", LogMergePolicy::setMaxMergeDocs);
        IndexWriterSettings.registerIntegerMergePolicySetting("io.merge.factor", LogMergePolicy::setMergeFactor);
        IndexWriterSettings.registerIntegerMergePolicySetting("io.merge.min_size", LogByteSizeMergePolicy::setMinMergeMB);
        IndexWriterSettings.registerIntegerMergePolicySetting("io.merge.max_size", LogByteSizeMergePolicy::setMaxMergeMB);
        IndexWriterSettings.registerIntegerMergePolicySetting("io.merge.max_forced_size", LogByteSizeMergePolicy::setMaxMergeMBForForcedMerge);
        IndexWriterSettings.registerBooleanMergePolicySetting("io.merge.calibrate_by_deletes", LogMergePolicy::setCalibrateSizeByDeletes);
    }

    private static final class Extractor<T, R> {
        private final String settingName;
        private final OptionalConfigurationProperty<T> property;
        private final Function<T, R> processor;
        private final BiConsumer<IndexWriterConfig, R> writerSettingApplier;
        private final BiConsumer<LogByteSizeMergePolicy, R> mergePolicySettingApplier;

        static <T> Extractor fromInteger(String propertyKey, Function<Integer, T> processor, BiConsumer<IndexWriterConfig, T> writerSettingApplier, BiConsumer<LogByteSizeMergePolicy, T> mergePolicySettingApplier) {
            OptionalConfigurationProperty property = ConfigurationProperty.forKey((String)propertyKey).asInteger().build();
            return new Extractor<Integer, T>(propertyKey, property, processor, writerSettingApplier, mergePolicySettingApplier);
        }

        static <T> Extractor fromBoolean(String propertyKey, Function<Boolean, T> processor, BiConsumer<IndexWriterConfig, T> writerSettingApplier, BiConsumer<LogByteSizeMergePolicy, T> mergePolicySettingApplier) {
            OptionalConfigurationProperty property = ConfigurationProperty.forKey((String)propertyKey).asBoolean().build();
            return new Extractor<Boolean, T>(propertyKey, property, processor, writerSettingApplier, mergePolicySettingApplier);
        }

        private Extractor(String settingName, OptionalConfigurationProperty<T> property, Function<T, R> processor, BiConsumer<IndexWriterConfig, R> writerSettingApplier, BiConsumer<LogByteSizeMergePolicy, R> mergePolicySettingApplier) {
            this.settingName = settingName;
            this.property = property;
            this.processor = processor;
            this.writerSettingApplier = writerSettingApplier;
            this.mergePolicySettingApplier = mergePolicySettingApplier;
        }

        IndexWriterSettingValue<R> extractOrNull(ConfigurationPropertySource source, EventContext eventContext) {
            return this.property.getAndMap(source, rawValue -> this.createValueOrNull(rawValue, eventContext)).orElse(null);
        }

        private IndexWriterSettingValue<R> createValueOrNull(T value, EventContext eventContext) {
            if (value == null) {
                return null;
            }
            if (log.isDebugEnabled()) {
                log.debugf("Set index writer parameter %s to value : %s. %s", this.settingName, value, eventContext.renderWithPrefix());
            }
            R processedValue = this.processor.apply(value);
            return new IndexWriterSettingValue<R>(this.settingName, processedValue, this.writerSettingApplier, this.mergePolicySettingApplier);
        }
    }
}

