/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.query.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.common.impl.MetadataFields;
import org.hibernate.search.backend.lucene.lowlevel.query.impl.Queries;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneSyncWorkOrchestrator;
import org.hibernate.search.backend.lucene.search.aggregation.impl.AggregationRequestContext;
import org.hibernate.search.backend.lucene.search.aggregation.impl.LuceneSearchAggregation;
import org.hibernate.search.backend.lucene.search.extraction.impl.ExtractionRequirements;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchQueryElementCollector;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionRequestContext;
import org.hibernate.search.backend.lucene.search.query.LuceneSearchQuery;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchQueryImpl;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchQueryRequestContext;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearcherImpl;
import org.hibernate.search.backend.lucene.types.sort.comparatorsource.impl.LuceneFieldComparatorSource;
import org.hibernate.search.backend.lucene.work.impl.LuceneWorkFactory;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContext;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContextBuilder;
import org.hibernate.search.engine.search.query.spi.SearchQueryBuilder;
import org.hibernate.search.engine.search.timeout.spi.TimeoutManager;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneSearchQueryBuilder<H>
implements SearchQueryBuilder<H, LuceneSearchQueryElementCollector>,
LuceneSearchQueryElementCollector {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final LuceneWorkFactory workFactory;
    private final LuceneSyncWorkOrchestrator queryOrchestrator;
    private final LuceneSearchContext searchContext;
    private final BackendSessionContext sessionContext;
    private final Set<String> routingKeys;
    private final LoadingContextBuilder<?, ?, ?> loadingContextBuilder;
    private final LuceneSearchProjection<?, H> rootProjection;
    private List<LuceneFieldComparatorSource> nestedFieldSorts;
    private Query luceneQuery;
    private List<SortField> sortFields;
    private Map<AggregationKey<?>, LuceneSearchAggregation<?>> aggregations;
    private Long timeout;
    private TimeUnit timeUnit;
    private boolean exceptionOnTimeout;
    private Long totalHitCountThreshold;

    public LuceneSearchQueryBuilder(LuceneWorkFactory workFactory, LuceneSyncWorkOrchestrator queryOrchestrator, LuceneSearchContext searchContext, BackendSessionContext sessionContext, LoadingContextBuilder<?, ?, ?> loadingContextBuilder, LuceneSearchProjection<?, H> rootProjection) {
        this.workFactory = workFactory;
        this.queryOrchestrator = queryOrchestrator;
        this.searchContext = searchContext;
        this.sessionContext = sessionContext;
        this.routingKeys = new HashSet<String>();
        this.loadingContextBuilder = loadingContextBuilder;
        this.rootProjection = rootProjection;
    }

    public LuceneSearchQueryElementCollector toQueryElementCollector() {
        return this;
    }

    public void addRoutingKey(String routingKey) {
        this.routingKeys.add(routingKey);
    }

    public void truncateAfter(long timeout, TimeUnit timeUnit) {
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        this.exceptionOnTimeout = false;
    }

    public void failAfter(long timeout, TimeUnit timeUnit) {
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        this.exceptionOnTimeout = true;
    }

    public void totalHitCountThreshold(long totalHitCountThreshold) {
        this.totalHitCountThreshold = totalHitCountThreshold;
    }

    @Override
    public void collectPredicate(Query luceneQuery) {
        this.luceneQuery = luceneQuery;
    }

    @Override
    public void collectSortField(SortField sortField) {
        if (this.sortFields == null) {
            this.sortFields = new ArrayList<SortField>(5);
        }
        this.sortFields.add(sortField);
    }

    @Override
    public void collectSortField(SortField sortField, LuceneFieldComparatorSource nestedFieldSort) {
        this.collectSortField(sortField);
        if (nestedFieldSort == null) {
            return;
        }
        if (this.nestedFieldSorts == null) {
            this.nestedFieldSorts = new ArrayList<LuceneFieldComparatorSource>(5);
        }
        this.nestedFieldSorts.add(nestedFieldSort);
    }

    @Override
    public void collectSortFields(SortField[] sortFields) {
        if (sortFields == null || sortFields.length == 0) {
            return;
        }
        if (this.sortFields == null) {
            this.sortFields = new ArrayList<SortField>(sortFields.length);
        }
        Collections.addAll(this.sortFields, sortFields);
    }

    @Override
    public <A> void collectAggregation(AggregationKey<A> key, LuceneSearchAggregation<A> aggregation) {
        LuceneSearchAggregation<A> previous;
        if (this.aggregations == null) {
            this.aggregations = new LinkedHashMap();
        }
        if ((previous = this.aggregations.put(key, aggregation)) != null) {
            throw log.duplicateAggregationKey(key);
        }
    }

    public LuceneSearchQuery<H> build() {
        Query filter;
        LoadingContext loadingContext = this.loadingContextBuilder.build();
        BooleanQuery.Builder luceneQueryBuilder = new BooleanQuery.Builder();
        luceneQueryBuilder.add(this.luceneQuery, BooleanClause.Occur.MUST);
        if (this.searchContext.indexes().hasNestedDocuments()) {
            luceneQueryBuilder.add(Queries.mainDocumentQuery(), BooleanClause.Occur.FILTER);
        }
        if (!this.routingKeys.isEmpty()) {
            Query routingKeysQuery = Queries.anyTerm(MetadataFields.routingKeyFieldName(), this.routingKeys);
            luceneQueryBuilder.add(routingKeysQuery, BooleanClause.Occur.FILTER);
        }
        if ((filter = this.searchContext.filterOrNull(this.sessionContext.tenantIdentifier())) != null) {
            luceneQueryBuilder.add(filter, BooleanClause.Occur.FILTER);
        }
        BooleanQuery definitiveLuceneQuery = luceneQueryBuilder.build();
        Sort luceneSort = null;
        if (this.sortFields != null && !this.sortFields.isEmpty()) {
            luceneSort = new Sort(this.sortFields.toArray(new SortField[0]));
        }
        if (this.nestedFieldSorts != null) {
            for (LuceneFieldComparatorSource nestedField : this.nestedFieldSorts) {
                nestedField.setOriginalParentQuery((Query)definitiveLuceneQuery);
            }
        }
        LuceneSearchQueryRequestContext requestContext = new LuceneSearchQueryRequestContext(this.sessionContext, loadingContext, (Query)definitiveLuceneQuery, luceneSort);
        ExtractionRequirements.Builder extractionRequirementsBuilder = new ExtractionRequirements.Builder();
        SearchProjectionRequestContext projectionRequestContext = new SearchProjectionRequestContext(extractionRequirementsBuilder);
        this.rootProjection.request(projectionRequestContext);
        if (this.aggregations != null) {
            AggregationRequestContext aggregationRequestContext = new AggregationRequestContext(extractionRequirementsBuilder, (Query)definitiveLuceneQuery);
            for (LuceneSearchAggregation<?> aggregation : this.aggregations.values()) {
                aggregation.request(aggregationRequestContext);
            }
        }
        ExtractionRequirements extractionRequirements = extractionRequirementsBuilder.build();
        TimeoutManager timeoutManager = this.searchContext.createTimeoutManager(this.timeout, this.timeUnit, this.exceptionOnTimeout);
        LuceneSearcherImpl<H> searcher = new LuceneSearcherImpl<H>(requestContext, this.rootProjection, this.aggregations == null ? Collections.emptyMap() : this.aggregations, extractionRequirements, timeoutManager);
        return new LuceneSearchQueryImpl(this.queryOrchestrator, this.workFactory, this.searchContext, this.sessionContext, loadingContext, this.routingKeys, timeoutManager, (Query)definitiveLuceneQuery, luceneSort, searcher, this.totalHitCountThreshold);
    }
}

