/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.junit;

import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.spi.PersistenceUnitInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.hibernate.cfg.Environment;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.jpa.boot.internal.PersistenceUnitInfoDescriptor;
import org.hibernate.jpa.boot.spi.Bootstrap;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.hibernate.testing.jdbc.SQLStatementInspector;
import org.hibernate.testing.orm.domain.DomainModelDescriptor;
import org.hibernate.testing.orm.domain.StandardDomainModel;
import org.hibernate.testing.orm.jpa.PersistenceUnitInfoImpl;
import org.hibernate.testing.orm.junit.AbstractEntityManagerFactoryScope;
import org.hibernate.testing.orm.junit.EntityManagerFactoryScope;
import org.hibernate.testing.orm.junit.JUnitHelper;
import org.hibernate.testing.orm.junit.Jpa;
import org.hibernate.testing.orm.junit.Setting;
import org.hibernate.testing.orm.junit.SettingProvider;
import org.hibernate.testing.util.ServiceRegistryUtil;
import org.hibernate.tool.schema.Action;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.junit.platform.commons.support.AnnotationSupport;

public class EntityManagerFactoryExtension
implements TestInstancePostProcessor,
BeforeEachCallback,
TestExecutionExceptionHandler {
    private static final Logger log = Logger.getLogger(EntityManagerFactoryExtension.class);
    private static final String EMF_KEY = EntityManagerFactoryScope.class.getName();

    private static ExtensionContext.Store locateExtensionStore(Object testScope, ExtensionContext context) {
        return JUnitHelper.locateExtensionStore(EntityManagerFactoryExtension.class, context, testScope);
    }

    public static EntityManagerFactoryScope findEntityManagerFactoryScope(Object testScope, Optional<Jpa> optionalJpa, ExtensionContext context) {
        if (optionalJpa.isEmpty()) {
            return null;
        }
        ExtensionContext.Store store = EntityManagerFactoryExtension.locateExtensionStore(testScope, context);
        EntityManagerFactoryScope existing = (EntityManagerFactoryScope)store.get((Object)EMF_KEY);
        if (existing != null) {
            return existing;
        }
        if (context.getElement().isEmpty()) {
            throw new RuntimeException("Unable to determine how to handle given ExtensionContext : " + context.getDisplayName());
        }
        Jpa jpa = optionalJpa.get();
        PersistenceUnitInfoImpl pui = EntityManagerFactoryExtension.createPersistenceUnitInfo(jpa);
        EntityManagerFactoryExtension.collectProperties(pui, jpa);
        EntityManagerFactoryExtension.managedClassesAndMappings(jpa, pui);
        Map<String, Object> integrationSettings = EntityManagerFactoryExtension.collectIntegrationSettings(jpa);
        EntityManagerFactoryExtension.setupStatementInspector(jpa, integrationSettings);
        ServiceRegistryUtil.applySettings(integrationSettings);
        EntityManagerFactoryScopeImpl scope = new EntityManagerFactoryScopeImpl(pui, integrationSettings);
        store.put((Object)EMF_KEY, (Object)scope);
        return scope;
    }

    private static void collectProperties(PersistenceUnitInfoImpl pui, Jpa jpa) {
        Properties properties = pui.getProperties();
        properties.putAll((Map<?, ?>)Environment.getProperties());
        EntityManagerFactoryExtension.setJpaComplianceProperties(properties, jpa);
        for (Setting property : jpa.properties()) {
            properties.setProperty(property.name(), property.value());
        }
        properties.setProperty("hibernate.generate_statistics", Boolean.toString(jpa.generateStatistics()));
        if (jpa.exportSchema()) {
            properties.setProperty("jakarta.persistence.schema-generation.database.action", Action.CREATE_DROP.getExternalHbm2ddlName());
        }
    }

    private static PersistenceUnitInfoImpl createPersistenceUnitInfo(Jpa jpa) {
        PersistenceUnitInfoImpl pui = new PersistenceUnitInfoImpl(jpa.persistenceUnitName());
        pui.setTransactionType(jpa.transactionType());
        pui.setCacheMode(jpa.sharedCacheMode());
        pui.setValidationMode(jpa.validationMode());
        pui.setExcludeUnlistedClasses(jpa.excludeUnlistedClasses());
        return pui;
    }

    /*
     * WARNING - void declaration
     */
    private static void managedClassesAndMappings(Jpa jpa, PersistenceUnitInfoImpl pui) {
        if (jpa.annotatedPackageNames().length > 0) {
            pui.applyManagedClassNames(jpa.annotatedPackageNames());
        }
        if (jpa.annotatedClassNames().length > 0) {
            pui.applyManagedClassNames(jpa.annotatedClassNames());
        }
        if (jpa.annotatedClasses().length > 0) {
            void var2_3;
            boolean bl = false;
            while (var2_3 < jpa.annotatedClasses().length) {
                pui.applyManagedClassNames(jpa.annotatedClasses()[var2_3].getName());
                ++var2_3;
            }
        }
        if (jpa.xmlMappings().length > 0) {
            pui.applyMappingFiles(jpa.xmlMappings());
        }
        for (StandardDomainModel standardDomainModel : jpa.standardModels()) {
            for (Class annotatedClass : standardDomainModel.getDescriptor().getAnnotatedClasses()) {
                pui.applyManagedClassNames(annotatedClass.getName());
            }
        }
        for (Class<? extends DomainModelDescriptor> clazz : jpa.modelDescriptorClasses()) {
            Class[] annotatedClasses;
            DomainModelDescriptor domainModelDescriptor = EntityManagerFactoryExtension.instantiateDomainModelDescriptor(clazz);
            for (Class annotatedClass : annotatedClasses = domainModelDescriptor.getAnnotatedClasses()) {
                pui.applyManagedClassNames(annotatedClass.getName());
            }
        }
    }

    private static Map<String, Object> collectIntegrationSettings(Jpa jpa) {
        HashMap<String, Object> integrationSettings = new HashMap<String, Object>();
        integrationSettings.put("hibernate.query.mutation_strategy.persistent.drop_tables", "true");
        integrationSettings.put("hibernate.query.mutation_strategy.global_temporary.drop_tables", "true");
        integrationSettings.put("hibernate.query.mutation_strategy.local_temporary.drop_tables", "true");
        Setting[] settings = jpa.integrationSettings();
        for (Setting setting : settings) {
            integrationSettings.put(setting.name(), setting.value());
        }
        for (Annotation annotation : jpa.settingProviders()) {
            Class<SettingProvider.Provider<?>> providerImpl = annotation.provider();
            try {
                integrationSettings.put(annotation.settingName(), providerImpl.getConstructor(new Class[0]).newInstance(new Object[0]).getSetting());
            }
            catch (Exception e) {
                log.error((Object)("Error obtaining setting provider for " + providerImpl.getName()), (Throwable)e);
            }
        }
        return integrationSettings;
    }

    private static void setupStatementInspector(Jpa jpa, Map<String, Object> integrationSettings) {
        if (jpa.useCollectingStatementInspector()) {
            String inspectorSetting = (String)integrationSettings.get("hibernate.session_factory.statement_inspector");
            if (inspectorSetting != null && !inspectorSetting.isBlank()) {
                log.warn((Object)String.format("Overriding the explicit \"%1s\" statement inspector setting", inspectorSetting));
            }
            integrationSettings.put("hibernate.session_factory.statement_inspector", new SQLStatementInspector());
        }
    }

    private static void setJpaComplianceProperties(Properties properties, Jpa jpa) {
        properties.put("hibernate.jpa.compliance", (Object)jpa.jpaComplianceEnabled());
        properties.put("hibernate.jpa.compliance.query", (Object)jpa.queryComplianceEnabled());
        properties.put("hibernate.jpa.compliance.transaction", (Object)jpa.transactionComplianceEnabled());
        properties.put("hibernate.jpa.compliance.closed", (Object)jpa.closedComplianceEnabled());
        properties.put("hibernate.jpa.compliance.proxy", (Object)jpa.proxyComplianceEnabled());
        properties.put("hibernate.jpa.compliance.caching", (Object)jpa.cacheComplianceEnabled());
        properties.put("hibernate.jpa.compliance.global_id_generators", (Object)jpa.generatorScopeComplianceEnabled());
        properties.put("hibernate.jpa.compliance.orderby", (Object)jpa.orderByMappingComplianceEnabled());
        properties.put("hibernate.jpa.compliance.load_by_id", (Object)jpa.loadByIdComplianceEnabled());
    }

    private static DomainModelDescriptor instantiateDomainModelDescriptor(Class<? extends DomainModelDescriptor> modelDescriptorClass) {
        try {
            for (Field field : modelDescriptorClass.getDeclaredFields()) {
                Object value;
                if (!ReflectHelper.isStaticField((Field)field) || !((value = field.get(null)) instanceof DomainModelDescriptor)) continue;
                DomainModelDescriptor descriptor = (DomainModelDescriptor)value;
                return descriptor;
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Problem accessing DomainModelDescriptor fields : " + modelDescriptorClass.getName(), e);
        }
        try {
            return modelDescriptorClass.getConstructor(null).newInstance(null);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Problem instantiation DomainModelDescriptor : " + modelDescriptorClass.getName(), e);
        }
    }

    public void beforeEach(ExtensionContext context) {
        log.tracef("#beforeEach(%s)", (Object)context.getDisplayName());
        Optional optionalJpa = AnnotationSupport.findAnnotation((AnnotatedElement)context.getRequiredTestMethod(), Jpa.class);
        if (optionalJpa.isPresent()) {
            EntityManagerFactoryExtension.findEntityManagerFactoryScope(context.getRequiredTestMethod(), optionalJpa, context);
        }
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) {
        log.tracef("#postProcessTestInstance(%s, %s)", testInstance, (Object)context.getDisplayName());
        Optional optionalJpa = AnnotationSupport.findAnnotation((AnnotatedElement)context.getRequiredTestClass(), Jpa.class);
        EntityManagerFactoryExtension.findEntityManagerFactoryScope(testInstance, optionalJpa, context);
    }

    public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        log.tracef("#handleTestExecutionException(%s, %s)", (Object)context.getDisplayName(), (Object)throwable);
        try {
            ExtensionContext.Store store = EntityManagerFactoryExtension.locateExtensionStore(context.getRequiredTestInstance(), context);
            EntityManagerFactoryScopeImpl scope = (EntityManagerFactoryScopeImpl)store.get((Object)EMF_KEY);
            scope.releaseEntityManagerFactory();
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw throwable;
    }

    private static class EntityManagerFactoryScopeImpl
    extends AbstractEntityManagerFactoryScope {
        private final PersistenceUnitInfo persistenceUnitInfo;
        private final Map<String, Object> integrationSettings;

        private EntityManagerFactoryScopeImpl(PersistenceUnitInfo persistenceUnitInfo, Map<String, Object> integrationSettings) {
            this.persistenceUnitInfo = persistenceUnitInfo;
            this.integrationSettings = integrationSettings;
        }

        @Override
        protected EntityManagerFactory createEntityManagerFactory() {
            PersistenceUnitInfoDescriptor descriptor = new PersistenceUnitInfoDescriptor(this.persistenceUnitInfo);
            return Bootstrap.getEntityManagerFactoryBuilder((PersistenceUnitDescriptor)descriptor, this.integrationSettings).build();
        }
    }
}

