/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.connections.internal.ConnectionProviderInitiator;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.DatabaseConnectionInfo;
import org.hibernate.engine.jdbc.env.spi.ExtractedDatabaseMetaData;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.Stoppable;

public class ConnectionProviderDelegate
implements ConnectionProvider,
Configurable,
ServiceRegistryAwareService,
Stoppable {
    private ServiceRegistryImplementor serviceRegistry;
    private ConnectionProvider connectionProvider;
    private boolean configured;
    private final boolean forceSupportsAggressiveRelease;

    public ConnectionProviderDelegate() {
        this(false);
    }

    public ConnectionProviderDelegate(boolean forceSupportsAggressiveRelease) {
        this.forceSupportsAggressiveRelease = forceSupportsAggressiveRelease;
    }

    public ConnectionProviderDelegate(ConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
        this.forceSupportsAggressiveRelease = false;
    }

    public ConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }

    public void setConnectionProvider(ConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void configure(Map<String, Object> configurationValues) {
        if (!this.configured) {
            if (this.connectionProvider == null) {
                HashMap<String, Object> settings = new HashMap<String, Object>(configurationValues);
                settings.remove("hibernate.connection.provider_class");
                this.connectionProvider = ConnectionProviderInitiator.INSTANCE.initiateService(settings, this.serviceRegistry);
            }
            if (this.connectionProvider instanceof ServiceRegistryAwareService) {
                ((ServiceRegistryAwareService)this.connectionProvider).injectServices(this.serviceRegistry);
            }
            if (this.connectionProvider instanceof Configurable) {
                Configurable configurableConnectionProvider = (Configurable)this.connectionProvider;
                configurableConnectionProvider.configure(configurationValues);
            }
            this.configured = true;
        }
    }

    public Connection getConnection() throws SQLException {
        return this.connectionProvider.getConnection();
    }

    public void closeConnection(Connection connection) throws SQLException {
        this.connectionProvider.closeConnection(connection);
    }

    public boolean supportsAggressiveRelease() {
        if (this.forceSupportsAggressiveRelease) {
            return true;
        }
        return this.connectionProvider.supportsAggressiveRelease();
    }

    public DatabaseConnectionInfo getDatabaseConnectionInfo(Dialect dialect) {
        return this.connectionProvider.getDatabaseConnectionInfo(dialect);
    }

    public DatabaseConnectionInfo getDatabaseConnectionInfo(Dialect dialect, ExtractedDatabaseMetaData metaData) {
        return this.connectionProvider.getDatabaseConnectionInfo(dialect, metaData);
    }

    public boolean isUnwrappableAs(Class<?> unwrapType) {
        return this.connectionProvider.isUnwrappableAs(unwrapType);
    }

    public <T> T unwrap(Class<T> unwrapType) {
        return (T)this.connectionProvider.unwrap(unwrapType);
    }

    public void stop() {
        if (this.connectionProvider instanceof Stoppable) {
            ((Stoppable)this.connectionProvider).stop();
        }
    }
}

