/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.junit;

import jakarta.persistence.EntityManagerFactory;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Optional;
import org.hibernate.testing.orm.junit.EntityManagerFactoryExtension;
import org.hibernate.testing.orm.junit.EntityManagerFactoryScope;
import org.hibernate.testing.orm.junit.JUnitHelper;
import org.hibernate.testing.orm.junit.Jpa;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.support.AnnotationSupport;

public class EntityManagerFactoryParameterResolver
implements ParameterResolver {
    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return JUnitHelper.supportsParameterInjection(parameterContext, EntityManagerFactory.class, EntityManagerFactoryScope.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Optional testEmfAnnWrapper;
        Optional emfAnnWrapper = AnnotationSupport.findAnnotation((AnnotatedElement)extensionContext.getRequiredTestClass(), Jpa.class);
        Object testScope = extensionContext.getRequiredTestInstance();
        if (parameterContext.getDeclaringExecutable() instanceof Method && !extensionContext.getTestMethod().isEmpty() && !(testEmfAnnWrapper = AnnotationSupport.findAnnotation((AnnotatedElement)extensionContext.getRequiredTestMethod(), Jpa.class)).isEmpty()) {
            testScope = extensionContext.getRequiredTestMethod();
            emfAnnWrapper = testEmfAnnWrapper;
        }
        EntityManagerFactoryScope scope = EntityManagerFactoryExtension.findEntityManagerFactoryScope(testScope, emfAnnWrapper, extensionContext);
        if (EntityManagerFactoryScope.class.isAssignableFrom(parameterContext.getParameter().getType())) {
            return scope;
        }
        assert (EntityManagerFactory.class.isAssignableFrom(parameterContext.getParameter().getType()));
        return scope.getEntityManagerFactory();
    }
}

