/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.jdbc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class JdbcSpies {
    public static Connection spy(Connection connection, SpyContext context) {
        return (Connection)Proxy.newProxyInstance(ClassLoader.getSystemClassLoader(), new Class[]{Connection.class}, (InvocationHandler)new ConnectionHandler(connection, context));
    }

    private static class SavepointHandler
    implements InvocationHandler,
    Spy {
        private final Savepoint savepoint;
        private final SpyContext context;

        public SavepointHandler(Savepoint savepoint, SpyContext context) {
            this.savepoint = savepoint;
            this.context = context;
        }

        @Override
        public Object getSpiedInstance() {
            return this.savepoint;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            switch (method.getName()) {
                case "toString": {
                    return this.context.onCall(proxy, method, args, "Savepoint proxy [@" + this.hashCode() + "]");
                }
                case "hashCode": {
                    return this.context.onCall(proxy, method, args, this.hashCode());
                }
                case "equals": {
                    return this.context.onCall(proxy, method, args, proxy == args[0]);
                }
            }
            return this.context.call(proxy, this.savepoint, method, args);
        }
    }

    private static class ResultSetMetaDataHandler
    implements InvocationHandler,
    Spy {
        private final ResultSetMetaData resultSetMetaData;
        private final SpyContext context;

        public ResultSetMetaDataHandler(ResultSetMetaData resultSetMetaData, SpyContext context) {
            this.resultSetMetaData = resultSetMetaData;
            this.context = context;
        }

        @Override
        public Object getSpiedInstance() {
            return this.resultSetMetaData;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            switch (method.getName()) {
                case "toString": {
                    return this.context.onCall(proxy, method, args, "ResultSetMetaData proxy [@" + this.hashCode() + "]");
                }
                case "hashCode": {
                    return this.context.onCall(proxy, method, args, this.hashCode());
                }
                case "equals": {
                    return this.context.onCall(proxy, method, args, proxy == args[0]);
                }
            }
            return this.context.call(proxy, this.resultSetMetaData, method, args);
        }
    }

    private static class ResultSetHandler
    implements InvocationHandler,
    Spy {
        private final ResultSet resultSet;
        private final SpyContext context;
        private final Statement statementProxy;
        private ResultSetMetaData metadataProxy;

        public ResultSetHandler(ResultSet resultSet, SpyContext context, Statement statementProxy) {
            this.resultSet = resultSet;
            this.context = context;
            this.statementProxy = statementProxy;
        }

        @Override
        public Object getSpiedInstance() {
            return this.resultSet;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName;
            switch (methodName = method.getName()) {
                case "getMetaData": {
                    return this.context.onCall(proxy, method, args, this.getResultSetMetaDataProxy(this.resultSet.getMetaData()));
                }
                case "getStatement": {
                    return this.context.onCall(proxy, method, args, this.statementProxy);
                }
                case "toString": {
                    return this.context.onCall(proxy, method, args, "ResultSet proxy [@" + this.hashCode() + "]");
                }
                case "hashCode": {
                    return this.context.onCall(proxy, method, args, this.hashCode());
                }
                case "equals": {
                    return this.context.onCall(proxy, method, args, proxy == args[0]);
                }
            }
            return this.context.call(proxy, this.resultSet, method, args);
        }

        private ResultSetMetaData getResultSetMetaDataProxy(ResultSetMetaData metaData) throws Throwable {
            if (this.metadataProxy == null) {
                ResultSetMetaDataHandler metadataHandler = new ResultSetMetaDataHandler(metaData, this.context);
                this.metadataProxy = (ResultSetMetaData)Proxy.newProxyInstance(ClassLoader.getSystemClassLoader(), new Class[]{ResultSetMetaData.class}, (InvocationHandler)metadataHandler);
            }
            return this.metadataProxy;
        }
    }

    private static class ParameterMetaDataHandler
    implements InvocationHandler,
    Spy {
        private final ParameterMetaData parameterMetaData;
        private final SpyContext context;

        public ParameterMetaDataHandler(ParameterMetaData parameterMetaData, SpyContext context) {
            this.parameterMetaData = parameterMetaData;
            this.context = context;
        }

        @Override
        public Object getSpiedInstance() {
            return this.parameterMetaData;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            switch (method.getName()) {
                case "toString": {
                    return this.context.onCall(proxy, method, args, "DatabaseMetaData proxy [@" + this.hashCode() + "]");
                }
                case "hashCode": {
                    return this.context.onCall(proxy, method, args, this.hashCode());
                }
                case "equals": {
                    return this.context.onCall(proxy, method, args, proxy == args[0]);
                }
            }
            return this.context.call(proxy, this.parameterMetaData, method, args);
        }
    }

    private static class DatabaseMetaDataHandler
    implements InvocationHandler,
    Spy {
        private final DatabaseMetaData databaseMetaData;
        private final Connection connectionProxy;
        private final SpyContext context;

        public DatabaseMetaDataHandler(DatabaseMetaData databaseMetaData, Connection connectionProxy, SpyContext context) {
            this.databaseMetaData = databaseMetaData;
            this.connectionProxy = connectionProxy;
            this.context = context;
        }

        @Override
        public Object getSpiedInstance() {
            return this.databaseMetaData;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            switch (method.getName()) {
                case "getConnection": {
                    return this.context.onCall(proxy, method, args, this.connectionProxy);
                }
                case "toString": {
                    return this.context.onCall(proxy, method, args, "DatabaseMetaData proxy [@" + this.hashCode() + "]");
                }
                case "hashCode": {
                    return this.context.onCall(proxy, method, args, this.hashCode());
                }
                case "equals": {
                    return this.context.onCall(proxy, method, args, proxy == args[0]);
                }
                case "getProcedures": 
                case "getProcedureColumns": 
                case "getTables": 
                case "getSchemas": 
                case "getCatalogs": 
                case "getTableTypes": 
                case "getColumns": 
                case "getColumnPrivileges": 
                case "getTablePrivileges": 
                case "getBestRowIdentifier": 
                case "getVersionColumns": 
                case "getPrimaryKeys": 
                case "getImportedKeys": 
                case "getExportedKeys": 
                case "getCrossReference": 
                case "getTypeInfo": 
                case "getIndexInfo": 
                case "getUDTs": 
                case "getSuperTypes": 
                case "getSuperTables": 
                case "getAttributes": 
                case "getClientInfoProperties": 
                case "getFunctions": 
                case "getFunctionColumns": 
                case "getPseudoColumns": {
                    ResultSet resultSet = (ResultSet)this.context.callOnly(this.databaseMetaData, method, args);
                    return this.context.onCall(proxy, method, args, this.getResultSetProxy(resultSet, this.getStatementProxy(resultSet.getStatement())));
                }
            }
            return this.context.call(proxy, this.databaseMetaData, method, args);
        }

        protected ResultSet getResultSetProxy(ResultSet resultSet, Statement statementProxy) throws Throwable {
            return (ResultSet)Proxy.newProxyInstance(ClassLoader.getSystemClassLoader(), new Class[]{ResultSet.class}, (InvocationHandler)new ResultSetHandler(resultSet, this.context, statementProxy));
        }

        protected Statement getStatementProxy(Statement statement) throws Throwable {
            StatementHandler handler = statement instanceof CallableStatement ? new CallableStatementHandler((CallableStatement)statement, this.context, this.connectionProxy) : (statement instanceof PreparedStatement ? new PreparedStatementHandler((PreparedStatement)statement, this.context, this.connectionProxy) : new StatementHandler(statement, this.context, this.connectionProxy));
            return (Statement)Proxy.newProxyInstance(ClassLoader.getSystemClassLoader(), new Class[]{Statement.class}, (InvocationHandler)handler);
        }
    }

    private static class CallableStatementHandler
    extends PreparedStatementHandler {
        public CallableStatementHandler(CallableStatement statement, SpyContext context, Connection connectionProxy) {
            super(statement, context, connectionProxy);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("toString".equals(method.getName())) {
                return this.context.onCall(proxy, method, args, "CallableStatement proxy [@" + this.hashCode() + "]");
            }
            return super.invoke(proxy, method, args);
        }
    }

    private static class PreparedStatementHandler
    extends StatementHandler {
        private ResultSetMetaData resultSetMetaDataProxy;
        private ParameterMetaData parameterMetaDataProxy;

        public PreparedStatementHandler(PreparedStatement statement, SpyContext context, Connection connectionProxy) {
            super(statement, context, connectionProxy);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            switch (method.getName()) {
                case "toString": {
                    return this.context.onCall(proxy, method, args, "PreparedStatement proxy [@" + this.hashCode() + "]");
                }
                case "executeQuery": {
                    return this.context.onCall(proxy, method, args, this.getResultSetProxy((ResultSet)this.context.callOnly(this.statement, method, args), (PreparedStatement)proxy));
                }
                case "getMetaData": {
                    return this.context.onCall(proxy, method, args, this.getResultSetMetaDataProxy(((PreparedStatement)this.statement).getMetaData()));
                }
                case "getParameterMetaData": {
                    return this.context.onCall(proxy, method, args, this.getParameterMetaDataProxy(((PreparedStatement)this.statement).getParameterMetaData()));
                }
            }
            return super.invoke(proxy, method, args);
        }

        private ResultSetMetaData getResultSetMetaDataProxy(ResultSetMetaData metaData) throws Throwable {
            if (this.resultSetMetaDataProxy == null) {
                this.resultSetMetaDataProxy = (ResultSetMetaData)Proxy.newProxyInstance(ClassLoader.getSystemClassLoader(), new Class[]{ResultSetMetaData.class}, (InvocationHandler)new ResultSetMetaDataHandler(metaData, this.context));
            }
            return this.resultSetMetaDataProxy;
        }

        private ParameterMetaData getParameterMetaDataProxy(ParameterMetaData metaData) throws Throwable {
            if (this.parameterMetaDataProxy == null) {
                this.parameterMetaDataProxy = (ParameterMetaData)Proxy.newProxyInstance(ClassLoader.getSystemClassLoader(), new Class[]{ParameterMetaData.class}, (InvocationHandler)new ParameterMetaDataHandler(metaData, this.context));
            }
            return this.parameterMetaDataProxy;
        }
    }

    private static class StatementHandler
    implements InvocationHandler,
    Spy {
        protected final Statement statement;
        protected final SpyContext context;
        protected final Connection connectionProxy;

        public StatementHandler(Statement statement, SpyContext context, Connection connectionProxy) {
            this.statement = statement;
            this.context = context;
            this.connectionProxy = connectionProxy;
        }

        @Override
        public Object getSpiedInstance() {
            return this.statement;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            switch (method.getName()) {
                case "getConnection": {
                    return this.context.onCall(proxy, method, args, this.connectionProxy);
                }
                case "toString": {
                    return this.context.onCall(proxy, method, args, "Statement proxy [@" + this.hashCode() + "]");
                }
                case "hashCode": {
                    return this.context.onCall(proxy, method, args, this.hashCode());
                }
                case "equals": {
                    return this.context.onCall(proxy, method, args, proxy == args[0]);
                }
                case "executeQuery": {
                    return this.context.onCall(proxy, method, args, this.getResultSetProxy(this.statement.executeQuery((String)args[0]), (Statement)proxy));
                }
                case "getResultSet": {
                    return this.context.onCall(proxy, method, args, this.getResultSetProxy(this.statement.getResultSet(), (Statement)proxy));
                }
                case "getGeneratedKeys": {
                    return this.context.onCall(proxy, method, args, this.getResultSetProxy(this.statement.getGeneratedKeys(), (Statement)proxy));
                }
            }
            return this.context.call(proxy, this.statement, method, args);
        }

        protected ResultSet getResultSetProxy(ResultSet resultSet, Statement statementProxy) throws Throwable {
            return (ResultSet)Proxy.newProxyInstance(ClassLoader.getSystemClassLoader(), new Class[]{ResultSet.class}, (InvocationHandler)new ResultSetHandler(resultSet, this.context, statementProxy));
        }
    }

    private static class ConnectionHandler
    implements InvocationHandler,
    Spy {
        private final Connection connection;
        private final SpyContext context;
        private DatabaseMetaData databaseMetaDataProxy;

        public ConnectionHandler(Connection connection, SpyContext context) {
            this.connection = connection;
            this.context = context;
        }

        @Override
        public Object getSpiedInstance() {
            return this.connection;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            switch (method.getName()) {
                case "getMetaData": {
                    return this.context.onCall(proxy, method, args, this.getDatabaseMetaDataProxy((Connection)proxy));
                }
                case "createStatement": {
                    return this.context.onCall(proxy, method, args, this.createStatementProxy((Statement)this.context.callOnly(this.connection, method, args), (Connection)proxy));
                }
                case "prepareStatement": {
                    return this.context.onCall(proxy, method, args, this.prepareStatementProxy((PreparedStatement)this.context.callOnly(this.connection, method, args), (Connection)proxy));
                }
                case "prepareCall": {
                    return this.context.onCall(proxy, method, args, this.prepareCallProxy((CallableStatement)this.context.callOnly(this.connection, method, args), (Connection)proxy));
                }
                case "toString": {
                    return this.context.onCall(proxy, method, args, "Connection proxy [@" + this.hashCode() + "]");
                }
                case "hashCode": {
                    return this.context.onCall(proxy, method, args, this.hashCode());
                }
                case "equals": {
                    return this.context.onCall(proxy, method, args, proxy == args[0]);
                }
                case "setSavepoint": {
                    return this.savepointProxy((Savepoint)this.context.call(proxy, this.connection, method, args));
                }
                case "releaseSavepoint": {
                    if (Proxy.isProxyClass(args[0].getClass())) {
                        args[0] = ((SavepointHandler)Proxy.getInvocationHandler((Object)args[0])).savepoint;
                    }
                    return this.context.call(proxy, this.connection, method, args);
                }
                case "rollback": {
                    if (args != null && args.length != 0 && Proxy.isProxyClass(args[0].getClass())) {
                        args[0] = ((SavepointHandler)Proxy.getInvocationHandler((Object)args[0])).savepoint;
                    }
                    return this.context.call(proxy, this.connection, method, args);
                }
            }
            return this.context.call(proxy, this.connection, method, args);
        }

        private DatabaseMetaData getDatabaseMetaDataProxy(Connection connectionProxy) throws Throwable {
            if (this.databaseMetaDataProxy == null) {
                DatabaseMetaDataHandler metadataHandler = new DatabaseMetaDataHandler(this.connection.getMetaData(), connectionProxy, this.context);
                this.databaseMetaDataProxy = (DatabaseMetaData)Proxy.newProxyInstance(ClassLoader.getSystemClassLoader(), new Class[]{DatabaseMetaData.class}, (InvocationHandler)metadataHandler);
            }
            return this.databaseMetaDataProxy;
        }

        private Statement createStatementProxy(Statement statement, Connection connectionProxy) {
            return (Statement)Proxy.newProxyInstance(ClassLoader.getSystemClassLoader(), new Class[]{Statement.class}, (InvocationHandler)new StatementHandler(statement, this.context, connectionProxy));
        }

        private PreparedStatement prepareStatementProxy(PreparedStatement statement, Connection connectionProxy) {
            return (PreparedStatement)Proxy.newProxyInstance(ClassLoader.getSystemClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)new PreparedStatementHandler(statement, this.context, connectionProxy));
        }

        private CallableStatement prepareCallProxy(CallableStatement statement, Connection connectionProxy) {
            return (CallableStatement)Proxy.newProxyInstance(ClassLoader.getSystemClassLoader(), new Class[]{CallableStatement.class}, (InvocationHandler)new CallableStatementHandler(statement, this.context, connectionProxy));
        }

        private Savepoint savepointProxy(Savepoint savepoint) {
            return (Savepoint)Proxy.newProxyInstance(ClassLoader.getSystemClassLoader(), new Class[]{Savepoint.class}, (InvocationHandler)new SavepointHandler(savepoint, this.context));
        }
    }

    private static interface Spy {
        public Object getSpiedInstance();
    }

    public static class SpyContext {
        private final Map<Method, Map<Object, List<Object[]>>> calls = new HashMap<Method, Map<Object, List<Object[]>>>();
        private final List<Callback> callbacks = new ArrayList<Callback>();

        private Object call(Object spy, Object realObject, Method method, Object[] args) throws Throwable {
            return this.onCall(spy, method, args, this.callOnly(realObject, method, args));
        }

        private Object callOnly(Object realObject, Method method, Object[] args) throws Throwable {
            try {
                return method.invoke(realObject, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }

        private <T> T onCall(Object spy, Method method, Object[] args, T result) {
            this.calls.computeIfAbsent(method, m -> new IdentityHashMap()).computeIfAbsent(spy, s -> new ArrayList()).add(args);
            for (Callback callback : this.callbacks) {
                callback.onCall(spy, method, args, result);
            }
            return result;
        }

        public SpyContext registerCallback(Callback callback) {
            this.callbacks.add(callback);
            return this;
        }

        public List<Object[]> getCalls(Method method, Object spy) {
            return this.calls.getOrDefault(method, Collections.emptyMap()).getOrDefault(spy, Collections.emptyList());
        }

        public void clear() {
            this.calls.clear();
        }

        public <T> T getSpiedInstance(T spy) {
            InvocationHandler invocationHandler;
            if (Proxy.isProxyClass(spy.getClass()) && (invocationHandler = Proxy.getInvocationHandler(spy)) instanceof Spy) {
                return (T)((Spy)((Object)invocationHandler)).getSpiedInstance();
            }
            throw new IllegalArgumentException("Passed object is not a spy: " + spy);
        }
    }

    public static interface Callback {
        public void onCall(Object var1, Method var2, Object[] var3, Object var4);
    }
}

