/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.cleaner;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.testing.cleaner.DatabaseCleaner;

public class OracleDatabaseCleaner
implements DatabaseCleaner {
    private static final Logger LOG = Logger.getLogger(OracleDatabaseCleaner.class.getName());
    private static final String SYSTEM_SEQUENCE_OWNERS = "'SYS','CTXSYS','DVSYS','OJVMSYS','ORDDATA','MDSYS','OLAPSYS','LBACSYS','XDB','WMSYS'";
    private final List<String> ignoredTables = new ArrayList<String>();
    private final Map<String, List<String>> cachedTruncateTableSqlPerSchema = new HashMap<String, List<String>>();
    private final Map<String, List<String>> cachedConstraintDisableSqlPerSchema = new HashMap<String, List<String>>();
    private final Map<String, List<String>> cachedConstraintEnableSqlPerSchema = new HashMap<String, List<String>>();

    @Override
    public boolean isApplicable(Connection connection) {
        try {
            return connection.getMetaData().getDatabaseProductName().startsWith("Oracle");
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not resolve the database metadata!", e);
        }
    }

    @Override
    public void addIgnoredTable(String tableName) {
        this.ignoredTables.add(tableName);
    }

    @Override
    public void clearAllSchemas(Connection connection) {
        this.cachedTruncateTableSqlPerSchema.clear();
        this.cachedConstraintDisableSqlPerSchema.clear();
        this.cachedConstraintEnableSqlPerSchema.clear();
        this.clearSchema0(connection, statement -> {
            try {
                return statement.executeQuery("SELECT 'DROP TABLE ' || owner || '.\"' || table_name || '\" CASCADE CONSTRAINTS' FROM all_tables WHERE owner = sys_context('USERENV', 'SESSION_USER')      AND tablespace_name NOT IN ('SYSAUX')      AND global_stats = 'NO'      AND table_name NOT LIKE 'DEF$\\_%' ESCAPE '\\' UNION ALL SELECT 'DROP SEQUENCE ' || sequence_owner || '.' || sequence_name FROM all_sequences WHERE sequence_owner = sys_context('USERENV', 'SESSION_USER') and sequence_name not like 'ISEQ$$%' and sequence_name not like 'MVIEW$%'");
            }
            catch (SQLException sqlException) {
                throw new RuntimeException(sqlException);
            }
        });
    }

    @Override
    public void clearSchema(Connection connection, String schemaName) {
        this.cachedTruncateTableSqlPerSchema.remove(schemaName);
        this.cachedConstraintDisableSqlPerSchema.remove(schemaName);
        this.cachedConstraintEnableSqlPerSchema.remove(schemaName);
        this.clearSchema0(connection, statement -> {
            try {
                return statement.executeQuery("SELECT 'DROP TABLE ' || owner || '.\"' || table_name || '\" CASCADE CONSTRAINTS' FROM all_tables WHERE owner = '" + schemaName + "'      AND tablespace_name NOT IN ('SYSAUX')      AND global_stats = 'NO'      AND table_name NOT LIKE 'DEF$\\_%' ESCAPE '\\' UNION ALL SELECT 'DROP SEQUENCE ' || sequence_owner || '.' || sequence_name FROM all_sequences WHERE sequence_owner = '" + schemaName + "'");
            }
            catch (SQLException sqlException) {
                throw new RuntimeException(sqlException);
            }
        });
    }

    private void clearSchema0(Connection c, Function<Statement, ResultSet> sqlProvider) {
        try (Statement s = c.createStatement();){
            ArrayList<String> sqls = new ArrayList<String>();
            LOG.log(Level.FINEST, "Collect schema objects: START");
            ResultSet rs = sqlProvider.apply(s);
            while (rs.next()) {
                sqls.add(rs.getString(1));
            }
            LOG.log(Level.FINEST, "Collect schema objects: END");
            LOG.log(Level.FINEST, "Dropping schema objects: START");
            for (String sql : sqls) {
                s.execute(sql);
            }
            LOG.log(Level.FINEST, "Dropping schema objects: END");
            LOG.log(Level.FINEST, "Committing: START");
            c.commit();
            LOG.log(Level.FINEST, "Committing: END");
        }
        catch (SQLException e) {
            try {
                c.rollback();
            }
            catch (SQLException e1) {
                e.addSuppressed(e1);
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public void clearAllData(Connection connection) {
        this.clearData0(connection, null, statement -> {
            try {
                return statement.executeQuery("SELECT tbl.owner || '.\"' || tbl.table_name || '\"', c.constraint_name FROM (SELECT owner, table_name FROM all_tables WHERE owner NOT IN ('SYS')      AND tablespace_name NOT IN ('SYSAUX')      AND global_stats = 'NO'      AND table_name NOT LIKE 'DEF$\\_%' ESCAPE '\\') tbl LEFT JOIN all_constraints c ON tbl.owner = c.owner AND tbl.table_name = c.table_name AND constraint_type = 'R'");
            }
            catch (SQLException sqlException) {
                throw new RuntimeException(sqlException);
            }
        });
    }

    @Override
    public void clearData(Connection connection, String schemaName) {
        this.clearData0(connection, schemaName, statement -> {
            try {
                return statement.executeQuery("SELECT tbl.owner || '.\"' || tbl.table_name || '\"', c.constraint_name FROM (SELECT owner, table_name FROM all_tables WHERE owner = '" + schemaName + "'      AND tablespace_name NOT IN ('SYSAUX')      AND global_stats = 'NO'      AND table_name NOT LIKE 'DEF$\\_%' ESCAPE '\\') tbl LEFT JOIN all_constraints c ON tbl.owner = c.owner AND tbl.table_name = c.table_name AND constraint_type = 'R'");
            }
            catch (SQLException sqlException) {
                throw new RuntimeException(sqlException);
            }
        });
    }

    private void clearData0(Connection connection, String schemaName, Function<Statement, ResultSet> tablesProvider) {
        try (Statement s = connection.createStatement();){
            List<String> cachedTruncateTableSql = this.cachedTruncateTableSqlPerSchema.get(schemaName);
            List<String> cachedConstraintDisableSql = this.cachedConstraintDisableSqlPerSchema.get(schemaName);
            List<String> cachedConstraintEnableSql = this.cachedConstraintEnableSqlPerSchema.get(schemaName);
            if (cachedTruncateTableSql == null) {
                cachedTruncateTableSql = new ArrayList<String>();
                cachedConstraintDisableSql = new ArrayList<String>();
                cachedConstraintEnableSql = new ArrayList<String>();
                ResultSet rs = tablesProvider.apply(s);
                while (rs.next()) {
                    String tableName = rs.getString(1);
                    String constraintName = rs.getString(2);
                    if (this.ignoredTables.contains(tableName)) continue;
                    cachedTruncateTableSql.add("TRUNCATE TABLE \"" + tableName + "\"");
                    if (constraintName == null) continue;
                    cachedConstraintDisableSql.add("ALTER TABLE \"" + tableName + "\" DISABLE CONSTRAINT " + constraintName);
                    cachedConstraintEnableSql.add("ALTER TABLE \"" + tableName + "\" ENABLE CONSTRAINT " + constraintName);
                }
                this.cachedTruncateTableSqlPerSchema.put(schemaName, cachedTruncateTableSql);
                this.cachedConstraintDisableSqlPerSchema.put(schemaName, cachedConstraintDisableSql);
                this.cachedConstraintEnableSqlPerSchema.put(schemaName, cachedConstraintEnableSql);
            }
            LOG.log(Level.FINEST, "Disable foreign keys: START");
            for (String sql : cachedConstraintDisableSql) {
                s.execute(sql);
            }
            LOG.log(Level.FINEST, "Disable foreign keys: END");
            LOG.log(Level.FINEST, "Deleting data: START");
            for (String sql : cachedTruncateTableSql) {
                s.execute(sql);
            }
            LOG.log(Level.FINEST, "Deleting data: END");
            LOG.log(Level.FINEST, "Enabling foreign keys: START");
            for (String sql : cachedConstraintEnableSql) {
                s.execute(sql);
            }
            LOG.log(Level.FINEST, "Enabling foreign keys: END");
            LOG.log(Level.FINEST, "Committing: START");
            connection.commit();
            LOG.log(Level.FINEST, "Committing: END");
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException e1) {
                e.addSuppressed(e1);
            }
            throw new RuntimeException(e);
        }
    }
}

