/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.domain.gambit;

import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.MapKeyColumn;
import jakarta.persistence.MapKeyEnumerated;
import jakarta.persistence.MapKeyJoinColumn;
import jakarta.persistence.OneToMany;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.hibernate.annotations.SQLOrder;
import org.hibernate.annotations.SortComparator;
import org.hibernate.annotations.SortNatural;
import org.hibernate.testing.orm.domain.gambit.EnumValue;
import org.hibernate.testing.orm.domain.gambit.EnumValueConverter;
import org.hibernate.testing.orm.domain.gambit.SimpleBasicSortComparator;
import org.hibernate.testing.orm.domain.gambit.SimpleComponent;
import org.hibernate.testing.orm.domain.gambit.SimpleEntity;

@Entity
public class EntityOfMaps {
    private Integer id;
    private String name;
    private Map<String, String> basicByBasic;
    private Map<Integer, Double> numberByNumber;
    private SortedMap<String, String> sortedBasicByBasic;
    private SortedMap<String, String> sortedBasicByBasicWithComparator;
    private SortedMap<String, String> sortedBasicByBasicWithSortNaturalByDefault;
    private Map<EnumValue, String> basicByEnum;
    private Map<EnumValue, String> basicByConvertedEnum;
    private Map<String, SimpleComponent> componentByBasic;
    private Map<SimpleComponent, String> basicByComponent;
    private Map<String, SimpleEntity> oneToManyByBasic;
    private Map<SimpleEntity, String> basicByOneToMany;
    private Map<String, SimpleEntity> manyToManyByBasic;
    private Map<String, SimpleComponent> componentByBasicOrdered;
    private SortedMap<String, SimpleEntity> sortedManyToManyByBasic;
    private SortedMap<String, SimpleEntity> sortedManyToManyByBasicWithComparator;
    private SortedMap<String, SimpleEntity> sortedManyToManyByBasicWithSortNaturalByDefault;

    public EntityOfMaps() {
    }

    public EntityOfMaps(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    @Id
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ElementCollection
    @CollectionTable(name="EntityOfMaps_basic_basic1")
    @MapKeyColumn(name="basic_key")
    @Column(name="basic_val")
    public Map<String, String> getBasicByBasic() {
        return this.basicByBasic;
    }

    public void setBasicByBasic(Map<String, String> basicByBasic) {
        this.basicByBasic = basicByBasic;
    }

    public void addBasicByBasic(String key, String val) {
        if (this.basicByBasic == null) {
            this.basicByBasic = new HashMap<String, String>();
        }
        this.basicByBasic.put(key, val);
    }

    @ElementCollection
    @CollectionTable(name="EntityOfMaps_number_number1")
    @MapKeyColumn(name="number_key")
    @Column(name="number_val")
    public Map<Integer, Double> getNumberByNumber() {
        return this.numberByNumber;
    }

    public void setNumberByNumber(Map<Integer, Double> numberByNumber) {
        this.numberByNumber = numberByNumber;
    }

    public void addNumberByNumber(int key, double val) {
        if (this.numberByNumber == null) {
            this.numberByNumber = new HashMap<Integer, Double>();
        }
        this.numberByNumber.put(key, val);
    }

    @ElementCollection
    @SortNatural
    @CollectionTable(name="EntityOfMaps_basic_basic2")
    @MapKeyColumn(name="basic_key")
    @Column(name="basic_val")
    public SortedMap<String, String> getSortedBasicByBasic() {
        return this.sortedBasicByBasic;
    }

    public void setSortedBasicByBasic(SortedMap<String, String> sortedBasicByBasic) {
        this.sortedBasicByBasic = sortedBasicByBasic;
    }

    public void addSortedBasicByBasic(String key, String val) {
        if (this.sortedBasicByBasic == null) {
            this.sortedBasicByBasic = new TreeMap<String, String>();
        }
        this.sortedBasicByBasic.put(key, val);
    }

    @ElementCollection
    @SortComparator(value=SimpleBasicSortComparator.class)
    @CollectionTable(name="EntityOfMaps_basic_basic3")
    @MapKeyColumn(name="basic_key")
    @Column(name="basic_val")
    public SortedMap<String, String> getSortedBasicByBasicWithComparator() {
        return this.sortedBasicByBasicWithComparator;
    }

    public void setSortedBasicByBasicWithComparator(SortedMap<String, String> sortedBasicByBasicWithComparator) {
        this.sortedBasicByBasicWithComparator = sortedBasicByBasicWithComparator;
    }

    public void addSortedBasicByBasicWithComparator(String key, String val) {
        if (this.sortedBasicByBasicWithComparator == null) {
            this.sortedBasicByBasicWithComparator = new TreeMap<String, String>();
        }
        this.sortedBasicByBasicWithComparator.put(key, val);
    }

    @ElementCollection
    @CollectionTable(name="EntityOfMaps_basic_basic4")
    @MapKeyColumn(name="basic_key")
    @Column(name="basic_val")
    public SortedMap<String, String> getSortedBasicByBasicWithSortNaturalByDefault() {
        return this.sortedBasicByBasicWithSortNaturalByDefault;
    }

    public void setSortedBasicByBasicWithSortNaturalByDefault(SortedMap<String, String> sortedBasicByBasicWithSortNaturalByDefault) {
        this.sortedBasicByBasicWithSortNaturalByDefault = sortedBasicByBasicWithSortNaturalByDefault;
    }

    public void addSortedBasicByBasicWithSortNaturalByDefault(String key, String val) {
        if (this.sortedBasicByBasicWithSortNaturalByDefault == null) {
            this.sortedBasicByBasicWithSortNaturalByDefault = new TreeMap<String, String>();
        }
        this.sortedBasicByBasicWithSortNaturalByDefault.put(key, val);
    }

    @ElementCollection
    @MapKeyEnumerated
    @CollectionTable(name="EntityOfMaps_basic_enum1")
    @MapKeyColumn(name="enum_key")
    @Column(name="basic_val")
    public Map<EnumValue, String> getBasicByEnum() {
        return this.basicByEnum;
    }

    public void setBasicByEnum(Map<EnumValue, String> basicByEnum) {
        this.basicByEnum = basicByEnum;
    }

    public void addBasicByEnum(EnumValue key, String val) {
        if (this.basicByEnum == null) {
            this.basicByEnum = new HashMap<EnumValue, String>();
        }
        this.basicByEnum.put(key, val);
    }

    @ElementCollection
    @Convert(attributeName="key", converter=EnumValueConverter.class)
    @CollectionTable(name="EntityOfMaps_basic_enum2")
    @MapKeyColumn(name="enum_key")
    @Column(name="basic_val")
    public Map<EnumValue, String> getBasicByConvertedEnum() {
        return this.basicByConvertedEnum;
    }

    public void setBasicByConvertedEnum(Map<EnumValue, String> basicByConvertedEnum) {
        this.basicByConvertedEnum = basicByConvertedEnum;
    }

    public void addBasicByConvertedEnum(EnumValue key, String value) {
        if (this.basicByConvertedEnum == null) {
            this.basicByConvertedEnum = new HashMap<EnumValue, String>();
        }
        this.basicByConvertedEnum.put(key, value);
    }

    @ElementCollection
    @CollectionTable(name="EntityOfMaps_comp_basic1")
    @MapKeyColumn(name="basic_key")
    public Map<String, SimpleComponent> getComponentByBasic() {
        return this.componentByBasic;
    }

    public void setComponentByBasic(Map<String, SimpleComponent> componentByBasic) {
        this.componentByBasic = componentByBasic;
    }

    public void addComponentByBasic(String key, SimpleComponent value) {
        if (this.componentByBasic == null) {
            this.componentByBasic = new HashMap<String, SimpleComponent>();
        }
        this.componentByBasic.put(key, value);
    }

    @ElementCollection
    @CollectionTable(name="EntityOfMaps_basic_comp")
    @Column(name="basic_val")
    public Map<SimpleComponent, String> getBasicByComponent() {
        return this.basicByComponent;
    }

    public void setBasicByComponent(Map<SimpleComponent, String> basicByComponent) {
        this.basicByComponent = basicByComponent;
    }

    public void addBasicByComponent(SimpleComponent key, String value) {
        if (this.basicByComponent == null) {
            this.basicByComponent = new HashMap<SimpleComponent, String>();
        }
        this.basicByComponent.put(key, value);
    }

    @OneToMany
    @JoinColumn
    @MapKeyColumn(name="basic_key")
    @JoinTable(name="EntityOfMaps_o2m_basic", joinColumns={@JoinColumn(name="EntityOfMaps_o2m_basic_id1")}, inverseJoinColumns={@JoinColumn(name="EntityOfMaps_o2m_basic_id2")})
    public Map<String, SimpleEntity> getOneToManyByBasic() {
        return this.oneToManyByBasic;
    }

    public void setOneToManyByBasic(Map<String, SimpleEntity> oneToManyByBasic) {
        this.oneToManyByBasic = oneToManyByBasic;
    }

    public void addOneToManyByBasic(String key, SimpleEntity value) {
        if (this.oneToManyByBasic == null) {
            this.oneToManyByBasic = new HashMap<String, SimpleEntity>();
        }
        this.oneToManyByBasic.put(key, value);
    }

    @ElementCollection
    @CollectionTable(name="EntityOfMaps_basic_o2m")
    @Column(name="basic_val")
    @MapKeyJoinColumn(name="EntityOfMaps_basic_o2m_key")
    public Map<SimpleEntity, String> getBasicByOneToMany() {
        return this.basicByOneToMany;
    }

    public void setBasicByOneToMany(Map<SimpleEntity, String> basicByOneToMany) {
        this.basicByOneToMany = basicByOneToMany;
    }

    public void addOneToManyByBasic(SimpleEntity key, String val) {
        if (this.basicByOneToMany == null) {
            this.basicByOneToMany = new HashMap<SimpleEntity, String>();
        }
        this.basicByOneToMany.put(key, val);
    }

    @ManyToMany
    @MapKeyColumn(name="basic_key")
    @JoinTable(name="EntityOfMaps_m2m_basic1", joinColumns={@JoinColumn(name="EntityOfMaps_m2m_basic1_id1")}, inverseJoinColumns={@JoinColumn(name="EntityOfMaps_m2m_basic1_id2")})
    public Map<String, SimpleEntity> getManyToManyByBasic() {
        return this.manyToManyByBasic;
    }

    public void setManyToManyByBasic(Map<String, SimpleEntity> manyToManyByBasic) {
        this.manyToManyByBasic = manyToManyByBasic;
    }

    public void addManyToManyByComponent(String key, SimpleEntity value) {
        if (this.manyToManyByBasic == null) {
            this.manyToManyByBasic = new HashMap<String, SimpleEntity>();
        }
        this.manyToManyByBasic.put(key, value);
    }

    @ElementCollection
    @MapKeyColumn(name="ordered_component_key")
    @SQLOrder(value="ordered_component_key, ordered_component_key")
    @CollectionTable(name="EntityOfMaps_comp_basic2")
    public Map<String, SimpleComponent> getComponentByBasicOrdered() {
        return this.componentByBasicOrdered;
    }

    public void setComponentByBasicOrdered(Map<String, SimpleComponent> componentByBasicOrdered) {
        this.componentByBasicOrdered = componentByBasicOrdered;
    }

    public void addComponentByBasicOrdered(String key, SimpleComponent value) {
        if (this.componentByBasicOrdered == null) {
            this.componentByBasicOrdered = new LinkedHashMap<String, SimpleComponent>();
        }
        this.componentByBasicOrdered.put(key, value);
    }

    @ManyToMany
    @SortNatural
    @MapKeyColumn(name="basic_key")
    @JoinTable(name="EntityOfMaps_m2m_basic2", joinColumns={@JoinColumn(name="EntityOfMaps_m2m_basic2_id1")}, inverseJoinColumns={@JoinColumn(name="EntityOfMaps_m2m_basic2_id2")})
    public SortedMap<String, SimpleEntity> getSortedManyToManyByBasic() {
        return this.sortedManyToManyByBasic;
    }

    public void setSortedManyToManyByBasic(SortedMap<String, SimpleEntity> sortedManyToManyByBasic) {
        this.sortedManyToManyByBasic = sortedManyToManyByBasic;
    }

    @ManyToMany
    @SortComparator(value=SimpleBasicSortComparator.class)
    @JoinTable(name="EntityOfMaps_m2m_basic3", joinColumns={@JoinColumn(name="EntityOfMaps_m2m_basic3_id1")}, inverseJoinColumns={@JoinColumn(name="EntityOfMaps_m2m_basic3_id2")})
    @MapKeyColumn(name="basic_key")
    public SortedMap<String, SimpleEntity> getSortedManyToManyByBasicWithComparator() {
        return this.sortedManyToManyByBasicWithComparator;
    }

    public void setSortedManyToManyByBasicWithComparator(SortedMap<String, SimpleEntity> sortedManyToManyByBasicWithComparator) {
        this.sortedManyToManyByBasicWithComparator = sortedManyToManyByBasicWithComparator;
    }

    public void addSortedManyToManyByBasicWithComparator(String key, SimpleEntity value) {
        if (this.sortedManyToManyByBasicWithComparator == null) {
            this.sortedManyToManyByBasicWithComparator = new TreeMap<String, SimpleEntity>();
        }
        this.sortedManyToManyByBasicWithComparator.put(key, value);
    }

    @ManyToMany
    @MapKeyColumn(name="basic_key")
    @JoinTable(name="EntityOfMaps_m2m_basic4", joinColumns={@JoinColumn(name="EntityOfMaps_m2m_basic4_id1")}, inverseJoinColumns={@JoinColumn(name="EntityOfMaps_m2m_basic4_id2")})
    public SortedMap<String, SimpleEntity> getSortedManyToManyByBasicWithSortNaturalByDefault() {
        return this.sortedManyToManyByBasicWithSortNaturalByDefault;
    }

    public void setSortedManyToManyByBasicWithSortNaturalByDefault(SortedMap<String, SimpleEntity> sortedManyToManyByBasicWithSortNaturalByDefault) {
        this.sortedManyToManyByBasicWithSortNaturalByDefault = sortedManyToManyByBasicWithSortNaturalByDefault;
    }

    public void addSortedManyToManyByBasicWithSortNaturalByDefault(String key, SimpleEntity value) {
        if (this.sortedManyToManyByBasicWithSortNaturalByDefault == null) {
            this.sortedManyToManyByBasicWithSortNaturalByDefault = new TreeMap<String, SimpleEntity>();
        }
        this.sortedManyToManyByBasicWithSortNaturalByDefault.put(key, value);
    }
}

