/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.jdbc;

import java.util.TimeZone;
import org.hibernate.testing.jdbc.ConnectionProviderDelegate;
import org.hibernate.testing.jdbc.SharedDriverManagerConnectionProviderImpl;

public class TimeZoneConnectionProvider
extends ConnectionProviderDelegate {
    private final String defaultTimeZone;
    private final String customTimeZone;

    public TimeZoneConnectionProvider(String customTimeZone) {
        this.customTimeZone = customTimeZone;
        this.defaultTimeZone = System.setProperty("user.timezone", customTimeZone);
        TimeZone.setDefault(TimeZone.getTimeZone(customTimeZone));
        SharedDriverManagerConnectionProviderImpl.getInstance().onDefaultTimeZoneChange();
    }

    @Override
    public void stop() {
        super.stop();
        System.setProperty("user.timezone", this.defaultTimeZone);
        TimeZone.setDefault(TimeZone.getTimeZone(this.defaultTimeZone));
        SharedDriverManagerConnectionProviderImpl.getInstance().onDefaultTimeZoneChange();
    }
}

