/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.junit4;

import jakarta.persistence.SharedCacheMode;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.Session;
import org.hibernate.StatelessSession;
import org.hibernate.Transaction;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.model.naming.ImplicitNamingStrategyLegacyJpaImpl;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.registry.internal.StandardServiceRegistryImpl;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.build.AllowSysOut;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.jdbc.AbstractReturningWork;
import org.hibernate.jdbc.ReturningWork;
import org.hibernate.jdbc.Work;
import org.hibernate.resource.transaction.spi.TransactionCoordinator;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.testing.AfterClassOnce;
import org.hibernate.testing.BeforeClassOnce;
import org.hibernate.testing.OnExpectedFailure;
import org.hibernate.testing.OnFailure;
import org.hibernate.testing.SkipLog;
import org.hibernate.testing.cache.CachingRegionFactory;
import org.hibernate.testing.junit4.BaseUnitTestCase;
import org.hibernate.testing.junit4.Helper;
import org.hibernate.testing.orm.junit.DialectContext;
import org.hibernate.testing.transaction.TransactionUtil;
import org.hibernate.testing.transaction.TransactionUtil2;
import org.hibernate.testing.util.ServiceRegistryUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class BaseCoreFunctionalTestCase
extends BaseUnitTestCase {
    public static final String VALIDATE_DATA_CLEANUP = "hibernate.test.validateDataCleanup";
    public static final Dialect DIALECT = DialectContext.getDialect();
    private Configuration configuration;
    private StandardServiceRegistryImpl serviceRegistry;
    private SessionFactoryImplementor sessionFactory;
    protected Session session;
    protected static final String[] NO_MAPPINGS = new String[0];
    protected static final Class<?>[] NO_CLASSES = new Class[0];

    protected static Dialect getDialect() {
        return DIALECT;
    }

    protected Configuration configuration() {
        return this.configuration;
    }

    protected StandardServiceRegistryImpl serviceRegistry() {
        return this.serviceRegistry;
    }

    protected SessionFactoryImplementor sessionFactory() {
        return this.sessionFactory;
    }

    protected Session openSession() throws HibernateException {
        this.session = this.sessionFactory().openSession();
        return this.session;
    }

    protected Session openSession(Interceptor interceptor) throws HibernateException {
        this.session = this.sessionFactory().withOptions().interceptor(interceptor).openSession();
        return this.session;
    }

    @BeforeClassOnce
    protected void buildSessionFactory() {
        this.buildSessionFactory(null);
    }

    protected void buildSessionFactory(Consumer<Configuration> configurationAdapter) {
        BootstrapServiceRegistry bootRegistry = null;
        try {
            bootRegistry = this.buildBootstrapServiceRegistry();
            this.configuration = this.constructAndConfigureConfiguration(bootRegistry);
            if (configurationAdapter != null) {
                configurationAdapter.accept(this.configuration);
            }
            this.serviceRegistry = this.buildServiceRegistry(bootRegistry, this.configuration);
            this.afterConstructAndConfigureConfiguration(this.configuration);
            this.sessionFactory = (SessionFactoryImplementor)this.configuration.buildSessionFactory((ServiceRegistry)this.serviceRegistry);
            this.afterSessionFactoryBuilt();
        }
        catch (Throwable t) {
            if (this.sessionFactory != null) {
                this.sessionFactory.close();
                this.sessionFactory = null;
                this.configuration = null;
            }
            if (this.serviceRegistry != null) {
                this.serviceRegistry.destroy();
                this.serviceRegistry = null;
            } else if (bootRegistry != null) {
                bootRegistry.close();
            }
            throw t;
        }
    }

    protected void rebuildSessionFactory() {
        this.rebuildSessionFactory(null);
    }

    protected void rebuildSessionFactory(Consumer<Configuration> configurationAdapter) {
        if (this.sessionFactory == null) {
            return;
        }
        try {
            this.sessionFactory.close();
            this.sessionFactory = null;
            this.configuration = null;
            this.serviceRegistry.destroy();
            this.serviceRegistry = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.buildSessionFactory(configurationAdapter);
    }

    protected Configuration constructAndConfigureConfiguration(BootstrapServiceRegistry bootstrapServiceRegistry) {
        Configuration cfg = this.constructConfiguration(bootstrapServiceRegistry);
        this.configure(cfg);
        return cfg;
    }

    private void afterConstructAndConfigureConfiguration(Configuration cfg) {
        this.addMappings(cfg);
        this.applyCacheSettings(cfg);
        this.afterConfigurationBuilt(cfg);
    }

    protected Configuration constructConfiguration(BootstrapServiceRegistry bootstrapServiceRegistry) {
        Configuration configuration = new Configuration(bootstrapServiceRegistry);
        configuration.setProperty("hibernate.cache.region.factory_class", CachingRegionFactory.class.getName());
        if (this.createSchema()) {
            configuration.setProperty("hibernate.hbm2ddl.auto", "create-drop");
            String secondSchemaName = this.createSecondSchema();
            if (StringHelper.isNotEmpty((String)secondSchemaName)) {
                if (!(BaseCoreFunctionalTestCase.getDialect() instanceof H2Dialect)) {
                    throw new UnsupportedOperationException("Only H2 dialect supports creation of second schema.");
                }
                Helper.createH2Schema(secondSchemaName, configuration);
            }
        }
        configuration.setImplicitNamingStrategy((ImplicitNamingStrategy)ImplicitNamingStrategyLegacyJpaImpl.INSTANCE);
        configuration.setProperty("hibernate.dialect", BaseCoreFunctionalTestCase.getDialect().getClass().getName());
        configuration.getProperties().put("hibernate.hql.bulk_id_strategy.persistent.drop_tables", "true");
        configuration.getProperties().put("hibernate.hql.bulk_id_strategy.global_temporary.drop_tables", "true");
        configuration.getProperties().put("hibernate.hql.bulk_id_strategy.local_temporary.drop_tables", "true");
        ServiceRegistryUtil.applySettings(configuration.getStandardServiceRegistryBuilder());
        return configuration;
    }

    protected void configure(Configuration configuration) {
    }

    protected void addMappings(Configuration configuration) {
        String[] xmlFiles;
        String[] annotatedPackages;
        Class<?>[] annotatedClasses;
        String[] mappings = this.getMappings();
        if (mappings != null) {
            for (String mapping : mappings) {
                if (mapping.startsWith("/")) {
                    configuration.addResource(mapping);
                    continue;
                }
                configuration.addResource(this.getBaseForMappings() + mapping);
            }
        }
        if ((annotatedClasses = this.getAnnotatedClasses()) != null) {
            for (Class<?> annotatedClass : annotatedClasses) {
                configuration.addAnnotatedClass(annotatedClass);
            }
        }
        if ((annotatedPackages = this.getAnnotatedPackages()) != null) {
            for (String annotatedPackage : annotatedPackages) {
                configuration.addPackage(annotatedPackage);
            }
        }
        if ((xmlFiles = this.getOrmXmlFiles()) != null) {
            for (String xmlFile : xmlFiles) {
                try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(xmlFile);){
                    configuration.addInputStream(is);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
    }

    protected String[] getMappings() {
        return NO_MAPPINGS;
    }

    protected String getBaseForMappings() {
        return "org/hibernate/orm/test/";
    }

    protected Class<?>[] getAnnotatedClasses() {
        return NO_CLASSES;
    }

    protected String[] getAnnotatedPackages() {
        return NO_MAPPINGS;
    }

    protected String[] getOrmXmlFiles() {
        return NO_MAPPINGS;
    }

    protected void applyCacheSettings(Configuration configuration) {
        if (this.getCacheConcurrencyStrategy() != null) {
            configuration.setProperty("hibernate.cache.default_cache_concurrency_strategy", this.getCacheConcurrencyStrategy());
            configuration.setSharedCacheMode(SharedCacheMode.ALL);
        }
    }

    protected String getCacheConcurrencyStrategy() {
        return null;
    }

    protected void afterConfigurationBuilt(Configuration configuration) {
    }

    protected BootstrapServiceRegistry buildBootstrapServiceRegistry() {
        BootstrapServiceRegistryBuilder builder = new BootstrapServiceRegistryBuilder();
        builder.applyClassLoader(this.getClass().getClassLoader());
        this.prepareBootstrapRegistryBuilder(builder);
        return builder.build();
    }

    protected void prepareBootstrapRegistryBuilder(BootstrapServiceRegistryBuilder builder) {
    }

    protected StandardServiceRegistryImpl buildServiceRegistry(BootstrapServiceRegistry bootRegistry, Configuration configuration) {
        try {
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)configuration.getProperties());
            ConfigurationHelper.resolvePlaceHolders((Map)properties);
            StandardServiceRegistryBuilder cfgRegistryBuilder = configuration.getStandardServiceRegistryBuilder();
            StandardServiceRegistryBuilder registryBuilder = new StandardServiceRegistryBuilder(bootRegistry, cfgRegistryBuilder.getAggregatedCfgXml()).applySettings(properties);
            ServiceRegistryUtil.applySettings(registryBuilder);
            this.prepareBasicRegistryBuilder(registryBuilder);
            return (StandardServiceRegistryImpl)registryBuilder.build();
        }
        catch (Throwable t) {
            if (bootRegistry != null) {
                bootRegistry.close();
            }
            throw t;
        }
    }

    protected void prepareBasicRegistryBuilder(StandardServiceRegistryBuilder serviceRegistryBuilder) {
    }

    protected void afterSessionFactoryBuilt() {
    }

    protected boolean createSchema() {
        return true;
    }

    protected String createSecondSchema() {
        return null;
    }

    protected boolean rebuildSessionFactoryOnError() {
        return true;
    }

    @AfterClassOnce
    protected void releaseSessionFactory() {
        if (this.sessionFactory == null) {
            return;
        }
        this.sessionFactory.close();
        this.sessionFactory = null;
        this.configuration = null;
        if (this.serviceRegistry != null && this.serviceRegistry.isActive()) {
            try {
                this.serviceRegistry.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Assert.fail((String)"StandardServiceRegistry was not closed down as expected");
        }
        this.serviceRegistry = null;
    }

    @OnFailure
    @OnExpectedFailure
    public void onFailure() {
        if (this.rebuildSessionFactoryOnError()) {
            this.rebuildSessionFactory();
        }
    }

    @Before
    public final void beforeTest() throws Exception {
        this.prepareTest();
    }

    protected void prepareTest() throws Exception {
    }

    @After
    public final void afterTest() throws Exception {
        if (BaseCoreFunctionalTestCase.getDialect() instanceof H2Dialect) {
            ReflectHelper.getMethod(Class.forName("org.h2.util.DateTimeUtils"), (String)"resetCalendar", (Class[])new Class[0]).invoke(null, new Object[0]);
        }
        this.completeStrayTransaction();
        if (this.isCleanupTestDataRequired()) {
            this.cleanupTestData();
        }
        this.cleanupTest();
        this.cleanupSession();
        this.assertAllDataRemoved();
    }

    private void completeStrayTransaction() {
        if (this.session == null) {
            return;
        }
        if (((SessionImplementor)this.session).isClosed()) {
            return;
        }
        if (!this.session.isConnected()) {
            return;
        }
        TransactionCoordinator.TransactionDriver tdc = ((SessionImplementor)this.session).getTransactionCoordinator().getTransactionDriverControl();
        if (tdc.getStatus().canRollback()) {
            this.session.getTransaction().rollback();
        }
        this.session.close();
    }

    protected void cleanupCache() {
        if (this.sessionFactory != null) {
            this.sessionFactory.getCache().evictAllRegions();
        }
    }

    protected boolean isCleanupTestDataRequired() {
        return false;
    }

    protected boolean isCleanupTestDataUsingBulkDelete() {
        return false;
    }

    protected void cleanupTestData() throws Exception {
        if (this.isCleanupTestDataUsingBulkDelete()) {
            TransactionUtil.doInHibernate(this::sessionFactory, s -> s.createQuery("delete from java.lang.Object").executeUpdate());
        } else {
            TransactionUtil.doInHibernate(this::sessionFactory, s -> s.createQuery("from java.lang.Object", Object.class).list().forEach(arg_0 -> ((Session)s).remove(arg_0)));
        }
    }

    private void cleanupSession() {
        if (this.session != null && !((SessionImplementor)this.session).isClosed()) {
            this.session.close();
        }
        this.session = null;
    }

    protected void cleanupTest() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AllowSysOut
    protected void assertAllDataRemoved() {
        if (!this.createSchema()) {
            return;
        }
        if (!Boolean.getBoolean(VALIDATE_DATA_CLEANUP)) {
            return;
        }
        SessionImplementor tmpSession = this.sessionFactory.openSession();
        Transaction transaction = tmpSession.beginTransaction();
        try {
            List list = tmpSession.createQuery("select o from java.lang.Object o").list();
            HashMap<String, Integer> items = new HashMap<String, Integer>();
            if (!list.isEmpty()) {
                for (Object element : list) {
                    Integer l = (Integer)items.get(tmpSession.getEntityName(element));
                    if (l == null) {
                        l = 0;
                    }
                    l = l + 1;
                    items.put(tmpSession.getEntityName(element), l);
                    System.out.println("Data left: " + element);
                }
                transaction.rollback();
                Assert.fail((String)("Data is left in the database: " + items));
            }
            transaction.rollback();
        }
        finally {
            try {
                if (transaction.getStatus().canRollback()) {
                    transaction.rollback();
                }
                tmpSession.close();
            }
            catch (Throwable throwable) {}
        }
    }

    protected boolean readCommittedIsolationMaintained(String scenario) {
        int isolation = 1;
        try (Session testSession = this.openSession();){
            isolation = (Integer)testSession.doReturningWork((ReturningWork)new AbstractReturningWork<Integer>(){

                public Integer execute(Connection connection) throws SQLException {
                    return connection.getTransactionIsolation();
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (isolation < 2) {
            SkipLog.reportSkip("environment does not support at least read committed isolation", scenario);
            return false;
        }
        return true;
    }

    protected void inTransaction(Consumer<SessionImplementor> action) {
        TransactionUtil2.inTransaction(this.sessionFactory(), action);
    }

    protected <T> T fromTransaction(Function<SessionImplementor, T> action) {
        return TransactionUtil2.fromTransaction(this.sessionFactory(), action);
    }

    protected void inTransaction(SessionImplementor session, Consumer<SessionImplementor> action) {
        TransactionUtil2.inTransaction(session, action);
    }

    protected void inSession(Consumer<SessionImplementor> action) {
        TransactionUtil2.inSession(this.sessionFactory(), action);
    }

    protected void inStatelessSession(Consumer<StatelessSession> action) {
        TransactionUtil2.inStatelessSession(this.sessionFactory(), action);
    }

    public static class RollbackWork
    implements Work {
        public void execute(Connection connection) throws SQLException {
            connection.rollback();
        }
    }
}

