/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.logger;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.hibernate.testing.logger.LogListener;
import org.hibernate.testing.logger.Triggerable;
import org.jboss.logging.Logger;

public final class TriggerOnPrefixLogListener
implements LogListener,
Triggerable {
    private Set<String> expectedPrefixes = new HashSet<String>();
    private final List<String> triggerMessages = new CopyOnWriteArrayList<String>();

    public TriggerOnPrefixLogListener(String expectedPrefix) {
        this.expectedPrefixes.add(expectedPrefix);
    }

    public TriggerOnPrefixLogListener(Set<String> expectedPrefixes) {
        this.expectedPrefixes = expectedPrefixes;
    }

    @Override
    public void loggedEvent(Logger.Level level, String renderedMessage, Throwable thrown) {
        if (renderedMessage != null) {
            for (String expectedPrefix : this.expectedPrefixes) {
                if (!renderedMessage.startsWith(expectedPrefix)) continue;
                this.triggerMessages.add(renderedMessage);
            }
        }
    }

    @Override
    public String triggerMessage() {
        return !this.triggerMessages.isEmpty() ? this.triggerMessages.get(0) : null;
    }

    @Override
    public List<String> triggerMessages() {
        return this.triggerMessages;
    }

    @Override
    public boolean wasTriggered() {
        return !this.triggerMessages.isEmpty();
    }

    @Override
    public void reset() {
        this.triggerMessages.clear();
    }
}

