/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hibernate.testing.jdbc.ConnectionProviderDelegate;
import org.hibernate.testing.jdbc.JdbcSpies;

public class PreparedStatementSpyConnectionProvider
extends ConnectionProviderDelegate {
    private final Map<PreparedStatement, String> preparedStatementMap = new LinkedHashMap<PreparedStatement, String>();
    private final List<String> executeStatements = new ArrayList<String>(4);
    private final List<String> executeUpdateStatements = new ArrayList<String>(4);
    public final JdbcSpies.SpyContext spyContext = new JdbcSpies.SpyContext().registerCallback((spy, method, args, result) -> {
        if (method.getDeclaringClass() == Connection.class && method.getName().equals("prepareStatement")) {
            this.preparedStatementMap.put((PreparedStatement)result, (String)args[0]);
        } else if (method.getDeclaringClass() == Statement.class && method.getName().equals("execute")) {
            this.executeStatements.add((String)args[0]);
        } else if (method.getDeclaringClass() == Statement.class && method.getName().equals("executeUpdate")) {
            this.executeUpdateStatements.add((String)args[0]);
        }
    });
    private final List<Connection> acquiredConnections = new ArrayList<Connection>(4);
    private final List<Connection> releasedConnections = new ArrayList<Connection>(4);

    public PreparedStatementSpyConnectionProvider() {
        this(false);
    }

    public PreparedStatementSpyConnectionProvider(boolean forceSupportsAggressiveRelease) {
        super(forceSupportsAggressiveRelease);
    }

    protected Connection actualConnection() throws SQLException {
        return super.getConnection();
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection connection = this.instrumentConnection(this.actualConnection());
        this.acquiredConnections.add(connection);
        return connection;
    }

    @Override
    public void closeConnection(Connection conn) throws SQLException {
        this.acquiredConnections.remove(conn);
        this.releasedConnections.add(conn);
        super.closeConnection(this.spyContext.getSpiedInstance(conn));
    }

    @Override
    public void stop() {
        this.clear();
        super.stop();
    }

    private Connection instrumentConnection(Connection connection) {
        return JdbcSpies.spy(connection, this.spyContext);
    }

    public void clear() {
        this.acquiredConnections.clear();
        this.releasedConnections.clear();
        this.spyContext.clear();
        this.preparedStatementMap.clear();
        this.executeStatements.clear();
        this.executeUpdateStatements.clear();
    }

    public PreparedStatement getPreparedStatement(String sql) {
        List<PreparedStatement> preparedStatements = this.getPreparedStatements(sql);
        if (preparedStatements.isEmpty()) {
            throw new IllegalArgumentException("There is no PreparedStatement for this SQL statement: " + sql);
        }
        if (preparedStatements.size() > 1) {
            throw new IllegalArgumentException("There are " + preparedStatements.size() + " PreparedStatements for this SQL statement: " + sql);
        }
        return preparedStatements.get(0);
    }

    public List<PreparedStatement> getPreparedStatements(String sql) {
        return this.preparedStatementMap.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(sql)).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public List<PreparedStatement> getPreparedStatements() {
        return new ArrayList<PreparedStatement>(this.preparedStatementMap.keySet());
    }

    public List<String> getPreparedSQLStatements() {
        return new ArrayList<String>(this.preparedStatementMap.values());
    }

    public List<String> getExecuteStatements() {
        return this.executeStatements;
    }

    public List<String> getExecuteUpdateStatements() {
        return this.executeUpdateStatements;
    }

    public List<Connection> getAcquiredConnections() {
        return this.acquiredConnections;
    }

    public List<Connection> getReleasedConnections() {
        return this.releasedConnections;
    }
}

