/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.criteria.internal;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import org.hibernate.query.criteria.HibernateCriteriaBuilder;
import org.hibernate.query.criteria.spi.HibernateCriteriaBuilderDelegate;
import org.hibernate.spatial.CommonSpatialFunction;
import org.hibernate.spatial.SpatialFunction;
import org.hibernate.spatial.criteria.SpatialCriteriaBuilder;

public abstract class SpatialCriteriaBuilderImpl<T>
extends HibernateCriteriaBuilderDelegate
implements SpatialCriteriaBuilder<T> {
    protected SpatialCriteriaBuilderImpl(HibernateCriteriaBuilder criteriaBuilder) {
        super(criteriaBuilder);
    }

    @Override
    public Predicate eq(Expression<? extends T> geometry1, Expression<? extends T> geometry2) {
        return this.equal((Expression)this.function(CommonSpatialFunction.ST_EQUALS.name(), Boolean.TYPE, new Expression[]{geometry1, geometry2}), true);
    }

    @Override
    public Predicate eq(Expression<? extends T> geometry1, T geometry2) {
        return this.eq(geometry1, this.value(geometry2));
    }

    @Override
    public Predicate within(Expression<? extends T> geometry1, Expression<? extends T> geometry2) {
        return this.equal((Expression)this.function(CommonSpatialFunction.ST_WITHIN.name(), Boolean.TYPE, new Expression[]{geometry1, geometry2}), true);
    }

    @Override
    public Predicate within(Expression<? extends T> geometry1, T geometry2) {
        return this.within(geometry1, this.value(geometry2));
    }

    @Override
    public Predicate contains(Expression<? extends T> geometry1, Expression<? extends T> geometry2) {
        return this.equal((Expression)this.function(CommonSpatialFunction.ST_CONTAINS.name(), Boolean.TYPE, new Expression[]{geometry1, geometry2}), true);
    }

    @Override
    public Predicate contains(Expression<? extends T> geometry1, T geometry2) {
        return this.contains(geometry1, this.value(geometry2));
    }

    @Override
    public Predicate crosses(Expression<? extends T> geometry1, Expression<? extends T> geometry2) {
        return this.equal((Expression)this.function(CommonSpatialFunction.ST_CROSSES.name(), Boolean.TYPE, new Expression[]{geometry1, geometry2}), true);
    }

    @Override
    public Predicate crosses(Expression<? extends T> geometry1, T geometry2) {
        return this.crosses(geometry1, this.value(geometry2));
    }

    @Override
    public Predicate disjoint(Expression<? extends T> geometry1, Expression<? extends T> geometry2) {
        return this.equal((Expression)this.function(CommonSpatialFunction.ST_DISJOINT.name(), Boolean.TYPE, new Expression[]{geometry1, geometry2}), true);
    }

    @Override
    public Predicate disjoint(Expression<? extends T> geometry1, T geometry2) {
        return this.disjoint(geometry1, this.value(geometry2));
    }

    @Override
    public Predicate intersects(Expression<? extends T> geometry1, Expression<? extends T> geometry2) {
        return this.equal((Expression)this.function(CommonSpatialFunction.ST_INTERSECTS.name(), Boolean.TYPE, new Expression[]{geometry1, geometry2}), true);
    }

    @Override
    public Predicate intersects(Expression<? extends T> geometry1, T geometry2) {
        return this.intersects(geometry1, this.value(geometry2));
    }

    @Override
    public Predicate overlaps(Expression<? extends T> geometry1, Expression<? extends T> geometry2) {
        return this.equal((Expression)this.function(CommonSpatialFunction.ST_OVERLAPS.name(), Boolean.TYPE, new Expression[]{geometry1, geometry2}), true);
    }

    @Override
    public Predicate overlaps(Expression<? extends T> geometry1, T geometry2) {
        return this.overlaps(geometry1, this.value(geometry2));
    }

    @Override
    public Predicate touches(Expression<? extends T> geometry1, Expression<? extends T> geometry2) {
        return this.equal((Expression)this.function(CommonSpatialFunction.ST_TOUCHES.name(), Boolean.TYPE, new Expression[]{geometry1, geometry2}), true);
    }

    @Override
    public Predicate touches(Expression<? extends T> geometry1, T geometry2) {
        return this.touches(geometry1, this.value(geometry2));
    }

    @Override
    public Predicate distanceWithin(Expression<? extends T> geometry1, Expression<? extends T> geometry2, Expression<Double> distance) {
        return this.equal((Expression)this.function(SpatialFunction.dwithin.toString(), Boolean.TYPE, new Expression[]{geometry1, geometry2, distance}), true);
    }

    @Override
    public Predicate distanceWithin(Expression<? extends T> geometry1, T geometry2, Expression<Double> distance) {
        return this.distanceWithin(geometry1, this.value(geometry2), distance);
    }

    @Override
    public Predicate distanceWithin(Expression<? extends T> geometry1, T geometry2, double distance) {
        return this.distanceWithin(geometry1, this.value(geometry2), (Expression<Double>)this.value(distance));
    }

    @Override
    public Predicate distanceWithin(Expression<? extends T> geometry1, Expression<? extends T> geometry2, double distance) {
        return this.distanceWithin(geometry1, (T)geometry2, (Expression<Double>)this.value(distance));
    }

    @Override
    public Predicate havingSRID(Expression<? extends T> geometry, Expression<Integer> srid) {
        return this.equal((Expression)this.function(SpatialFunction.srid.toString(), Integer.TYPE, new Expression[]{geometry}), srid);
    }

    @Override
    public Predicate havingSRID(Expression<? extends T> geometry, int srid) {
        return this.havingSRID(geometry, (Expression<Integer>)this.value(srid));
    }

    @Override
    public Predicate isGeometryEmpty(Expression<? extends T> geometry) {
        return this.equal((Expression)this.function(SpatialFunction.isempty.toString(), Boolean.TYPE, new Expression[]{geometry}), true);
    }

    @Override
    public Predicate isGeometryNotEmpty(Expression<? extends T> geometry) {
        return this.isGeometryEmpty(geometry).not();
    }
}

