/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.sqlserver;

import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.codec.Wkt;
import org.geolatte.geom.codec.db.sqlserver.Decoders;
import org.geolatte.geom.codec.db.sqlserver.Encoders;
import org.hibernate.spatial.GeometryLiteralFormatter;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class SqlServerGeometryType
implements JdbcType {
    public static final SqlServerGeometryType INSTANCE = new SqlServerGeometryType();

    public int getJdbcTypeCode() {
        return 2003;
    }

    public int getDefaultSqlTypeCode() {
        return 3200;
    }

    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaType) {
        return new GeometryLiteralFormatter<T>(javaType, Wkt.Dialect.SFA_1_2_1, "geometry::STGeomFromText");
    }

    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                Geometry geometry = (Geometry)this.getJavaType().unwrap(value, Geometry.class, options);
                byte[] bytes = Encoders.encode((Geometry)geometry);
                st.setObject(index, bytes);
            }

            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                Geometry geometry = (Geometry)this.getJavaType().unwrap(value, Geometry.class, options);
                byte[] bytes = Encoders.encode((Geometry)geometry);
                st.setObject(name, (Object)bytes);
            }
        };
    }

    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap((Object)SqlServerGeometryType.this.toGeometry(rs.getObject(paramIndex)), options);
            }

            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap((Object)SqlServerGeometryType.this.toGeometry(statement.getObject(index)), options);
            }

            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap((Object)SqlServerGeometryType.this.toGeometry(statement.getObject(name)), options);
            }
        };
    }

    private Geometry toGeometry(Object obj) {
        byte[] raw = null;
        if (obj == null) {
            return null;
        }
        if (obj instanceof byte[]) {
            raw = (byte[])obj;
        } else if (obj instanceof Blob) {
            raw = this.toByteArray((Blob)obj);
        } else {
            throw new IllegalArgumentException("Expected byte array or BLOB");
        }
        return Decoders.decode((byte[])raw);
    }

    private byte[] toByteArray(Blob blob) {
        try {
            return blob.getBytes(1L, (int)blob.length());
        }
        catch (SQLException e) {
            throw new RuntimeException("Error on transforming blob into array.", e);
        }
    }
}

