/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.mariadb;

import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.spatial.HSMessageLogger;
import org.hibernate.spatial.contributor.ContributorImplementor;
import org.hibernate.spatial.dialect.mariadb.MariaDBSqmFunctionDescriptors;
import org.hibernate.spatial.dialect.mysql.MySQLGeometryJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class MariaDBDialectContributor
implements ContributorImplementor {
    private final ServiceRegistry serviceRegistry;

    public MariaDBDialectContributor(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Override
    public void contributeJdbcTypes(TypeContributions typeContributions) {
        HSMessageLogger.SPATIAL_MSG_LOGGER.typeContributions(this.getClass().getCanonicalName());
        typeContributions.contributeJdbcType((JdbcType)MySQLGeometryJdbcType.INSTANCE);
    }

    @Override
    public void contributeFunctions(FunctionContributions functionContributions) {
        HSMessageLogger.SPATIAL_MSG_LOGGER.functionContributions(this.getClass().getCanonicalName());
        MariaDBSqmFunctionDescriptors mariaDbFunctions = new MariaDBSqmFunctionDescriptors(functionContributions);
        SqmFunctionRegistry functionRegistry = functionContributions.getFunctionRegistry();
        mariaDbFunctions.asMap().forEach((key, desc) -> {
            functionRegistry.register(key.getName(), desc);
            key.getAltName().ifPresent(altName -> functionRegistry.registerAlternateKey(altName, key.getName()));
        });
    }

    @Override
    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }
}

