/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial;

import java.util.Locale;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.jts.JTS;
import org.geolatte.geom.jts.JTSUtils;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class JTSGeometryJavaType
extends AbstractJavaType<org.locationtech.jts.geom.Geometry> {
    public static final JTSGeometryJavaType GEOMETRY_INSTANCE = new JTSGeometryJavaType(org.locationtech.jts.geom.Geometry.class);
    public static final JTSGeometryJavaType POINT_INSTANCE = new JTSGeometryJavaType(Point.class);
    public static final JTSGeometryJavaType LINESTRING_INSTANCE = new JTSGeometryJavaType(LineString.class);
    public static final JTSGeometryJavaType POLYGON_INSTANCE = new JTSGeometryJavaType(Polygon.class);
    public static final JTSGeometryJavaType GEOMETRYCOLL_INSTANCE = new JTSGeometryJavaType(GeometryCollection.class);
    public static final JTSGeometryJavaType MULTIPOINT_INSTANCE = new JTSGeometryJavaType(MultiPoint.class);
    public static final JTSGeometryJavaType MULTILINESTRING_INSTANCE = new JTSGeometryJavaType(MultiLineString.class);
    public static final JTSGeometryJavaType MULTIPOLYGON_INSTANCE = new JTSGeometryJavaType(MultiPolygon.class);

    public JTSGeometryJavaType(Class<? extends org.locationtech.jts.geom.Geometry> type) {
        super(type);
    }

    public String toString(org.locationtech.jts.geom.Geometry value) {
        return value.toText();
    }

    public org.locationtech.jts.geom.Geometry fromString(CharSequence string) {
        WKTReader reader = new WKTReader();
        try {
            return reader.read(string.toString());
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format(Locale.ENGLISH, "Can't parse string %s as WKT", string));
        }
    }

    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators indicators) {
        return indicators.getTypeConfiguration().getJdbcTypeRegistry().getDescriptor(3200);
    }

    public boolean areEqual(org.locationtech.jts.geom.Geometry one, org.locationtech.jts.geom.Geometry another) {
        return JTSUtils.equalsExact3D((org.locationtech.jts.geom.Geometry)one, (org.locationtech.jts.geom.Geometry)another);
    }

    public <X> X unwrap(org.locationtech.jts.geom.Geometry value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (org.locationtech.jts.geom.Geometry.class.isAssignableFrom(type)) {
            return (X)value;
        }
        if (Geometry.class.isAssignableFrom(type)) {
            return (X)JTS.from((org.locationtech.jts.geom.Geometry)value);
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)this.toString(value);
        }
        throw this.unknownUnwrap(type);
    }

    public <X> org.locationtech.jts.geom.Geometry wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof org.locationtech.jts.geom.Geometry) {
            return (org.locationtech.jts.geom.Geometry)value;
        }
        if (value instanceof Geometry) {
            return JTS.to((Geometry)((Geometry)value));
        }
        if (value instanceof CharSequence) {
            return this.fromString((CharSequence)value);
        }
        throw this.unknownWrap(value.getClass());
    }
}

