/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial;

import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryCollection;
import org.geolatte.geom.LineString;
import org.geolatte.geom.MultiLineString;
import org.geolatte.geom.MultiPoint;
import org.geolatte.geom.MultiPolygon;
import org.geolatte.geom.Point;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.codec.Wkt;
import org.geolatte.geom.jts.JTS;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;

public class GeolatteGeometryJavaType
extends AbstractJavaType<Geometry> {
    private final Wkt.Dialect wktDialect;
    public static final GeolatteGeometryJavaType GEOMETRY_INSTANCE = new GeolatteGeometryJavaType(Geometry.class);
    public static final GeolatteGeometryJavaType POINT_INSTANCE = new GeolatteGeometryJavaType(Point.class);
    public static final GeolatteGeometryJavaType LINESTRING_INSTANCE = new GeolatteGeometryJavaType(LineString.class);
    public static final GeolatteGeometryJavaType POLYGON_INSTANCE = new GeolatteGeometryJavaType(Polygon.class);
    public static final GeolatteGeometryJavaType GEOMETRYCOLL_INSTANCE = new GeolatteGeometryJavaType(GeometryCollection.class);
    public static final GeolatteGeometryJavaType MULTIPOINT_INSTANCE = new GeolatteGeometryJavaType(MultiPoint.class);
    public static final GeolatteGeometryJavaType MULTILINESTRING_INSTANCE = new GeolatteGeometryJavaType(MultiLineString.class);
    public static final GeolatteGeometryJavaType MULTIPOLYGON_INSTANCE = new GeolatteGeometryJavaType(MultiPolygon.class);

    public GeolatteGeometryJavaType(Class<? extends Geometry> type) {
        this(type, Wkt.Dialect.SFA_1_1_0);
    }

    public GeolatteGeometryJavaType(Class<? extends Geometry> type, Wkt.Dialect wktDialect) {
        super(type);
        this.wktDialect = wktDialect;
    }

    public String toString(Geometry value) {
        return Wkt.toWkt((Geometry)value, (Wkt.Dialect)this.wktDialect);
    }

    public Geometry fromString(CharSequence string) {
        return Wkt.fromWkt((String)string.toString(), (Wkt.Dialect)this.wktDialect);
    }

    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators indicators) {
        return indicators.getTypeConfiguration().getJdbcTypeRegistry().getDescriptor(3200);
    }

    public <X> X unwrap(Geometry value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (Geometry.class.isAssignableFrom(type)) {
            return (X)value;
        }
        if (org.locationtech.jts.geom.Geometry.class.isAssignableFrom(type)) {
            return (X)JTS.to((Geometry)value);
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)this.toString(value);
        }
        throw this.unknownUnwrap(type);
    }

    public <X> Geometry wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (Geometry.class.isInstance(value)) {
            return (Geometry)value;
        }
        if (CharSequence.class.isInstance(value)) {
            return this.fromString((CharSequence)value);
        }
        if (org.locationtech.jts.geom.Geometry.class.isInstance(value)) {
            return JTS.from((org.locationtech.jts.geom.Geometry)((org.locationtech.jts.geom.Geometry)value));
        }
        throw this.unknownWrap(value.getClass());
    }
}

