
package org.hibernate.processor.xml.jaxb;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for persistence-unit-caching-type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="persistence-unit-caching-type">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}token">
 *     <enumeration value="ALL"/>
 *     <enumeration value="NONE"/>
 *     <enumeration value="ENABLE_SELECTIVE"/>
 *     <enumeration value="DISABLE_SELECTIVE"/>
 *     <enumeration value="UNSPECIFIED"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "persistence-unit-caching-type", namespace = "https://jakarta.ee/xml/ns/persistence")
@XmlEnum
public enum PersistenceUnitCachingType {

    ALL,
    NONE,
    ENABLE_SELECTIVE,
    DISABLE_SELECTIVE,
    UNSPECIFIED;

    public String value() {
        return name();
    }

    public static PersistenceUnitCachingType fromValue(String v) {
        return valueOf(v);
    }

}
