/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.validation;

import java.util.Map;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.annotations.processing.GenericDialect;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.env.internal.QualifiedObjectNameFormatterStandardImpl;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.env.spi.NameQualifierSupport;
import org.hibernate.engine.jdbc.env.spi.QualifiedObjectNameFormatter;
import org.hibernate.engine.jdbc.internal.JdbcServicesInitiator;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.processor.validation.Mocker;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;

class MockJdbcServicesInitiator
extends JdbcServicesInitiator {
    static final @UnknownKeyFor @NonNull @Initialized JdbcServicesInitiator INSTANCE = new MockJdbcServicesInitiator();
    static final @UnknownKeyFor @NonNull @Initialized JdbcServices jdbcServices = Mocker.nullary(MockJdbcServices.class).get();
    static final @UnknownKeyFor @NonNull @Initialized GenericDialect genericDialect = new GenericDialect();

    MockJdbcServicesInitiator() {
    }

    public @UnknownKeyFor @NonNull @Initialized JdbcServices initiateService(@UnknownKeyFor @NonNull @Initialized Map configurationValues, @UnknownKeyFor @NonNull @Initialized ServiceRegistryImplementor registry) {
        return jdbcServices;
    }

    public static abstract class MockJdbcServices
    implements JdbcServices,
    JdbcEnvironment {
        public @UnknownKeyFor @NonNull @Initialized Dialect getDialect() {
            return genericDialect;
        }

        public @UnknownKeyFor @NonNull @Initialized JdbcEnvironment getJdbcEnvironment() {
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
            return new StandardSqlAstTranslatorFactory();
        }

        public @UnknownKeyFor @NonNull @Initialized Identifier getCurrentCatalog() {
            return null;
        }

        public @UnknownKeyFor @NonNull @Initialized Identifier getCurrentSchema() {
            return null;
        }

        public @UnknownKeyFor @NonNull @Initialized QualifiedObjectNameFormatter getQualifiedObjectNameFormatter() {
            return new QualifiedObjectNameFormatterStandardImpl(this.getNameQualifierSupport());
        }

        public @UnknownKeyFor @NonNull @Initialized NameQualifierSupport getNameQualifierSupport() {
            return genericDialect.getNameQualifierSupport();
        }
    }
}

