
package org.hibernate.processor.xml.jaxb;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 * 
 *         @Target({}) @Retention(RUNTIME)
 *         public @interface NamedAttributeNode {
 *           String value();
 *           String subgraph() default "";
 *           String keySubgraph() default "";
 *         }
 *  
 *       
 * 
 * <p>Java class for named-attribute-node complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="named-attribute-node">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="name" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="subgraph" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="key-subgraph" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "named-attribute-node", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
public class NamedAttributeNode {

    @XmlAttribute(name = "name", required = true)
    protected String name;
    @XmlAttribute(name = "subgraph")
    protected String subgraph;
    @XmlAttribute(name = "key-subgraph")
    protected String keySubgraph;

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setName(String value) {
        this.name = value;
    }

    /**
     * Gets the value of the subgraph property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSubgraph() {
        return subgraph;
    }

    /**
     * Sets the value of the subgraph property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSubgraph(String value) {
        this.subgraph = value;
    }

    /**
     * Gets the value of the keySubgraph property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getKeySubgraph() {
        return keySubgraph;
    }

    /**
     * Sets the value of the keySubgraph property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setKeySubgraph(String value) {
        this.keySubgraph = value;
    }

}
