/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.processor.model.MetaAttribute;
import org.hibernate.processor.model.Metamodel;
import org.hibernate.processor.util.StringUtil;

class NameMetaAttribute
implements MetaAttribute {
    private final @UnknownKeyFor @NonNull @Initialized Metamodel annotationMetaEntity;
    private final @UnknownKeyFor @NonNull @Initialized String name;
    private final @UnknownKeyFor @NonNull @Initialized String prefix;

    public NameMetaAttribute(@UnknownKeyFor @NonNull @Initialized Metamodel annotationMetaEntity, @UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized String prefix) {
        this.annotationMetaEntity = annotationMetaEntity;
        this.name = name;
        this.prefix = prefix;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean hasTypedAttribute() {
        return false;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean hasStringAttribute() {
        return true;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getAttributeDeclarationString() {
        throw new UnsupportedOperationException("operation not supported");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getAttributeNameDeclarationString() {
        StringBuilder declaration = new StringBuilder();
        if (!this.annotationMetaEntity.isJakartaDataStyle()) {
            declaration.append("public static final ");
        }
        return declaration.append(this.annotationMetaEntity.importType(String.class.getName())).append(" ").append(this.prefix).append(this.fieldName()).append(" = ").append("\"").append(this.name).append("\"").append(";").toString();
    }

    private @UnknownKeyFor @NonNull @Initialized String fieldName() {
        return StringUtil.nameToFieldName(this.name.charAt(0) == '#' ? this.name.substring(1) : this.name);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getMetaType() {
        throw new UnsupportedOperationException("operation not supported");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getPropertyName() {
        return this.name;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getTypeDeclaration() {
        return "java.lang.String";
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Metamodel getHostingEntity() {
        return this.annotationMetaEntity;
    }
}

