/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import java.util.List;
import javax.lang.model.element.ExecutableElement;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.processor.annotation.AbstractCriteriaMethod;
import org.hibernate.processor.annotation.AnnotationMetaEntity;
import org.hibernate.processor.annotation.OrderBy;

public class CriteriaFinderMethod
extends AbstractCriteriaMethod {
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Boolean> paramNullability;

    CriteriaFinderMethod(@UnknownKeyFor @NonNull @Initialized AnnotationMetaEntity annotationMetaEntity, @UnknownKeyFor @NonNull @Initialized ExecutableElement method, @UnknownKeyFor @NonNull @Initialized String methodName, @UnknownKeyFor @NonNull @Initialized String entity, @Nullable @UnknownKeyFor @Initialized String containerType, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramNames, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Boolean> paramNullability, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Boolean> multivalued, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Boolean> paramPatterns, @UnknownKeyFor @NonNull @Initialized boolean belongsToDao, @UnknownKeyFor @NonNull @Initialized String sessionType, @UnknownKeyFor @NonNull @Initialized String sessionName, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> fetchProfiles, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized OrderBy> orderBys, @UnknownKeyFor @NonNull @Initialized boolean addNonnullAnnotation, @UnknownKeyFor @NonNull @Initialized boolean dataRepository, @UnknownKeyFor @NonNull @Initialized String fullReturnType, @UnknownKeyFor @NonNull @Initialized boolean nullable) {
        super(annotationMetaEntity, method, methodName, entity, containerType, belongsToDao, sessionType, sessionName, fetchProfiles, paramNames, paramTypes, orderBys, addNonnullAnnotation, dataRepository, multivalued, paramPatterns, fullReturnType, nullable);
        this.paramNullability = paramNullability;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isNullable(@UnknownKeyFor @NonNull @Initialized int index) {
        return this.paramNullability.get(index);
    }

    @Override
    @UnknownKeyFor @NonNull @Initialized boolean singleResult() {
        return this.containerType == null;
    }

    @Override
    void executeQuery(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes) {
        declaration.append('\n');
        this.collectOrdering(declaration, paramTypes);
        this.tryReturn(declaration, paramTypes, this.containerType);
        this.castResult(declaration);
        this.createQuery(declaration);
        this.handlePageParameters(declaration, paramTypes, this.containerType);
        boolean unwrapped = !this.isUsingEntityManager();
        unwrapped = this.enableFetchProfile(declaration, unwrapped);
        unwrapped = this.applyOrder(declaration, paramTypes, this.containerType, unwrapped);
        this.execute(declaration, paramTypes, unwrapped);
    }

    private void castResult(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        if (this.containerType == null && !this.fetchProfiles.isEmpty() && this.isUsingEntityManager()) {
            declaration.append("(").append(this.annotationMetaEntity.importType(this.entity)).append(") ");
        }
    }

    private void execute(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes, @UnknownKeyFor @NonNull @Initialized boolean unwrapped) {
        this.executeSelect(declaration, paramTypes, this.containerType, unwrapped, CriteriaFinderMethod.isHibernateQueryType(this.containerType));
    }

    @Override
    @UnknownKeyFor @NonNull @Initialized String createQueryMethod() {
        return this.isUsingEntityManager() || this.isReactive() || CriteriaFinderMethod.isUnspecializedQueryType(this.containerType) ? "createQuery" : "createSelectionQuery";
    }

    @Override
    @UnknownKeyFor @NonNull @Initialized String createCriteriaMethod() {
        return "createQuery";
    }
}

