/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen.validation;

import jakarta.persistence.AccessType;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.jpamodelgen.validation.MockCollectionPersister;
import org.hibernate.jpamodelgen.validation.MockEntityPersister;
import org.hibernate.jpamodelgen.validation.MockSessionFactory;
import org.hibernate.jpamodelgen.validation.Mocker;
import org.hibernate.type.BasicType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.EnumJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.IntegerJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.VarcharJdbcType;
import org.hibernate.type.internal.BasicTypeImpl;

public abstract class ProcessorSessionFactory
extends MockSessionFactory {
    static final @UnknownKeyFor @NonNull @Initialized Mocker<@UnknownKeyFor @NonNull @Initialized ProcessorSessionFactory> instance = Mocker.variadic(ProcessorSessionFactory.class);
    private static final @UnknownKeyFor @NonNull @Initialized Mocker<@UnknownKeyFor @NonNull @Initialized Component> component = Mocker.variadic(Component.class);
    private static final @UnknownKeyFor @NonNull @Initialized Mocker<@UnknownKeyFor @NonNull @Initialized ToManyAssociationPersister> toManyPersister = Mocker.variadic(ToManyAssociationPersister.class);
    private static final @UnknownKeyFor @NonNull @Initialized Mocker<@UnknownKeyFor @NonNull @Initialized ElementCollectionPersister> collectionPersister = Mocker.variadic(ElementCollectionPersister.class);
    private static final @UnknownKeyFor @NonNull @Initialized Mocker<@UnknownKeyFor @NonNull @Initialized EntityPersister> entityPersister = Mocker.variadic(EntityPersister.class);
    private static final @UnknownKeyFor @NonNull @Initialized CharSequence jakartaPersistence = new StringBuilder("jakarta").append('.').append("persistence");
    private static final @UnknownKeyFor @NonNull @Initialized CharSequence javaxPersistence = new StringBuilder("javax").append('.').append("persistence");
    private final @UnknownKeyFor @NonNull @Initialized Elements elementUtil;
    private final @UnknownKeyFor @NonNull @Initialized Types typeUtil;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TypeElement> entityCache = new HashMap<String, TypeElement>();

    public static @UnknownKeyFor @NonNull @Initialized MockSessionFactory create(@UnknownKeyFor @NonNull @Initialized ProcessingEnvironment environment) {
        return instance.make(environment);
    }

    public ProcessorSessionFactory(@UnknownKeyFor @NonNull @Initialized ProcessingEnvironment processingEnv) {
        this.elementUtil = processingEnv.getElementUtils();
        this.typeUtil = processingEnv.getTypeUtils();
    }

    @Override
    @UnknownKeyFor @NonNull @Initialized MockEntityPersister createMockEntityPersister(@UnknownKeyFor @NonNull @Initialized String entityName) {
        TypeElement type = this.findEntityClass(entityName);
        return type == null ? null : (MockEntityPersister)entityPersister.make(entityName, type, this);
    }

    @Override
    @UnknownKeyFor @NonNull @Initialized MockCollectionPersister createMockCollectionPersister(@UnknownKeyFor @NonNull @Initialized String role) {
        String entityName = StringHelper.root((String)role);
        String propertyPath = StringHelper.unroot((String)role);
        TypeElement entityClass = this.findEntityClass(entityName);
        AccessType defaultAccessType = ProcessorSessionFactory.getDefaultAccessType(entityClass);
        Element property = ProcessorSessionFactory.findPropertyByPath(entityClass, propertyPath, defaultAccessType);
        CollectionType collectionType = ProcessorSessionFactory.collectionType(ProcessorSessionFactory.memberType(property), role);
        if (ProcessorSessionFactory.isToManyAssociation(property)) {
            return toManyPersister.make(role, collectionType, this.getToManyTargetEntityName(property), this);
        }
        if (ProcessorSessionFactory.isElementCollectionProperty(property)) {
            Element elementType = ProcessorSessionFactory.asElement(this.getElementCollectionElementType(property));
            return collectionPersister.make(role, collectionType, elementType, propertyPath, defaultAccessType, this);
        }
        return null;
    }

    @Override
    @UnknownKeyFor @NonNull @Initialized Type propertyType(@UnknownKeyFor @NonNull @Initialized String typeName, @UnknownKeyFor @NonNull @Initialized String propertyPath) {
        AccessType accessType;
        TypeElement type = this.findClassByQualifiedName(typeName);
        Element propertyByPath = ProcessorSessionFactory.findPropertyByPath(type, propertyPath, accessType = ProcessorSessionFactory.getAccessType(type, AccessType.FIELD));
        return propertyByPath == null ? null : ProcessorSessionFactory.propertyType(propertyByPath, typeName, propertyPath, accessType);
    }

    private static @UnknownKeyFor @NonNull @Initialized Element findPropertyByPath(@UnknownKeyFor @NonNull @Initialized TypeElement type, @UnknownKeyFor @NonNull @Initialized String propertyPath, @UnknownKeyFor @NonNull @Initialized AccessType defaultAccessType) {
        return Arrays.stream(StringHelper.split((String)".", (String)propertyPath)).reduce(type, (symbol, segment) -> ProcessorSessionFactory.dereference(defaultAccessType, symbol, segment), (last, current) -> current);
    }

    private static @UnknownKeyFor @NonNull @Initialized Element dereference(@UnknownKeyFor @NonNull @Initialized AccessType defaultAccessType, @UnknownKeyFor @NonNull @Initialized Element symbol, @UnknownKeyFor @NonNull @Initialized String segment) {
        if (symbol == null) {
            return null;
        }
        Element element = ProcessorSessionFactory.asElement(symbol.asType());
        return element instanceof TypeElement ? ProcessorSessionFactory.findProperty((TypeElement)element, segment, defaultAccessType) : null;
    }

    static @UnknownKeyFor @NonNull @Initialized Type propertyType(@UnknownKeyFor @NonNull @Initialized Element member, @UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized String path, @UnknownKeyFor @NonNull @Initialized AccessType defaultAccessType) {
        TypeMirror memberType = ProcessorSessionFactory.memberType(member);
        if (ProcessorSessionFactory.isEmbeddedProperty(member)) {
            return (Type)component.make(ProcessorSessionFactory.asElement(memberType), entityName, path, defaultAccessType);
        }
        if (ProcessorSessionFactory.isToOneAssociation(member)) {
            return new ManyToOneType(typeConfiguration, ProcessorSessionFactory.getToOneTargetEntity(member));
        }
        if (ProcessorSessionFactory.isToManyAssociation(member)) {
            return ProcessorSessionFactory.collectionType(memberType, StringHelper.qualify((String)entityName, (String)path));
        }
        if (ProcessorSessionFactory.isElementCollectionProperty(member)) {
            return ProcessorSessionFactory.collectionType(memberType, StringHelper.qualify((String)entityName, (String)path));
        }
        if (ProcessorSessionFactory.isEnumProperty(member)) {
            return ProcessorSessionFactory.enumType(member, memberType);
        }
        return typeConfiguration.getBasicTypeRegistry().getRegisteredType(ProcessorSessionFactory.qualifiedName(memberType));
    }

    private static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized BasicType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> enumType(@UnknownKeyFor @NonNull @Initialized Element member, @UnknownKeyFor @NonNull @Initialized TypeMirror memberType) {
        Class<Enum> enumClass = Enum.class;
        return ProcessorSessionFactory.enumType(member, ProcessorSessionFactory.qualifiedName(memberType), enumClass);
    }

    private static <T extends Enum<T>> @UnknownKeyFor @NonNull @Initialized BasicType<T> enumType(@UnknownKeyFor @NonNull @Initialized Element member, final @UnknownKeyFor @NonNull @Initialized String typeName, @UnknownKeyFor @NonNull @Initialized Class<T> enumClass) {
        EnumJavaType javaType = new EnumJavaType<T>(enumClass){

            public String getTypeName() {
                return typeName;
            }
        };
        return new BasicTypeImpl<T>((JavaType)javaType, ProcessorSessionFactory.enumJdbcType(member)){

            public String getTypeName() {
                return typeName;
            }
        };
    }

    private static @UnknownKeyFor @NonNull @Initialized JdbcType enumJdbcType(@UnknownKeyFor @NonNull @Initialized Element member) {
        VariableElement mapping = (VariableElement)ProcessorSessionFactory.getAnnotationMember(ProcessorSessionFactory.getAnnotation(member, "Enumerated"), "value");
        return mapping != null && mapping.getSimpleName().contentEquals("STRING") ? VarcharJdbcType.INSTANCE : IntegerJdbcType.INSTANCE;
    }

    private static @UnknownKeyFor @NonNull @Initialized Type elementCollectionElementType(@UnknownKeyFor @NonNull @Initialized TypeElement elementType, @UnknownKeyFor @NonNull @Initialized String role, @UnknownKeyFor @NonNull @Initialized String path, @UnknownKeyFor @NonNull @Initialized AccessType defaultAccessType) {
        if (ProcessorSessionFactory.isEmbeddableType(elementType)) {
            return (Type)component.make(elementType, role, path, defaultAccessType);
        }
        return typeConfiguration.getBasicTypeRegistry().getRegisteredType(ProcessorSessionFactory.qualifiedName(elementType.asType()));
    }

    private static @UnknownKeyFor @NonNull @Initialized CollectionType collectionType(@UnknownKeyFor @NonNull @Initialized TypeMirror type, @UnknownKeyFor @NonNull @Initialized String role) {
        return ProcessorSessionFactory.createCollectionType(role, ProcessorSessionFactory.simpleName(type));
    }

    @Override
    @UnknownKeyFor @NonNull @Initialized boolean isEntityDefined(@UnknownKeyFor @NonNull @Initialized String entityName) {
        return this.findEntityClass(entityName) != null;
    }

    @Override
    @UnknownKeyFor @NonNull @Initialized String qualifyName(@UnknownKeyFor @NonNull @Initialized String entityName) {
        TypeElement entityClass = this.findEntityClass(entityName);
        return entityClass == null ? null : entityClass.getSimpleName().toString();
    }

    @Override
    @UnknownKeyFor @NonNull @Initialized boolean isAttributeDefined(@UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized String fieldName) {
        TypeElement entityClass = this.findEntityClass(entityName);
        return entityClass != null && ProcessorSessionFactory.findPropertyByPath(entityClass, fieldName, ProcessorSessionFactory.getDefaultAccessType(entityClass)) != null;
    }

    private @UnknownKeyFor @NonNull @Initialized TypeElement findEntityClass(@UnknownKeyFor @NonNull @Initialized String entityName) {
        if (entityName == null) {
            return null;
        }
        if (entityName.indexOf(46) > 0) {
            return this.findEntityByQualifiedName(entityName);
        }
        return this.findEntityByUnqualifiedName(entityName);
    }

    private @UnknownKeyFor @NonNull @Initialized TypeElement findEntityByQualifiedName(@UnknownKeyFor @NonNull @Initialized String entityName) {
        TypeElement type = this.findClassByQualifiedName(entityName);
        return type != null && ProcessorSessionFactory.isEntity(type) ? type : null;
    }

    private @UnknownKeyFor @NonNull @Initialized TypeElement findEntityByUnqualifiedName(@UnknownKeyFor @NonNull @Initialized String entityName) {
        TypeElement cached = this.entityCache.get(entityName);
        if (cached != null) {
            return cached;
        }
        TypeElement symbol = ProcessorSessionFactory.findEntityByUnqualifiedName(entityName, this.elementUtil.getModuleElement(""));
        if (symbol != null) {
            this.entityCache.put(entityName, symbol);
            return symbol;
        }
        for (ModuleElement moduleElement : this.elementUtil.getAllModuleElements()) {
            symbol = ProcessorSessionFactory.findEntityByUnqualifiedName(entityName, moduleElement);
            if (symbol == null) continue;
            this.entityCache.put(entityName, symbol);
            return symbol;
        }
        return null;
    }

    public static @UnknownKeyFor @NonNull @Initialized TypeElement findEntityByUnqualifiedName(@UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized ModuleElement module) {
        for (Element element : module.getEnclosedElements()) {
            if (element.getKind() != ElementKind.PACKAGE) continue;
            PackageElement pack = (PackageElement)element;
            try {
                for (Element element2 : pack.getEnclosedElements()) {
                    if (!ProcessorSessionFactory.isMatchingEntity(element2, entityName)) continue;
                    return (TypeElement)element2;
                }
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isMatchingEntity(@UnknownKeyFor @NonNull @Initialized Element symbol, @UnknownKeyFor @NonNull @Initialized String entityName) {
        if (symbol.getKind() == ElementKind.CLASS) {
            TypeElement type = (TypeElement)symbol;
            return ProcessorSessionFactory.isEntity(type) && ProcessorSessionFactory.getEntityName(type).equals(entityName);
        }
        return false;
    }

    private static @UnknownKeyFor @NonNull @Initialized Element findProperty(@UnknownKeyFor @NonNull @Initialized TypeElement type, @UnknownKeyFor @NonNull @Initialized String propertyName, @UnknownKeyFor @NonNull @Initialized AccessType defaultAccessType) {
        while (type != null) {
            if (ProcessorSessionFactory.isMappedClass(type)) {
                AccessType accessType = ProcessorSessionFactory.getAccessType(type, defaultAccessType);
                for (Element element : type.getEnclosedElements()) {
                    if (!ProcessorSessionFactory.isMatchingProperty(element, propertyName, accessType)) continue;
                    return element;
                }
            }
            type = (TypeElement)ProcessorSessionFactory.asElement(type.getSuperclass());
        }
        return null;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isMatchingProperty(@UnknownKeyFor @NonNull @Initialized Element symbol, @UnknownKeyFor @NonNull @Initialized String propertyName, @UnknownKeyFor @NonNull @Initialized AccessType accessType) {
        return ProcessorSessionFactory.isPersistable(symbol, accessType) && propertyName.equals(ProcessorSessionFactory.propertyName(symbol));
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isGetterMethod(@UnknownKeyFor @NonNull @Initialized ExecutableElement method) {
        if (!method.getParameters().isEmpty()) {
            return false;
        }
        Name methodName = method.getSimpleName();
        TypeMirror returnType = method.getReturnType();
        return methodName.subSequence(0, 3).toString().equals("get") && returnType.getKind() != TypeKind.VOID || methodName.subSequence(0, 2).toString().equals("is") && returnType.getKind() == TypeKind.BOOLEAN;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean hasAnnotation(@UnknownKeyFor @NonNull @Initialized TypeMirror type, @UnknownKeyFor @NonNull @Initialized String annotationName) {
        return type.getKind() == TypeKind.DECLARED && ProcessorSessionFactory.getAnnotation(((DeclaredType)type).asElement(), annotationName) != null;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean hasAnnotation(@UnknownKeyFor @NonNull @Initialized Element member, @UnknownKeyFor @NonNull @Initialized String annotationName) {
        return ProcessorSessionFactory.getAnnotation(member, annotationName) != null;
    }

    private static @UnknownKeyFor @NonNull @Initialized AnnotationMirror getAnnotation(@UnknownKeyFor @NonNull @Initialized Element member, @UnknownKeyFor @NonNull @Initialized String annotationName) {
        for (AnnotationMirror annotationMirror : member.getAnnotationMirrors()) {
            PackageElement pack;
            Name packageName;
            TypeElement annotationType = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!annotationType.getSimpleName().contentEquals(annotationName) || annotationType.getNestingKind() != NestingKind.TOP_LEVEL || !(packageName = (pack = (PackageElement)annotationType.getEnclosingElement()).getQualifiedName()).contentEquals(jakartaPersistence) && !packageName.contentEquals(javaxPersistence)) continue;
            return annotationMirror;
        }
        return null;
    }

    private static @UnknownKeyFor @NonNull @Initialized Object getAnnotationMember(@UnknownKeyFor @NonNull @Initialized AnnotationMirror annotation, @UnknownKeyFor @NonNull @Initialized String memberName) {
        if (annotation == null) {
            return null;
        }
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotation.getElementValues().entrySet()) {
            if (!entry.getKey().getSimpleName().contentEquals(memberName)) continue;
            return entry.getValue().getValue();
        }
        return null;
    }

    static @UnknownKeyFor @NonNull @Initialized boolean isMappedClass(@UnknownKeyFor @NonNull @Initialized TypeElement type) {
        return ProcessorSessionFactory.hasAnnotation(type, "Entity") || ProcessorSessionFactory.hasAnnotation(type, "Embeddable") || ProcessorSessionFactory.hasAnnotation(type, "MappedSuperclass");
    }

    static @UnknownKeyFor @NonNull @Initialized boolean isEntity(@UnknownKeyFor @NonNull @Initialized TypeElement member) {
        return member.getKind() == ElementKind.CLASS && ProcessorSessionFactory.hasAnnotation(member, "Entity");
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isId(@UnknownKeyFor @NonNull @Initialized Element member) {
        return ProcessorSessionFactory.hasAnnotation(member, "Id");
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isStatic(@UnknownKeyFor @NonNull @Initialized Element member) {
        return member.getModifiers().contains((Object)Modifier.STATIC);
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isTransient(@UnknownKeyFor @NonNull @Initialized Element member) {
        return ProcessorSessionFactory.hasAnnotation(member, "Transient") || member.getModifiers().contains((Object)Modifier.TRANSIENT);
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isEnumProperty(@UnknownKeyFor @NonNull @Initialized Element member) {
        if (ProcessorSessionFactory.hasAnnotation(member, "Enumerated")) {
            return true;
        }
        TypeMirror type = member.asType();
        if (type.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)type;
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            return typeElement.getKind() == ElementKind.ENUM;
        }
        return false;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isEmbeddableType(@UnknownKeyFor @NonNull @Initialized TypeElement type) {
        return ProcessorSessionFactory.hasAnnotation(type, "Embeddable");
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isEmbeddedProperty(@UnknownKeyFor @NonNull @Initialized Element member) {
        if (ProcessorSessionFactory.hasAnnotation(member, "Embedded")) {
            return true;
        }
        TypeMirror type = member.asType();
        return type.getKind() == TypeKind.DECLARED && ProcessorSessionFactory.hasAnnotation(type, "Embeddable");
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isElementCollectionProperty(@UnknownKeyFor @NonNull @Initialized Element member) {
        return ProcessorSessionFactory.hasAnnotation(member, "ElementCollection");
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isToOneAssociation(@UnknownKeyFor @NonNull @Initialized Element member) {
        return ProcessorSessionFactory.hasAnnotation(member, "ManyToOne") || ProcessorSessionFactory.hasAnnotation(member, "OneToOne");
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isToManyAssociation(@UnknownKeyFor @NonNull @Initialized Element member) {
        return ProcessorSessionFactory.hasAnnotation(member, "ManyToMany") || ProcessorSessionFactory.hasAnnotation(member, "OneToMany");
    }

    private static @UnknownKeyFor @NonNull @Initialized AnnotationMirror toOneAnnotation(@UnknownKeyFor @NonNull @Initialized Element member) {
        AnnotationMirror manyToOne = ProcessorSessionFactory.getAnnotation(member, "ManyToOne");
        if (manyToOne != null) {
            return manyToOne;
        }
        AnnotationMirror oneToOne = ProcessorSessionFactory.getAnnotation(member, "OneToOne");
        if (oneToOne != null) {
            return oneToOne;
        }
        return null;
    }

    private static @UnknownKeyFor @NonNull @Initialized AnnotationMirror toManyAnnotation(@UnknownKeyFor @NonNull @Initialized Element member) {
        AnnotationMirror manyToMany = ProcessorSessionFactory.getAnnotation(member, "ManyToMany");
        if (manyToMany != null) {
            return manyToMany;
        }
        AnnotationMirror oneToMany = ProcessorSessionFactory.getAnnotation(member, "OneToMany");
        if (oneToMany != null) {
            return oneToMany;
        }
        return null;
    }

    private static @UnknownKeyFor @NonNull @Initialized String simpleName(@UnknownKeyFor @NonNull @Initialized TypeMirror type) {
        return type.getKind() == TypeKind.DECLARED ? ProcessorSessionFactory.simpleName(ProcessorSessionFactory.asElement(type)) : type.toString();
    }

    private static @UnknownKeyFor @NonNull @Initialized String qualifiedName(@UnknownKeyFor @NonNull @Initialized TypeMirror type) {
        return type.getKind() == TypeKind.DECLARED ? ProcessorSessionFactory.qualifiedName(ProcessorSessionFactory.asElement(type)) : type.toString();
    }

    private static @UnknownKeyFor @NonNull @Initialized String simpleName(@UnknownKeyFor @NonNull @Initialized Element type) {
        return type.getSimpleName().toString();
    }

    private static @UnknownKeyFor @NonNull @Initialized String qualifiedName(@UnknownKeyFor @NonNull @Initialized Element type) {
        if (type instanceof PackageElement) {
            return ((PackageElement)type).getQualifiedName().toString();
        }
        if (type instanceof TypeElement) {
            return ((TypeElement)type).getQualifiedName().toString();
        }
        Element enclosingElement = type.getEnclosingElement();
        return enclosingElement != null ? ProcessorSessionFactory.qualifiedName(enclosingElement) + "." + ProcessorSessionFactory.simpleName(type) : ProcessorSessionFactory.simpleName(type);
    }

    private static @UnknownKeyFor @NonNull @Initialized AccessType getAccessType(@UnknownKeyFor @NonNull @Initialized TypeElement type, @UnknownKeyFor @NonNull @Initialized AccessType defaultAccessType) {
        AnnotationMirror annotation = ProcessorSessionFactory.getAnnotation(type, "Access");
        if (annotation == null) {
            return defaultAccessType;
        }
        VariableElement member = (VariableElement)ProcessorSessionFactory.getAnnotationMember(annotation, "value");
        if (member == null) {
            return defaultAccessType;
        }
        switch (member.getSimpleName().toString()) {
            case "PROPERTY": {
                return AccessType.PROPERTY;
            }
            case "FIELD": {
                return AccessType.FIELD;
            }
        }
        throw new IllegalStateException();
    }

    static @UnknownKeyFor @NonNull @Initialized String getEntityName(@UnknownKeyFor @NonNull @Initialized TypeElement type) {
        if (type == null) {
            return null;
        }
        AnnotationMirror entityAnnotation = ProcessorSessionFactory.getAnnotation(type, "Entity");
        if (entityAnnotation == null) {
            return null;
        }
        String name = (String)ProcessorSessionFactory.getAnnotationMember(entityAnnotation, "name");
        return name == null ? ProcessorSessionFactory.simpleName(type) : name;
    }

    private @UnknownKeyFor @NonNull @Initialized TypeMirror getCollectionElementType(@UnknownKeyFor @NonNull @Initialized Element property) {
        DeclaredType declaredType = (DeclaredType)ProcessorSessionFactory.memberType(property);
        List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
        TypeMirror elementType = typeArguments.get(typeArguments.size() - 1);
        return elementType == null ? this.elementUtil.getTypeElement("java.lang.Object").asType() : elementType;
    }

    private static @UnknownKeyFor @NonNull @Initialized String getToOneTargetEntity(@UnknownKeyFor @NonNull @Initialized Element property) {
        AnnotationMirror annotation = ProcessorSessionFactory.toOneAnnotation(property);
        TypeMirror classType = (TypeMirror)ProcessorSessionFactory.getAnnotationMember(annotation, "targetEntity");
        TypeMirror targetType = classType == null || classType.getKind() == TypeKind.VOID ? ProcessorSessionFactory.memberType(property) : classType;
        Element element = ProcessorSessionFactory.asElement(targetType);
        return element != null && element.getKind() == ElementKind.CLASS ? ProcessorSessionFactory.getEntityName((TypeElement)element) : null;
    }

    private @UnknownKeyFor @NonNull @Initialized String getToManyTargetEntityName(@UnknownKeyFor @NonNull @Initialized Element property) {
        AnnotationMirror annotation = ProcessorSessionFactory.toManyAnnotation(property);
        TypeMirror classType = (TypeMirror)ProcessorSessionFactory.getAnnotationMember(annotation, "targetEntity");
        TypeMirror targetType = classType == null || classType.getKind() == TypeKind.VOID ? this.getCollectionElementType(property) : classType;
        Element element = ProcessorSessionFactory.asElement(targetType);
        return element != null && element.getKind() == ElementKind.CLASS ? ProcessorSessionFactory.getEntityName((TypeElement)element) : null;
    }

    private @UnknownKeyFor @NonNull @Initialized TypeMirror getElementCollectionElementType(@UnknownKeyFor @NonNull @Initialized Element property) {
        AnnotationMirror annotation = ProcessorSessionFactory.getAnnotation(property, "ElementCollection");
        TypeMirror classType = (TypeMirror)ProcessorSessionFactory.getAnnotationMember(annotation, "getElementCollectionClass");
        return classType == null || classType.getKind() == TypeKind.VOID ? this.getCollectionElementType(property) : classType;
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized String getSupertype(@UnknownKeyFor @NonNull @Initialized String entityName) {
        return ProcessorSessionFactory.asElement(this.findEntityClass(entityName).getSuperclass()).getSimpleName().toString();
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized boolean isSubtype(@UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized String subtypeEntityName) {
        return this.typeUtil.isSubtype(this.findEntityClass(entityName).asType(), this.findEntityClass(subtypeEntityName).asType());
    }

    @Override
    @UnknownKeyFor @NonNull @Initialized boolean isClassDefined(@UnknownKeyFor @NonNull @Initialized String qualifiedName) {
        return this.findClassByQualifiedName(qualifiedName) != null;
    }

    @Override
    @UnknownKeyFor @NonNull @Initialized boolean isFieldDefined(@UnknownKeyFor @NonNull @Initialized String qualifiedClassName, @UnknownKeyFor @NonNull @Initialized String fieldName) {
        TypeElement type = this.findClassByQualifiedName(qualifiedClassName);
        return type != null && type.getEnclosedElements().stream().anyMatch(element -> element.getKind() == ElementKind.FIELD && element.getSimpleName().contentEquals(fieldName));
    }

    @Override
    @UnknownKeyFor @NonNull @Initialized boolean isConstructorDefined(@UnknownKeyFor @NonNull @Initialized String qualifiedClassName, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Type> argumentTypes) {
        TypeElement symbol = this.findClassByQualifiedName(qualifiedClassName);
        if (symbol == null) {
            return false;
        }
        for (Element element : symbol.getEnclosedElements()) {
            ExecutableElement constructor;
            List<? extends VariableElement> parameters;
            if (element.getKind() != ElementKind.CONSTRUCTOR || (parameters = (constructor = (ExecutableElement)element).getParameters()).size() != argumentTypes.size()) continue;
            boolean argumentsCheckOut = true;
            for (int i = 0; i < argumentTypes.size(); ++i) {
                TypeElement typeClass;
                Type type = argumentTypes.get(i);
                VariableElement param = parameters.get(i);
                if (param.asType().getKind().isPrimitive()) {
                    Class<?> primitive;
                    try {
                        primitive = ProcessorSessionFactory.toPrimitiveClass(type.getReturnedClass());
                    }
                    catch (Exception e) {
                        continue;
                    }
                    if (ProcessorSessionFactory.toPrimitiveClass(param).equals(primitive)) continue;
                    argumentsCheckOut = false;
                    break;
                }
                if (type instanceof EntityType) {
                    EntityType entityType = (EntityType)type;
                    String entityName = entityType.getAssociatedEntityName();
                    typeClass = this.findEntityClass(entityName);
                } else {
                    String className;
                    if (!(type instanceof BasicType)) continue;
                    try {
                        className = type.getReturnedClass().getName();
                    }
                    catch (Exception e) {
                        continue;
                    }
                    typeClass = this.findClassByQualifiedName(className);
                }
                if (typeClass == null || this.typeUtil.isSubtype(typeClass.asType(), param.asType())) continue;
                argumentsCheckOut = false;
                break;
            }
            if (!argumentsCheckOut) continue;
            return true;
        }
        return false;
    }

    private static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> toPrimitiveClass(@UnknownKeyFor @NonNull @Initialized VariableElement param) {
        switch (param.asType().getKind()) {
            case BOOLEAN: {
                return Boolean.TYPE;
            }
            case CHAR: {
                return Character.TYPE;
            }
            case INT: {
                return Integer.TYPE;
            }
            case SHORT: {
                return Short.TYPE;
            }
            case BYTE: {
                return Byte.TYPE;
            }
            case LONG: {
                return Long.TYPE;
            }
            case FLOAT: {
                return Float.TYPE;
            }
            case DOUBLE: {
                return Double.TYPE;
            }
        }
        return Object.class;
    }

    private @UnknownKeyFor @NonNull @Initialized TypeElement findClassByQualifiedName(@UnknownKeyFor @NonNull @Initialized String path) {
        return path == null ? null : this.elementUtil.getTypeElement(path);
    }

    private static @UnknownKeyFor @NonNull @Initialized AccessType getDefaultAccessType(@UnknownKeyFor @NonNull @Initialized TypeElement type) {
        while (type != null) {
            for (Element element : type.getEnclosedElements()) {
                if (!ProcessorSessionFactory.isId(element)) continue;
                return element instanceof ExecutableElement ? AccessType.PROPERTY : AccessType.FIELD;
            }
            type = (TypeElement)ProcessorSessionFactory.asElement(type.getSuperclass());
        }
        return AccessType.FIELD;
    }

    private static @UnknownKeyFor @NonNull @Initialized String propertyName(@UnknownKeyFor @NonNull @Initialized Element symbol) {
        String name = symbol.getSimpleName().toString();
        if (symbol.getKind() == ElementKind.METHOD) {
            if (name.startsWith("get")) {
                name = name.substring(3);
            } else if (name.startsWith("is")) {
                name = name.substring(2);
            }
            return Introspector.decapitalize(name);
        }
        return name;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isPersistable(@UnknownKeyFor @NonNull @Initialized Element member, @UnknownKeyFor @NonNull @Initialized AccessType accessType) {
        if (ProcessorSessionFactory.isStatic(member) || ProcessorSessionFactory.isTransient(member)) {
            return false;
        }
        if (member.getKind() == ElementKind.FIELD) {
            return accessType == AccessType.FIELD || ProcessorSessionFactory.hasAnnotation(member, "Access");
        }
        if (member.getKind() == ElementKind.METHOD) {
            return ProcessorSessionFactory.isGetterMethod((ExecutableElement)member) && (accessType == AccessType.PROPERTY || ProcessorSessionFactory.hasAnnotation(member, "Access"));
        }
        return false;
    }

    private static @UnknownKeyFor @NonNull @Initialized TypeMirror memberType(@UnknownKeyFor @NonNull @Initialized Element member) {
        if (member instanceof ExecutableElement) {
            return ((ExecutableElement)member).getReturnType();
        }
        if (member instanceof VariableElement) {
            return member.asType();
        }
        throw new IllegalArgumentException("Not a member");
    }

    public static @UnknownKeyFor @NonNull @Initialized Element asElement(@UnknownKeyFor @NonNull @Initialized TypeMirror type) {
        if (type == null) {
            return null;
        }
        switch (type.getKind()) {
            case DECLARED: {
                return ((DeclaredType)type).asElement();
            }
            case TYPEVAR: {
                return ((TypeVariable)type).asElement();
            }
        }
        return null;
    }

    public static abstract class ElementCollectionPersister
    extends MockCollectionPersister {
        private final @UnknownKeyFor @NonNull @Initialized TypeElement elementType;
        private final @UnknownKeyFor @NonNull @Initialized AccessType defaultAccessType;

        public ElementCollectionPersister(@UnknownKeyFor @NonNull @Initialized String role, @UnknownKeyFor @NonNull @Initialized CollectionType collectionType, @UnknownKeyFor @NonNull @Initialized TypeElement elementType, @UnknownKeyFor @NonNull @Initialized String propertyPath, @UnknownKeyFor @NonNull @Initialized AccessType defaultAccessType, @UnknownKeyFor @NonNull @Initialized ProcessorSessionFactory that) {
            super(role, collectionType, ProcessorSessionFactory.elementCollectionElementType(elementType, role, propertyPath, defaultAccessType), that);
            this.elementType = elementType;
            this.defaultAccessType = defaultAccessType;
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized Type getElementPropertyType(@UnknownKeyFor @NonNull @Initialized String propertyPath) {
            Element symbol = ProcessorSessionFactory.findPropertyByPath(this.elementType, propertyPath, this.defaultAccessType);
            return symbol == null ? null : ProcessorSessionFactory.propertyType(symbol, this.getOwnerEntityName(), propertyPath, this.defaultAccessType);
        }
    }

    public static abstract class ToManyAssociationPersister
    extends MockCollectionPersister {
        public ToManyAssociationPersister(@UnknownKeyFor @NonNull @Initialized String role, @UnknownKeyFor @NonNull @Initialized CollectionType collectionType, @UnknownKeyFor @NonNull @Initialized String targetEntityName, @UnknownKeyFor @NonNull @Initialized ProcessorSessionFactory that) {
            super(role, collectionType, (Type)new ManyToOneType(MockSessionFactory.typeConfiguration, targetEntityName), that);
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized Type getElementPropertyType(@UnknownKeyFor @NonNull @Initialized String propertyPath) {
            return this.getElementPersister().getPropertyType(propertyPath);
        }
    }

    public static abstract class EntityPersister
    extends MockEntityPersister {
        private final @UnknownKeyFor @NonNull @Initialized TypeElement type;
        private final @UnknownKeyFor @NonNull @Initialized Types typeUtil;

        public EntityPersister(@UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized TypeElement type, @UnknownKeyFor @NonNull @Initialized ProcessorSessionFactory that) {
            super(entityName, ProcessorSessionFactory.getDefaultAccessType(type), that);
            this.type = type;
            this.typeUtil = that.typeUtil;
            this.initSubclassPersisters();
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized boolean isSubclassPersister(@UnknownKeyFor @NonNull @Initialized MockEntityPersister entityPersister) {
            EntityPersister persister = (EntityPersister)entityPersister;
            return this.typeUtil.isSubtype(persister.type.asType(), this.type.asType());
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized Type createPropertyType(@UnknownKeyFor @NonNull @Initialized String propertyPath) {
            Element symbol = ProcessorSessionFactory.findPropertyByPath(this.type, propertyPath, this.defaultAccessType);
            return symbol == null ? null : ProcessorSessionFactory.propertyType(symbol, this.getEntityName(), propertyPath, this.defaultAccessType);
        }
    }

    public static abstract class Component
    implements CompositeType {
        private final @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] propertyNames;
        private final @UnknownKeyFor @NonNull @Initialized Type @UnknownKeyFor @NonNull @Initialized [] propertyTypes;
        @UnknownKeyFor @NonNull @Initialized TypeElement type;

        public Component(@UnknownKeyFor @NonNull @Initialized TypeElement type, @UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized String path, @UnknownKeyFor @NonNull @Initialized AccessType defaultAccessType) {
            this.type = type;
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<Type> types = new ArrayList<Type>();
            while (type != null) {
                if (ProcessorSessionFactory.isMappedClass(type)) {
                    AccessType accessType = ProcessorSessionFactory.getAccessType(type, defaultAccessType);
                    for (Element element : type.getEnclosedElements()) {
                        String name;
                        Type propertyType;
                        if (!ProcessorSessionFactory.isPersistable(element, accessType) || (propertyType = ProcessorSessionFactory.propertyType(element, entityName, StringHelper.qualify((String)path, (String)(name = ProcessorSessionFactory.propertyName(element))), defaultAccessType)) == null) continue;
                        names.add(name);
                        types.add(propertyType);
                    }
                }
                type = (TypeElement)ProcessorSessionFactory.asElement(type.getSuperclass());
            }
            this.propertyNames = names.toArray(new String[0]);
            this.propertyTypes = types.toArray(new Type[0]);
        }

        public @UnknownKeyFor @NonNull @Initialized int getPropertyIndex(@UnknownKeyFor @NonNull @Initialized String name) {
            String[] names = this.getPropertyNames();
            int max = names.length;
            for (int i = 0; i < max; ++i) {
                if (!names[i].equals(name)) continue;
                return i;
            }
            throw new PropertyNotFoundException("Could not resolve attribute '" + name + "' of '" + this.getName() + "'");
        }

        public @UnknownKeyFor @NonNull @Initialized String getName() {
            return this.type.getSimpleName().toString();
        }

        public @UnknownKeyFor @NonNull @Initialized boolean isComponentType() {
            return true;
        }

        public @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] getPropertyNames() {
            return this.propertyNames;
        }

        public @UnknownKeyFor @NonNull @Initialized Type @UnknownKeyFor @NonNull @Initialized [] getSubtypes() {
            return this.propertyTypes;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean @UnknownKeyFor @NonNull @Initialized [] getPropertyNullability() {
            return new boolean[this.propertyNames.length];
        }

        public @UnknownKeyFor @NonNull @Initialized int getColumnSpan(@UnknownKeyFor @NonNull @Initialized Mapping mapping) {
            return this.propertyNames.length;
        }
    }
}

