/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen.annotation;

import java.util.List;
import java.util.Locale;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.jpamodelgen.annotation.AbstractQueryMethod;
import org.hibernate.jpamodelgen.annotation.AnnotationMetaEntity;
import org.hibernate.jpamodelgen.util.StringUtil;

public abstract class AbstractFinderMethod
extends AbstractQueryMethod {
    final @UnknownKeyFor @NonNull @Initialized String entity;
    final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> fetchProfiles;

    public AbstractFinderMethod(@UnknownKeyFor @NonNull @Initialized AnnotationMetaEntity annotationMetaEntity, @UnknownKeyFor @NonNull @Initialized String methodName, @UnknownKeyFor @NonNull @Initialized String entity, @UnknownKeyFor @NonNull @Initialized boolean belongsToDao, @UnknownKeyFor @NonNull @Initialized String sessionType, @UnknownKeyFor @NonNull @Initialized String sessionName, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> fetchProfiles, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramNames, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes, @UnknownKeyFor @NonNull @Initialized boolean addNonnullAnnotation) {
        super(annotationMetaEntity, methodName, paramNames, paramTypes, entity, sessionType, sessionName, belongsToDao, addNonnullAnnotation);
        this.entity = entity;
        this.fetchProfiles = fetchProfiles;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean hasTypedAttribute() {
        return true;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean hasStringAttribute() {
        return false;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getTypeDeclaration() {
        return this.entity;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getAttributeNameDeclarationString() {
        return "public static final String " + this.constantName() + " = \"!" + this.annotationMetaEntity.getQualifiedName() + '.' + this.methodName + "(" + this.parameterList() + ")" + "\";";
    }

    @UnknownKeyFor @NonNull @Initialized String constantName() {
        return StringUtil.getUpperUnderscoreCaseFromLowerCamelCase(this.methodName) + "_BY_" + this.paramNames.stream().map(StringHelper::unqualify).map(name -> name.toUpperCase(Locale.ROOT)).reduce((x, y) -> x + "_AND_" + y).orElse("");
    }

    void comment(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        declaration.append("\n/**").append("\n * Find ").append("{@link ").append(this.annotationMetaEntity.importType(this.entity)).append("} by ");
        long paramCount = this.paramTypes.stream().filter(type -> !AbstractFinderMethod.isOrderParam(type) && !AbstractFinderMethod.isPageParam(type) && !AbstractFinderMethod.isSessionParameter(type)).count();
        int count = 0;
        for (int i = 0; i < this.paramTypes.size(); ++i) {
            String type2 = (String)this.paramTypes.get(i);
            if (AbstractFinderMethod.isPageParam(type2) || AbstractFinderMethod.isOrderParam(type2) || AbstractFinderMethod.isSessionParameter(type2)) continue;
            if (count > 0) {
                if ((long)(count + 1) == paramCount) {
                    declaration.append(paramCount > 2L ? ", and " : " and ");
                } else {
                    declaration.append(", ");
                }
            }
            ++count;
            String path = ((String)this.paramNames.get(i)).replace('$', '.');
            declaration.append("{@link ").append(this.annotationMetaEntity.importType(this.entity)).append('#').append(this.qualifier(path)).append(' ').append(path).append("}");
        }
        declaration.append('.').append("\n *");
        this.see(declaration);
        declaration.append("\n **/\n");
    }

    @UnknownKeyFor @NonNull @Initialized String qualifier(@UnknownKeyFor @NonNull @Initialized String name) {
        int index = name.indexOf(36);
        return index > 0 ? name.substring(0, index) : name;
    }

    void unwrapSession(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        if (this.isUsingEntityManager()) {
            declaration.append(".unwrap(").append(this.annotationMetaEntity.importType("org.hibernate.Session")).append(".class)\n\t\t\t");
        }
    }

    void enableFetchProfile(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        for (String profile : this.fetchProfiles) {
            declaration.append("\n\t\t\t.enableFetchProfile(").append(profile).append(")");
        }
    }

    void preamble(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        this.modifiers(declaration);
        this.entityType(declaration);
        declaration.append(" ").append(this.methodName);
        this.parameters(this.paramTypes, declaration);
        declaration.append(" {").append("\n\treturn ").append(this.sessionName);
    }

    private void entityType(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        if (this.isReactive()) {
            declaration.append(this.annotationMetaEntity.importType("io.smallrye.mutiny.Uni")).append('<');
        }
        declaration.append(this.annotationMetaEntity.importType(this.entity));
        if (this.isReactive()) {
            declaration.append('>');
        }
    }

    void modifiers(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        declaration.append(this.belongsToDao ? "@Override\npublic " : "public static ");
    }
}

