/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.jpamodelgen.model.ImportContext;

public class ImportContextImpl
implements ImportContext {
    private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> imports = new TreeSet<String>();
    private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> staticImports = new TreeSet<String>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> simpleNames = new HashMap<String, String>();
    private @UnknownKeyFor @NonNull @Initialized String basePackage = "";
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> PRIMITIVES = new HashMap<String, String>();

    public ImportContextImpl(@UnknownKeyFor @NonNull @Initialized String basePackage) {
        this.basePackage = basePackage;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String importType(@UnknownKeyFor @NonNull @Initialized String typeExpression) {
        int index;
        int index2;
        String result = typeExpression;
        String preamble = "";
        if (result.startsWith("@")) {
            index2 = result.lastIndexOf(32);
            if (index2 > 0) {
                preamble = result.substring(0, index2 + 1);
                result = result.substring(index2 + 1);
            }
        } else if (result.startsWith("?")) {
            for (index2 = 1; index2 < result.length() && Character.isWhitespace(result.charAt(index2)); ++index2) {
            }
            if (index2 < result.length()) {
                int nextIndex = -1;
                if (result.substring(index2).startsWith("extends")) {
                    nextIndex = index2 + 7;
                } else if (result.substring(index2).startsWith("super")) {
                    nextIndex = index2 + 5;
                }
                if (nextIndex > 0 && nextIndex < result.length() && Character.isWhitespace(result.charAt(nextIndex))) {
                    index2 = nextIndex;
                    while (Character.isWhitespace(result.charAt(index2))) {
                        ++index2;
                    }
                    preamble = result.substring(0, index2);
                    result = this.importType(result.substring(index2));
                }
            }
        }
        Object appendices = "";
        if (result.indexOf(60) >= 0) {
            int startIndex = result.indexOf(60);
            int endIndex = result.lastIndexOf(62);
            appendices = "<" + this.importTypes(result.substring(startIndex + 1, endIndex)) + ">" + result.substring(endIndex + 1);
            result = result.substring(0, startIndex);
        } else if (result.indexOf(91) >= 0) {
            index = result.indexOf(91);
            appendices = result.substring(index);
            result = result.substring(0, index);
        } else if (result.endsWith("...")) {
            appendices = "...";
            index = result.indexOf("...");
            result = result.substring(0, index);
        }
        return (preamble + this.unqualifyName(result) + (String)appendices).replace('$', '.');
    }

    private @UnknownKeyFor @NonNull @Initialized String unqualifyName(@UnknownKeyFor @NonNull @Initialized String qualifiedName) {
        boolean canBeSimple;
        String sourceQualifiedName = qualifiedName.replace('$', '.');
        String simpleName = ImportContextImpl.unqualify(qualifiedName);
        if (this.simpleNames.containsKey(simpleName)) {
            String existing = this.simpleNames.get(simpleName);
            canBeSimple = existing.equals(sourceQualifiedName);
        } else {
            canBeSimple = true;
            this.simpleNames.put(simpleName, sourceQualifiedName);
            this.imports.add(sourceQualifiedName);
        }
        if (this.inSamePackage(qualifiedName) || this.inJavaLang(qualifiedName) || canBeSimple && this.imports.contains(sourceQualifiedName)) {
            return ImportContextImpl.unqualify(qualifiedName);
        }
        return qualifiedName;
    }

    private @UnknownKeyFor @NonNull @Initialized String importTypes(@UnknownKeyFor @NonNull @Initialized String originalArgList) {
        StringBuilder argList = new StringBuilder();
        StringBuilder acc = new StringBuilder();
        StringTokenizer args = new StringTokenizer(originalArgList, ",");
        while (args.hasMoreTokens()) {
            if (acc.length() > 0) {
                acc.append(',');
            }
            acc.append(args.nextToken());
            int nesting = 0;
            block5: for (int i = 0; i < acc.length(); ++i) {
                switch (acc.charAt(i)) {
                    case '<': {
                        ++nesting;
                        continue block5;
                    }
                    case '>': {
                        --nesting;
                    }
                }
            }
            if (nesting != 0) continue;
            if (argList.length() > 0) {
                argList.append(',');
            }
            argList.append(this.importType(acc.toString()));
            acc.setLength(0);
        }
        return argList.toString();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String staticImport(@UnknownKeyFor @NonNull @Initialized String fqcn, @UnknownKeyFor @NonNull @Initialized String member) {
        String local = fqcn + "." + member;
        this.imports.add(local);
        this.staticImports.add(local);
        if (member.equals("*")) {
            return "";
        }
        return member;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean inDefaultPackage(@UnknownKeyFor @NonNull @Initialized String className) {
        return className.indexOf(46) < 0;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isPrimitive(@UnknownKeyFor @NonNull @Initialized String className) {
        return PRIMITIVES.containsKey(className);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean inSamePackage(@UnknownKeyFor @NonNull @Initialized String className) {
        return Objects.equals(ImportContextImpl.qualifier(className), this.basePackage);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean inJavaLang(@UnknownKeyFor @NonNull @Initialized String className) {
        return "java.lang".equals(ImportContextImpl.qualifier(className));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String generateImports() {
        StringBuilder builder = new StringBuilder();
        for (String next : this.imports) {
            if (this.isAutoImported(next)) continue;
            if (this.staticImports.contains(next)) {
                builder.append("import static ").append(next).append(";").append(System.lineSeparator());
                continue;
            }
            builder.append("import ").append(next).append(";").append(System.lineSeparator());
        }
        if (builder.indexOf("$") >= 0) {
            return builder.toString();
        }
        return builder.toString();
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isAutoImported(@UnknownKeyFor @NonNull @Initialized String next) {
        return this.isPrimitive(next) || this.inDefaultPackage(next) || this.inJavaLang(next) || this.inSamePackage(next);
    }

    public static @UnknownKeyFor @NonNull @Initialized String unqualify(@UnknownKeyFor @NonNull @Initialized String qualifiedName) {
        int loc = qualifiedName.lastIndexOf(46);
        return loc < 0 ? qualifiedName : qualifiedName.substring(qualifiedName.lastIndexOf(46) + 1);
    }

    public static @UnknownKeyFor @NonNull @Initialized String qualifier(@UnknownKeyFor @NonNull @Initialized String qualifiedName) {
        int loc = qualifiedName.lastIndexOf(46);
        return loc < 0 ? "" : qualifiedName.substring(0, loc);
    }

    static {
        PRIMITIVES.put("char", "Character");
        PRIMITIVES.put("byte", "Byte");
        PRIMITIVES.put("short", "Short");
        PRIMITIVES.put("int", "Integer");
        PRIMITIVES.put("long", "Long");
        PRIMITIVES.put("boolean", "Boolean");
        PRIMITIVES.put("float", "Float");
        PRIMITIVES.put("double", "Double");
    }
}

