/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen.annotation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.hibernate.jpamodelgen.Context;
import org.hibernate.jpamodelgen.ImportContextImpl;
import org.hibernate.jpamodelgen.annotation.AnnotationMetaAttribute;
import org.hibernate.jpamodelgen.annotation.MetaAttributeGenerationVisitor;
import org.hibernate.jpamodelgen.model.ImportContext;
import org.hibernate.jpamodelgen.model.MetaAttribute;
import org.hibernate.jpamodelgen.model.MetaEntity;
import org.hibernate.jpamodelgen.util.AccessType;
import org.hibernate.jpamodelgen.util.AccessTypeInformation;
import org.hibernate.jpamodelgen.util.NullnessUtil;
import org.hibernate.jpamodelgen.util.TypeUtils;

public class AnnotationMetaEntity
implements MetaEntity {
    private final @UnknownKeyFor @NonNull @Initialized ImportContext importContext;
    private final @UnknownKeyFor @NonNull @Initialized TypeElement element;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized MetaAttribute> members;
    private final @UnknownKeyFor @NonNull @Initialized Context context;
    private @UnknownKeyFor @NonNull @Initialized AccessTypeInformation entityAccessTypeInfo;
    private @UnknownKeyFor @NonNull @Initialized boolean initialized;
    private @UnknownKeyFor @NonNull @Initialized MetaEntity entityToMerge;

    public AnnotationMetaEntity(@UnknownKeyFor @NonNull @Initialized TypeElement element, @UnknownKeyFor @NonNull @Initialized Context context) {
        this.element = element;
        this.context = context;
        this.members = new HashMap<String, MetaAttribute>();
        this.importContext = new ImportContextImpl(AnnotationMetaEntity.getPackageName(context, element));
    }

    public static @UnknownKeyFor @NonNull @Initialized AnnotationMetaEntity create(@UnknownKeyFor @NonNull @Initialized TypeElement element, @UnknownKeyFor @NonNull @Initialized Context context, @UnknownKeyFor @NonNull @Initialized boolean lazilyInitialised) {
        AnnotationMetaEntity annotationMetaEntity = new AnnotationMetaEntity(element, context);
        if (!lazilyInitialised) {
            annotationMetaEntity.init();
        }
        return annotationMetaEntity;
    }

    public @UnknownKeyFor @NonNull @Initialized AccessTypeInformation getEntityAccessTypeInfo() {
        return this.entityAccessTypeInfo;
    }

    public final @UnknownKeyFor @NonNull @Initialized Context getContext() {
        return this.context;
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized String getSimpleName() {
        return this.element.getSimpleName().toString();
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized String getQualifiedName() {
        return this.element.getQualifiedName().toString();
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized String getPackageName() {
        return AnnotationMetaEntity.getPackageName(this.context, this.element);
    }

    private static @UnknownKeyFor @NonNull @Initialized String getPackageName(@UnknownKeyFor @NonNull @Initialized Context context, @UnknownKeyFor @NonNull @Initialized TypeElement element) {
        PackageElement packageOf = context.getElementUtils().getPackageOf(element);
        return context.getElementUtils().getName(packageOf.getQualifiedName()).toString();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized MetaAttribute> getMembers() {
        if (!this.initialized) {
            this.init();
            if (this.entityToMerge != null) {
                this.mergeInMembers(this.entityToMerge.getMembers());
            }
        }
        return new ArrayList<MetaAttribute>(this.members.values());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isMetaComplete() {
        return false;
    }

    private void mergeInMembers(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized MetaAttribute> attributes) {
        for (MetaAttribute attribute : attributes) {
            this.importType(attribute.getMetaType());
            this.importType(attribute.getTypeDeclaration());
            this.members.put(attribute.getPropertyName(), attribute);
        }
    }

    public void mergeInMembers(@UnknownKeyFor @NonNull @Initialized MetaEntity other) {
        if (!this.initialized) {
            this.entityToMerge = other;
        } else {
            this.mergeInMembers(other.getMembers());
        }
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized String generateImports() {
        return this.importContext.generateImports();
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized String importType(@UnknownKeyFor @NonNull @Initialized String fqcn) {
        return this.importContext.importType(fqcn);
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized String staticImport(@UnknownKeyFor @NonNull @Initialized String fqcn, @UnknownKeyFor @NonNull @Initialized String member) {
        return this.importContext.staticImport(fqcn, member);
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized TypeElement getTypeElement() {
        return this.element;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AnnotationMetaEntity");
        sb.append("{element=").append(this.element);
        sb.append(", members=").append(this.members);
        sb.append('}');
        return sb.toString();
    }

    protected @UnknownKeyFor @NonNull @Initialized TypeElement getElement() {
        return this.element;
    }

    protected final void init() {
        this.getContext().logMessage(Diagnostic.Kind.OTHER, "Initializing type " + this.getQualifiedName() + ".");
        TypeUtils.determineAccessTypeForHierarchy(this.element, this.context);
        AccessTypeInformation accessTypeInfo = this.context.getAccessTypeInfo(this.getQualifiedName());
        this.entityAccessTypeInfo = NullnessUtil.castNonNull(accessTypeInfo);
        List<VariableElement> fieldsOfClass = ElementFilter.fieldsIn(this.element.getEnclosedElements());
        this.addPersistentMembers(fieldsOfClass, AccessType.FIELD);
        List<ExecutableElement> methodsOfClass = ElementFilter.methodsIn(this.element.getEnclosedElements());
        ArrayList<Element> gettersAndSettersOfClass = new ArrayList<Element>();
        for (Element element : methodsOfClass) {
            if (!this.isGetterOrSetter(element)) continue;
            gettersAndSettersOfClass.add(element);
        }
        this.addPersistentMembers(gettersAndSettersOfClass, AccessType.PROPERTY);
        this.initialized = true;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isGetterOrSetter(@UnknownKeyFor @NonNull @Initialized Element methodOfClass) {
        ExecutableType methodType = (ExecutableType)methodOfClass.asType();
        String methodSimpleName = methodOfClass.getSimpleName().toString();
        List<? extends TypeMirror> methodParameterTypes = methodType.getParameterTypes();
        TypeMirror returnType = methodType.getReturnType();
        if (methodSimpleName.startsWith("set") && methodParameterTypes.size() == 1 && "void".equalsIgnoreCase(returnType.toString())) {
            return true;
        }
        return (methodSimpleName.startsWith("get") || methodSimpleName.startsWith("is")) && methodParameterTypes.isEmpty() && !"void".equalsIgnoreCase(returnType.toString());
    }

    private void addPersistentMembers(@UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Element> membersOfClass, @UnknownKeyFor @NonNull @Initialized AccessType membersKind) {
        for (Element element : membersOfClass) {
            AccessType forcedAccessType = TypeUtils.determineAnnotationSpecifiedAccessType(element);
            if (this.entityAccessTypeInfo.getAccessType() != membersKind && forcedAccessType == null || TypeUtils.containsAnnotation(element, "jakarta.persistence.Transient") || element.getModifiers().contains((Object)Modifier.TRANSIENT) || element.getModifiers().contains((Object)Modifier.STATIC)) continue;
            MetaAttributeGenerationVisitor visitor = new MetaAttributeGenerationVisitor(this, this.context);
            AnnotationMetaAttribute result = element.asType().accept(visitor, element);
            if (result == null) continue;
            this.members.put(result.getPropertyName(), result);
        }
    }
}

