/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hikaricp.internal;

import com.zaxxer.hikari.HikariConfig;
import java.util.Map;
import java.util.Properties;
import org.hibernate.engine.jdbc.connections.internal.ConnectionProviderInitiator;

public class HikariConfigurationUtil {
    public static final String CONFIG_PREFIX = "hibernate.hikari.";

    public static HikariConfig loadConfiguration(Map<String, Object> props) {
        Properties hikariProps = new Properties();
        HikariConfigurationUtil.copyProperty("hibernate.connection.autocommit", props, "autoCommit", hikariProps);
        HikariConfigurationUtil.copyProperty("hibernate.connection.driver_class", props, "driverClassName", hikariProps);
        HikariConfigurationUtil.copyProperty("hibernate.connection.url", props, "jdbcUrl", hikariProps);
        HikariConfigurationUtil.copyProperty("hibernate.connection.username", props, "username", hikariProps);
        HikariConfigurationUtil.copyProperty("hibernate.connection.password", props, "password", hikariProps);
        HikariConfigurationUtil.copyIsolationSetting(props, hikariProps);
        for (String key : props.keySet()) {
            if (!key.startsWith(CONFIG_PREFIX)) continue;
            hikariProps.setProperty(key.substring(CONFIG_PREFIX.length()), (String)props.get(key));
        }
        return new HikariConfig(hikariProps);
    }

    private static void copyProperty(String srcKey, Map<String, Object> src, String dstKey, Properties dst) {
        if (src.containsKey(srcKey)) {
            dst.setProperty(dstKey, (String)src.get(srcKey));
        }
    }

    private static void copyIsolationSetting(Map<String, Object> props, Properties hikariProps) {
        Integer isolation = ConnectionProviderInitiator.extractIsolation(props);
        if (isolation != null) {
            hikariProps.put("transactionIsolation", ConnectionProviderInitiator.toIsolationConnectionConstantName((Integer)isolation));
        }
    }
}

