/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.envers.internal.entities.ComponentDescription;
import org.hibernate.envers.internal.entities.EntityConfiguration;
import org.hibernate.envers.internal.entities.RelationDescription;
import org.hibernate.envers.internal.entities.RelationType;

public class EntitiesConfigurations {
    private Map<String, EntityConfiguration> entitiesConfigurations;
    private Map<String, EntityConfiguration> notAuditedEntitiesConfigurations;
    private Map<String, String> entityNamesForVersionsEntityNames = new HashMap<String, String>();

    public EntitiesConfigurations(Map<String, EntityConfiguration> entitiesConfigurations, Map<String, EntityConfiguration> notAuditedEntitiesConfigurations) {
        this.entitiesConfigurations = entitiesConfigurations;
        this.notAuditedEntitiesConfigurations = notAuditedEntitiesConfigurations;
        this.generateBidirectionRelationInfo();
        this.generateVersionsEntityToEntityNames();
    }

    private void generateVersionsEntityToEntityNames() {
        this.entityNamesForVersionsEntityNames = new HashMap<String, String>();
        for (Map.Entry<String, EntityConfiguration> entry : this.entitiesConfigurations.entrySet()) {
            this.entityNamesForVersionsEntityNames.put(entry.getValue().getVersionsEntityName(), entry.getKey());
        }
    }

    private void generateBidirectionRelationInfo() {
        for (Map.Entry<String, EntityConfiguration> entry : this.entitiesConfigurations.entrySet()) {
            String entityName = entry.getKey();
            EntityConfiguration entCfg = entry.getValue();
            for (RelationDescription relDesc : entCfg.getRelationsIterator()) {
                EntityConfiguration entityConfiguration;
                if (relDesc.getRelationType() != RelationType.TO_ONE && relDesc.getRelationType() != RelationType.TO_MANY_MIDDLE || (entityConfiguration = this.entitiesConfigurations.get(relDesc.getToEntityName())) == null) continue;
                for (RelationDescription other : entityConfiguration.getRelationsIterator()) {
                    if (!relDesc.getFromPropertyName().equals(other.getMappedByPropertyName()) || !entityName.equals(other.getToEntityName())) continue;
                    relDesc.setBidirectional(true);
                    other.setBidirectional(true);
                }
            }
        }
    }

    public EntityConfiguration get(String entityName) {
        return this.entitiesConfigurations.get(entityName);
    }

    public EntityConfiguration getNotVersionEntityConfiguration(String entityName) {
        return this.notAuditedEntitiesConfigurations.get(entityName);
    }

    public String getEntityNameForVersionsEntityName(String versionsEntityName) {
        return this.entityNamesForVersionsEntityNames.get(versionsEntityName);
    }

    public boolean isVersioned(String entityName) {
        return this.get(entityName) != null;
    }

    public boolean hasAuditedEntities() {
        return this.entitiesConfigurations.size() != 0;
    }

    public RelationDescription getRelationDescription(String entityName, String propertyName) {
        EntityConfiguration entCfg = this.isVersioned(entityName) ? this.get(entityName) : this.getNotVersionEntityConfiguration(entityName);
        RelationDescription relDesc = entCfg.getRelationDescription(propertyName);
        if (relDesc != null) {
            return relDesc;
        }
        if (entCfg.getParentEntityName() != null) {
            return this.getRelationDescription(entCfg.getParentEntityName(), propertyName);
        }
        return null;
    }

    private Collection<RelationDescription> getRelationDescriptions(String entityName) {
        EntityConfiguration entCfg = this.entitiesConfigurations.get(entityName);
        ArrayList<RelationDescription> descriptions = new ArrayList<RelationDescription>();
        if (entCfg.getParentEntityName() != null) {
            descriptions.addAll(this.getRelationDescriptions(entCfg.getParentEntityName()));
        }
        for (RelationDescription relationDescription : entCfg.getRelationsIterator()) {
            descriptions.add(relationDescription);
        }
        return descriptions;
    }

    public ComponentDescription getComponentDescription(String entityName, String propertyName) {
        EntityConfiguration entCfg = this.isVersioned(entityName) ? this.get(entityName) : this.getNotVersionEntityConfiguration(entityName);
        ComponentDescription relDesc = entCfg.getComponentDescription(propertyName);
        if (relDesc != null) {
            return relDesc;
        }
        if (entCfg.getParentEntityName() != null) {
            return this.getComponentDescription(entCfg.getParentEntityName(), propertyName);
        }
        return null;
    }

    private void addWithParentEntityNames(String entityName, Set<String> entityNames) {
        entityNames.add(entityName);
        EntityConfiguration entCfg = this.entitiesConfigurations.get(entityName);
        if (entCfg.getParentEntityName() != null) {
            this.addWithParentEntityNames(entCfg.getParentEntityName(), entityNames);
        }
    }

    private Set<String> getEntityAndParentsNames(String entityName) {
        HashSet<String> names = new HashSet<String>();
        this.addWithParentEntityNames(entityName, names);
        return names;
    }

    public Set<String> getToPropertyNames(String fromEntityName, String fromPropertyName, String toEntityName) {
        Set<String> entityAndParentsNames = this.getEntityAndParentsNames(fromEntityName);
        HashSet<String> toPropertyNames = new HashSet<String>();
        for (RelationDescription relationDescription : this.getRelationDescriptions(toEntityName)) {
            String relToEntityName = relationDescription.getToEntityName();
            String mappedByPropertyName = relationDescription.getMappedByPropertyName();
            if (!entityAndParentsNames.contains(relToEntityName) || mappedByPropertyName == null || !mappedByPropertyName.equals(fromPropertyName)) continue;
            toPropertyNames.add(relationDescription.getFromPropertyName());
        }
        return toPropertyNames;
    }
}

